/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateHandler;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiDataObject multiDataObject2 = multiDataObject;
        multiDataObject2.getClass();
        super(multiDataObject2, fileObject);
    }

    public FileObject copy(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.getFile();
        String string2 = fileObject2.getName() + string;
        return fileObject2.copy(fileObject, string2, fileObject2.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject rename(String string) throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().rename(fileLock, string, this.getFile().getExt());
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
        return this.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileObject fileObject, String string) throws IOException {
        boolean bl = this.isLocked();
        FileObject fileObject2 = this.getFile();
        FileLock fileLock = this.takeLock();
        try {
            FileObject fileObject3;
            String string2 = fileObject2.getName() + string;
            FileObject fileObject4 = fileObject3 = fileObject2.move(fileLock, fileObject, string2, fileObject2.getExt());
            return fileObject4;
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().delete(fileLock);
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
    }

    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)this.getFile().getExt());
        }
        FileObject fileObject2 = null;
        for (CreateFromTemplateHandler createFromTemplateHandler : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
            if (!createFromTemplateHandler.accept(this.getFile())) continue;
            fileObject2 = createFromTemplateHandler.createFromTemplate(this.getFile(), fileObject, string, DataObject.CreateAction.findParameters(string));
            assert (fileObject2 != null);
            break;
        }
        if (fileObject2 == null) {
            fileObject2 = this.getFile().copy(fileObject, string, this.getFile().getExt());
        }
        DataObject.setTemplate(fileObject2, false);
        return fileObject2;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        public FileObject copy(FileObject fileObject, String string) throws IOException {
            String string2 = string + (this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)(this.getFile().getName() + string2));
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            return fileObject2;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            return this.copy(fileObject, string);
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)this.getFile().getExt());
            }
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject rename(String string) throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().rename(fileLock, string, null);
            }
            finally {
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
            return this.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
            }
            finally {
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            Object object2;
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = null;
            for (Object object2 : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
                if (!((CreateFromTemplateHandler)object2).accept(this.getFile())) continue;
                fileObject2 = ((CreateFromTemplateHandler)object2).createFromTemplate(this.getFile(), fileObject, string, DataObject.CreateAction.findParameters(string));
                assert (fileObject2 != null);
                break;
            }
            if (fileObject2 != null) {
                DataObject.setTemplate(fileObject2, false);
                return fileObject2;
            }
            fileObject2 = fileObject.createData(string, string2);
            java.text.Format format = this.createFormat(fileObject, string, string2);
            object2 = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.newLine();
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                ((BufferedReader)object2).close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;

        public Numb(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        public boolean isImportant() {
            return false;
        }

        public FileObject copy(FileObject fileObject, String string) {
            return null;
        }

        public FileObject rename(String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public void delete() throws IOException {
            this.stdBehaving();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(FileEntry.class).getString("EXC_SharedAccess"));
            }
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) {
            return null;
        }
    }
}

