/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

class FolderComparator
extends DataFolder.SortMode {
    public static final int NONE = 0;
    public static final int NAMES = 1;
    public static final int CLASS = 2;
    public static final int FOLDER_NAMES = 3;
    public static final int LAST_MODIFIED = 4;
    public static final int SIZE = 5;
    private int mode;

    public FolderComparator() {
        this(3);
    }

    public FolderComparator(int n) {
        this.mode = n;
    }

    public int compare(Object object, Object object2) {
        DataObject dataObject;
        DataObject dataObject2;
        if (object instanceof Node) {
            dataObject2 = (DataObject)((Node)object).getCookie(DataObject.class);
            dataObject = (DataObject)((Node)object2).getCookie(DataObject.class);
        } else {
            dataObject2 = (DataObject)object;
            dataObject = (DataObject)object2;
        }
        switch (this.mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.compareNames(dataObject2, dataObject);
            }
            case 2: {
                return this.compareClass(dataObject2, dataObject);
            }
            case 3: {
                return this.compareFoldersFirst(dataObject2, dataObject);
            }
            case 4: {
                return FolderComparator.compareLastModified(dataObject2, dataObject);
            }
            case 5: {
                return FolderComparator.compareSize(dataObject2, dataObject);
            }
        }
        assert (false) : this.mode;
        return 0;
    }

    private int compareNames(DataObject dataObject, DataObject dataObject2) {
        int n = dataObject.getName().compareTo(dataObject2.getName());
        return n != 0 ? n : dataObject.getPrimaryFile().getExt().compareTo(dataObject2.getPrimaryFile().getExt());
    }

    private int compareFoldersFirst(DataObject dataObject, DataObject dataObject2) {
        if (dataObject.getClass() != dataObject2.getClass()) {
            if (dataObject instanceof DataFolder) {
                return -1;
            }
            if (dataObject2 instanceof DataFolder) {
                return 1;
            }
        }
        return this.compareNames(dataObject, dataObject2);
    }

    private int compareClass(DataObject dataObject, DataObject dataObject2) {
        Class<?> clazz;
        Class<?> clazz2 = dataObject.getClass();
        if (clazz2 == (clazz = dataObject2.getClass())) {
            return this.compareNames(dataObject, dataObject2);
        }
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        Enumeration<DataLoader> enumeration = dataLoaderPool.allLoaders();
        while (enumeration.hasMoreElements()) {
            Class<? extends DataObject> clazz3 = enumeration.nextElement().getRepresentationClass();
            if (clazz3 == DataObject.class) continue;
            boolean bl = clazz3.isAssignableFrom(clazz2);
            boolean bl2 = clazz3.isAssignableFrom(clazz);
            if (bl && bl2) {
                return this.compareNames(dataObject, dataObject2);
            }
            if (bl) {
                return -1;
            }
            if (!bl2) continue;
            return 1;
        }
        return this.compareNames(dataObject, dataObject2);
    }

    private static int compareLastModified(DataObject dataObject, DataObject dataObject2) {
        Date date;
        if (dataObject instanceof DataFolder) {
            if (dataObject2 instanceof DataFolder) {
                return dataObject.getName().compareTo(dataObject2.getName());
            }
            return -1;
        }
        if (dataObject2 instanceof DataFolder) {
            return 1;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject fileObject2 = dataObject2.getPrimaryFile();
        Date date2 = fileObject.lastModified();
        if (date2.after(date = fileObject2.lastModified())) {
            return -1;
        }
        if (date.after(date2)) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }

    private static int compareSize(DataObject dataObject, DataObject dataObject2) {
        long l;
        if (dataObject instanceof DataFolder) {
            if (dataObject2 instanceof DataFolder) {
                return dataObject.getName().compareTo(dataObject2.getName());
            }
            return -1;
        }
        if (dataObject2 instanceof DataFolder) {
            return 1;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject fileObject2 = dataObject2.getPrimaryFile();
        long l2 = fileObject.getSize();
        if (l2 > (l = fileObject2.getSize())) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }
}

