/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.FolderList;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderLookup
extends FolderInstance {
    private static final Object LOCK = new Object();
    private ProxyLkp lookup;
    private String rootName;
    private final boolean isRoot;

    public FolderLookup(DataObject.Container container) {
        this(container, "FL[");
    }

    public FolderLookup(DataObject.Container container, String string) {
        this(container, string, true);
    }

    private FolderLookup(DataObject.Container container, String string, boolean bl) {
        super(container);
        this.rootName = string;
        this.isRoot = bl;
    }

    @Override
    public final Class<?> instanceClass() {
        return ProxyLkp.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup getLookup() {
        boolean bl = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.lookup == null) {
                this.lookup = new ProxyLkp(this);
                bl = true;
            }
        }
        if (bl) {
            this.checkRecreate();
        }
        return this.lookup;
    }

    @Override
    protected final Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        FolderLookupData folderLookupData = new FolderLookupData();
        if (this.isRoot) {
            folderLookupData.lookups.add(null);
        }
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            try {
                Object object = instanceCookieArray[i].instanceCreate();
                if (object instanceof FolderLookupData) {
                    folderLookupData.items.addAll(((FolderLookupData)object).items);
                    folderLookupData.lookups.addAll(((FolderLookupData)object).lookups);
                    continue;
                }
                if (object instanceof Lookup) {
                    folderLookupData.lookups.add((Lookup)object);
                    continue;
                }
                folderLookupData.items.add((ICItem)((Object)object));
                continue;
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException);
            }
        }
        if (!this.isRoot) {
            return folderLookupData;
        }
        this.getLookup();
        this.lookup.update(folderLookupData.items, folderLookupData.lookups);
        return this.lookup;
    }

    @Override
    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        boolean bl = instanceCookie instanceof InstanceCookie.Of ? ((InstanceCookie.Of)instanceCookie).instanceOf(Lookup.class) : Lookup.class.isAssignableFrom(instanceCookie.instanceClass());
        if (bl) {
            return instanceCookie.instanceCreate();
        }
        return new ICItem(dataObject, this.rootName, instanceCookie);
    }

    @Override
    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return new FolderLookup(dataFolder, FolderLookup.objectName(this.rootName, dataFolder), false);
    }

    @Override
    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new FolderLookup(container, this.rootName == null ? "<container>" : this.rootName + "<container>", false);
    }

    @Override
    protected final Task postCreationTask(Runnable runnable) {
        runnable.run();
        return null;
    }

    private static String objectName(String string, DataObject dataObject) {
        if (string == null) {
            return dataObject.getName();
        }
        return string + '/' + dataObject.getName();
    }

    private static void exception(Exception exception) {
        Logger.getLogger(FolderLookup.class.getName()).log(Level.WARNING, null, exception);
    }

    private static void exception(Exception exception, FileObject fileObject) {
        Exceptions.attachMessage((Throwable)exception, (String)("Bad file: " + fileObject));
        FolderLookup.exception(exception);
    }

    private static class FolderLookupData {
        private Collection<ICItem> items = new ArrayList<ICItem>(30);
        private List<Lookup> lookups = new ArrayList<Lookup>(5);
    }

    private static final class ICItem
    extends AbstractLookup.Pair {
        static final long serialVersionUID = 10L;
        static final ThreadLocal<ICItem> DANGEROUS = new ThreadLocal();
        private static final Logger ERR = Logger.getLogger(ICItem.class.getName());
        private FileObject fo;
        private transient InstanceCookie ic;
        private transient DataObject obj;
        private transient Reference<Object> ref;
        private String rootName;

        public ICItem(DataObject dataObject, String string, InstanceCookie instanceCookie) {
            this.ic = instanceCookie;
            this.obj = dataObject;
            this.rootName = string;
            this.fo = dataObject.getPrimaryFile();
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("New ICItem: " + dataObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            if (this.ic != null) {
                return;
            }
            ICItem iCItem = DANGEROUS.get();
            try {
                DANGEROUS.set(this);
                if (this.obj == null) {
                    try {
                        this.obj = DataObject.find(this.fo);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        this.ic = new BrokenInstance("No DataObject for " + this.fo.getPath(), dataObjectNotFoundException);
                        DANGEROUS.set(iCItem);
                        return;
                    }
                }
                this.ic = this.obj.getCookie(InstanceCookie.class);
                if (this.ic == null) {
                    this.ic = new BrokenInstance("No cookie for " + this.fo.getPath(), null);
                }
            }
            finally {
                DANGEROUS.set(iCItem);
            }
        }

        protected boolean instanceOf(Class clazz) {
            this.init();
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("instanceOf: " + clazz.getName() + " obj: " + this.obj);
            }
            if (this.ic instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.ic;
                boolean bl = of.instanceOf(clazz);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  of: " + bl);
                }
                return bl;
            }
            try {
                boolean bl = clazz.isAssignableFrom(this.ic.instanceClass());
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  plain: " + bl);
                }
                return bl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException, this.fo);
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException, this.fo);
            }
            return false;
        }

        public Object getInstance() {
            this.init();
            try {
                Object object = this.ic.instanceCreate();
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  getInstance: " + object + " for " + this.obj);
                }
                this.ref = new WeakReference<Object>(object);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException, this.fo);
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException, this.fo);
            }
            return null;
        }

        public int hashCode() {
            this.init();
            return System.identityHashCode(this.ic);
        }

        public boolean equals(Object object) {
            if (object instanceof ICItem) {
                ICItem iCItem = (ICItem)((Object)object);
                iCItem.init();
                this.init();
                return this.ic == iCItem.ic;
            }
            return false;
        }

        public String getId() {
            this.init();
            if (this.obj == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return FolderLookup.objectName(this.rootName, this.obj);
        }

        public String getDisplayName() {
            this.init();
            if (this.obj == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return this.obj.getNodeDelegate().getDisplayName();
        }

        protected boolean creatorOf(Object object) {
            Reference<Object> reference = this.ref;
            if (reference != null && reference.get() == object) {
                return true;
            }
            if (this.obj instanceof InstanceDataObject) {
                return ((InstanceDataObject)this.obj).creatorOf(object);
            }
            return false;
        }

        public Class getType() {
            this.init();
            try {
                return this.ic.instanceClass();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return Object.class;
        }

        private static final class BrokenInstance
        implements InstanceCookie.Of {
            private final String message;
            private final Exception ex;

            public BrokenInstance(String string, Exception exception) {
                this.message = string;
                this.ex = exception;
            }

            public String instanceName() {
                return "java.lang.Object";
            }

            private ClassNotFoundException die() {
                if (this.ex != null) {
                    return new ClassNotFoundException(this.message, this.ex);
                }
                return new ClassNotFoundException(this.message);
            }

            public Class instanceClass() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public boolean instanceOf(Class clazz) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProxyLkp
    extends ProxyLookup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient FolderLookup fl;
        private transient AbstractLookup.Content content;
        private transient boolean readFromStream;

        public ProxyLkp(FolderLookup folderLookup) {
            this(folderLookup, new AbstractLookup.Content());
        }

        private ProxyLkp(FolderLookup folderLookup, AbstractLookup.Content content) {
            super(new Lookup[]{new AbstractLookup(content)});
            this.fl = folderLookup;
            this.content = content;
        }

        public String toString() {
            return "FolderLookup.lookup[\"" + this.fl.rootName + "\"]";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Lookup[] lookupArray = this.getLookups();
            for (int i = 0; i < lookupArray.length; ++i) {
                objectOutputStream.writeObject(lookupArray[i]);
            }
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(this.fl.folder);
            objectOutputStream.writeObject(this.fl.rootName);
            objectOutputStream.writeObject(this.content);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Lookup lookup;
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            while ((lookup = (Lookup)objectInputStream.readObject()) != null) {
                arrayList.add(lookup);
            }
            Lookup[] lookupArray = arrayList.toArray(new Lookup[arrayList.size()]);
            DataFolder dataFolder = (DataFolder)objectInputStream.readObject();
            String string = (String)objectInputStream.readObject();
            this.fl = new FolderLookup(dataFolder, string, true);
            this.fl.lookup = this;
            this.content = (AbstractLookup.Content)objectInputStream.readObject();
            this.setLookups(lookupArray);
            this.readFromStream = true;
            RequestProcessor.getDefault().post((Runnable)((Object)this.fl), 0, 1);
        }

        public void update(Collection<ICItem> collection, List<Lookup> list) {
            this.readFromStream = false;
            Lookup lookup = this.getLookups()[0];
            this.content.setPairs(collection);
            if (this.fl.err().isLoggable(Level.FINE)) {
                this.fl.err().fine("Changed pairs: " + collection);
            }
            list.set(0, lookup);
            Lookup[] lookupArray = list.toArray(new Lookup[list.size()]);
            this.setLookups(lookupArray);
            if (this.fl.err().isLoggable(Level.FINE)) {
                this.fl.err().fine("Changed lookups: " + list);
            }
        }

        protected void beforeLookup(Lookup.Template template) {
            if (this.readFromStream) {
                return;
            }
            if (!FolderList.isFolderRecognizerThread() && ICItem.DANGEROUS.get() == null) {
                if (!DataObjectPool.isConstructorAllowed()) {
                    this.fl.waitFinished();
                } else {
                    try {
                        while (!this.fl.waitFinished(10000L)) {
                            long l = DataObjectPool.getPOOL().timeInWaitNotified();
                            if (l <= 10000L) continue;
                            this.fl.err().log(Level.INFO, "Preventing deadlock #65543: Do not call FolderLookup from inside DataObject operations!", new Exception("Thread dump"));
                            return;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.fl.err().log(Level.WARNING, null, interruptedException);
                    }
                }
            }
        }

        public void waitFinished() {
            this.fl.waitFinished();
        }
    }
}

