/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class OpenSupport
extends CloneableOpenSupport {
    protected MultiDataObject.Entry entry;

    public OpenSupport(MultiDataObject.Entry entry) {
        this(entry, new Env(entry.getDataObject()));
    }

    protected OpenSupport(MultiDataObject.Entry entry, Env env) {
        super((CloneableOpenSupport.Env)env);
        this.entry = entry;
    }

    protected String messageOpening() {
        MultiDataObject multiDataObject = this.entry.getDataObject();
        return NbBundle.getMessage(OpenSupport.class, (String)"CTL_ObjectOpen", (Object)multiDataObject.getName(), (Object)multiDataObject.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(OpenSupport.class, (String)"CTL_ObjectOpened");
    }

    final CloneableTopComponent.Ref allEditors() {
        return this.allEditors;
    }

    public static class Env
    implements CloneableOpenSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -1934890789745432531L;
        private DataObject obj;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        private static final Map<FileSystem, Reference<FileSystemNameListener>> fsListenerMap = new WeakHashMap<FileSystem, Reference<FileSystemNameListener>>(30);
        private static final Object LOCK_SUPPORT = new Object();

        public Env(DataObject dataObject) {
            this.obj = dataObject;
            this.init();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            FileSystemNameListener fileSystemNameListener;
            FileSystem fileSystem;
            this.obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.obj));
            try {
                fileSystem = this.obj.getPrimaryFile().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw (IllegalStateException)new IllegalStateException("FileSystem is invalid for " + this.obj.getPrimaryFile() + "!").initCause(fileStateInvalidException);
            }
            boolean bl = false;
            Map<FileSystem, Reference<FileSystemNameListener>> map = fsListenerMap;
            synchronized (map) {
                Reference<FileSystemNameListener> reference = fsListenerMap.get(fileSystem);
                FileSystemNameListener fileSystemNameListener2 = fileSystemNameListener = reference == null ? null : reference.get();
                if (fileSystemNameListener == null) {
                    fileSystemNameListener = new FileSystemNameListener();
                    fsListenerMap.put(fileSystem, new WeakReference<FileSystemNameListener>(fileSystemNameListener));
                    bl = true;
                }
            }
            if (bl) {
                fileSystem.addPropertyChangeListener((PropertyChangeListener)fileSystemNameListener);
                fileSystem.addVetoableChangeListener((VetoableChangeListener)fileSystemNameListener);
            }
            fileSystemNameListener.add(this);
        }

        protected final DataObject getDataObject() {
            return this.obj;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().removeVetoableChangeListener(vetoableChangeListener);
        }

        public boolean isValid() {
            return this.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.getDataObject().isModified();
        }

        public void markModified() throws IOException {
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            OpenCookie openCookie = this.getDataObject().getCookie(OpenCookie.class);
            if (openCookie != null && openCookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)openCookie;
            }
            EditCookie editCookie = this.getDataObject().getCookie(EditCookie.class);
            if (editCookie != null && editCookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)editCookie;
            }
            EditorCookie editorCookie = this.getDataObject().getCookie(EditorCookie.class);
            if (editorCookie != null && editorCookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)editorCookie;
            }
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (this.getDataObject().isModified()) {
                    this.getDataObject().addVetoableChangeListener(this);
                } else {
                    this.getDataObject().removeVetoableChangeListener(this);
                }
            }
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            this.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            this.veto().fireVetoableChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
                return this.propSupp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.vetoSupp == null) {
                    this.vetoSupp = new VetoableChangeSupport(this);
                }
                return this.vetoSupp;
            }
        }
    }

    private static final class FileSystemNameListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private final Set<Env> environments = new WeakSet(30);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Env env) {
            Set<Env> set = this.environments;
            synchronized (set) {
                this.environments.add(env);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                HashSet<Env> hashSet;
                Set<Env> set = this.environments;
                synchronized (set) {
                    hashSet = new HashSet<Env>(this.environments);
                }
                for (Env env : hashSet) {
                    env.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                HashSet<Env> hashSet;
                Set<Env> set = this.environments;
                synchronized (set) {
                    hashSet = new HashSet<Env>(this.environments);
                }
                for (Env env : hashSet) {
                    env.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }
    }

    private static final class Listener
    extends CloneableTopComponent.Ref {
        static final long serialVersionUID = -1934890789745432531L;
        private MultiDataObject.Entry entry;

        Listener() {
        }

        public Object readResolve() {
            MultiDataObject multiDataObject = this.entry.getDataObject();
            OpenSupport openSupport = null;
            OpenCookie openCookie = ((DataObject)multiDataObject).getCookie(OpenCookie.class);
            if (openCookie != null && openCookie instanceof OpenSupport) {
                openSupport = (OpenSupport)openCookie;
            } else {
                EditCookie editCookie = ((DataObject)multiDataObject).getCookie(EditCookie.class);
                if (editCookie != null && editCookie instanceof OpenSupport) {
                    openSupport = (OpenSupport)editCookie;
                } else {
                    EditorCookie editorCookie = ((DataObject)multiDataObject).getCookie(EditorCookie.class);
                    if (editorCookie != null && editorCookie instanceof OpenSupport) {
                        openSupport = (OpenSupport)editorCookie;
                    }
                }
            }
            if (openSupport == null) {
                return this;
            }
            return openSupport.allEditors();
        }
    }
}

