/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WeakListenerImpl
implements EventListener {
    private ListenerReference ref;
    Class listenerClass;
    private Reference<Object> source;

    protected WeakListenerImpl(Class clazz, EventListener eventListener) {
        this.listenerClass = clazz;
        this.ref = new ListenerReference(eventListener, this);
    }

    protected final void setSource(Object object) {
        this.source = object == null ? null : new WeakReference<Object>(object);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject eventObject) {
        Object t = this.ref.get();
        if (t == null) {
            this.ref.requestCleanUp(eventObject == null ? null : eventObject.getSource());
        }
        return (EventListener)t;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object t = this.ref.get();
        return this.getClass().getName() + "[" + (t == null ? "null" : t.getClass().getName() + "]");
    }

    public static <T extends EventListener> T create(Class<T> clazz, Class<? super T> clazz2, T t, Object object) {
        ProxyListener proxyListener = new ProxyListener(clazz, clazz2, t);
        proxyListener.setSource(object);
        return (T)((EventListener)clazz.cast(proxyListener.proxy));
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        public Change(ChangeListener changeListener) {
            super(ChangeListener.class, changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ChangeListener changeListener = (ChangeListener)super.get(changeEvent);
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        public Document(DocumentListener documentListener) {
            super(DocumentListener.class, documentListener);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent documentEvent) {
            DocumentListener documentListener = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (documentListener == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(documentEvent.getDocument());
            }
            return documentListener;
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        public Focus(FocusListener focusListener) {
            super(FocusListener.class, focusListener);
        }

        public void focusGained(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListenerReference
    extends WeakReference<Object>
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        WeakListenerImpl weakListener;

        public ListenerReference(Object object, WeakListenerImpl weakListenerImpl) {
            super(object, Utilities.activeReferenceQueue());
            this.weakListener = weakListenerImpl;
        }

        public synchronized void requestCleanUp(Object object) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.source != object) {
                this.weakListener.source = new WeakReference<Object>(object){
                    ListenerReference doNotGCRef;
                    {
                        this.doNotGCRef = new ListenerReference(new Object(), ListenerReference.this.weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WeakListenerImpl weakListenerImpl;
            Object[] objectArray = new Object[1];
            Class[] classArray = new Class[1];
            Object object = null;
            Method method = null;
            Class<Object> clazz = this;
            synchronized (clazz) {
                block18: {
                    block17: {
                        weakListenerImpl = this.weakListener;
                        if (weakListenerImpl.source == null) break block17;
                        Object t = weakListenerImpl.source.get();
                        object = t;
                        if (t != null) break block18;
                    }
                    return;
                }
                this.weakListener = null;
            }
            clazz = object instanceof Class ? (Class)object : object.getClass();
            String string = weakListenerImpl.removeMethodName();
            Object object2 = LOCK;
            synchronized (object2) {
                if (lastClass == clazz && lastMethodName == string && lastRemove != null) {
                    method = lastRemove;
                }
            }
            if (method == null) {
                classArray[0] = weakListenerImpl.listenerClass;
                method = this.getRemoveMethod(clazz, string, classArray[0]);
                if (method == null) {
                    Logger.getAnonymousLogger().warning("Can't remove " + weakListenerImpl.listenerClass.getName() + " using method " + string + " from " + object);
                    return;
                }
                object2 = LOCK;
                synchronized (object2) {
                    lastClass = clazz;
                    lastMethodName = string;
                    lastRemove = method;
                }
            }
            objectArray[0] = weakListenerImpl.getImplementator();
            try {
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                Logger.getAnonymousLogger().warning("Problem encountered while calling " + clazz + "." + string + "(...) on " + object);
                Logger.getAnonymousLogger().log(Level.WARNING, null, exception);
            }
        }

        private Method getRemoveMethod(Class<?> clazz, String string, Class clazz2) {
            Class[] classArray = new Class[]{clazz2};
            Method method = null;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                do {
                    try {
                        method = clazz.getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                    clazz = clazz.getSuperclass();
                } while (method == null && clazz != Object.class);
            }
            if (!(method == null || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
                method.setAccessible(true);
            }
            return method;
        }

        static {
            LOCK = new Object();
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener propertyChangeListener) {
            super(PropertyChangeListener.class, propertyChangeListener);
        }

        PropertyChange(Class clazz, PropertyChangeListener propertyChangeListener) {
            super(clazz, propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)super.get(propertyChangeEvent);
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final Map<Class, Reference<Constructor>> constructors;
        public final Object proxy;

        public ProxyListener(Class clazz, Class clazz2, EventListener eventListener) {
            super(clazz2, eventListener);
            try {
                Object object;
                Constructor<Object> constructor;
                Reference<Constructor> reference = constructors.get(clazz);
                Constructor<Object> constructor2 = constructor = reference == null ? null : reference.get();
                if (constructor == null) {
                    object = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
                    constructor = ((Class)object).getConstructor(InvocationHandler.class);
                    constructors.put(clazz, new SoftReference<Constructor<Object>>(constructor));
                }
                try {
                    object = constructor.newInstance(this);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                }
                this.proxy = object;
            }
            catch (Exception exception) {
                throw (IllegalStateException)new IllegalStateException(exception.toString()).initCause(exception);
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            return equalsMth;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == ProxyListener.getEquals()) {
                    boolean bl = this.equals(objectArray[0]);
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, objectArray);
            }
            EventObject eventObject = objectArray != null && objectArray[0] instanceof EventObject ? (EventObject)objectArray[0] : null;
            EventListener eventListener = super.get(eventObject);
            if (eventListener != null) {
                return method.invoke((Object)eventListener, objectArray);
            }
            return null;
        }

        protected String removeMethodName() {
            String string = this.listenerClass.getName();
            int n = string.lastIndexOf(46);
            int n2 = (string = string.substring(n + 1)).lastIndexOf(36);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            return "remove".concat(string);
        }

        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object object) {
            return this.proxy == object || this == object;
        }

        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = new WeakHashMap<Class, Reference<Constructor>>();
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener vetoableChangeListener) {
            super(VetoableChangeListener.class, vetoableChangeListener);
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)super.get(propertyChangeEvent);
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }
}

