/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigatorController
implements LookupListener,
ActionListener,
Lookup.Provider,
PropertyChangeListener {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private static final Lookup.Template<Node> CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template<NavigatorLookupHint> CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result<Node> curNodes;
    private Lookup.Result<NavigatorLookupHint> curHints;
    private Node curNode;
    private final Lookup clientsLookup;
    private final Lookup panelLookup;
    private Lookup.Result<Node> panelLookupNodesResult;
    private final LookupListener panelLookupListener;
    private Reference<TopComponent> lastActivatedRef;

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = Lookups.proxy((Lookup.Provider)this);
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
        this.panelLookupListener = new PanelLookupListener();
    }

    public void navigatorTCOpened() {
        this.curNodes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodes.addLookupListener((LookupListener)this);
        this.curHints = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHints.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult = this.panelLookup.lookup(CUR_NODES);
        this.panelLookupNodesResult.addLookupListener(this.panelLookupListener);
        this.updateContext();
    }

    public void navigatorTCClosed() {
        this.curNodes.removeLookupListener((LookupListener)this);
        this.curHints.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult.removeLookupListener(this.panelLookupListener);
        this.curNodes = null;
        this.curHints = null;
        this.curNode = null;
        this.lastActivatedRef = null;
        this.navigatorTC.setPanels(null);
        this.panelLookupNodesResult = null;
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (n == -1) {
            return;
        }
        NavigatorPanel navigatorPanel = this.navigatorTC.getPanels().get(n);
        this.activatePanel(navigatorPanel);
    }

    public void activatePanel(NavigatorPanel navigatorPanel) {
        if (!this.navigatorTC.getPanels().contains(navigatorPanel)) {
            throw new IllegalArgumentException("Panel is not available for activation: " + navigatorPanel);
        }
        NavigatorPanel navigatorPanel2 = this.navigatorTC.getSelectedPanel();
        if (!navigatorPanel.equals(navigatorPanel2)) {
            if (navigatorPanel2 != null) {
                navigatorPanel2.panelDeactivated();
            }
            navigatorPanel.panelActivated(this.clientsLookup);
            this.navigatorTC.setSelectedPanel(navigatorPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            ActNodeSetter actNodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)actNodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)actNodeSetter);
            }
        }
    }

    private Node obtainFirstCurNode() {
        Collection collection = this.curNodes.allInstances();
        return collection.isEmpty() ? null : (Node)collection.iterator().next();
    }

    private boolean shouldUpdate() {
        return TopComponent.getRegistry().getCurrentNodes() != null || Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class) != null;
    }

    private void updateContext() {
        boolean bl;
        Node node = this.obtainFirstCurNode();
        if (node == null && !this.shouldUpdate()) {
            return;
        }
        this.curNode = node;
        List<NavigatorPanel> list = this.obtainProviders(node);
        List<NavigatorPanel> list2 = this.navigatorTC.getPanels();
        boolean bl2 = bl = list != null && !list.isEmpty();
        if (list2 == null && list == null) {
            return;
        }
        NavigatorPanel navigatorPanel = this.navigatorTC.getSelectedPanel();
        if (list2 != null && list2.contains(navigatorPanel) && list != null && list.contains(navigatorPanel)) {
            this.clientsLookup.lookup(Node.class);
            if (!((Object)list2).equals(list)) {
                this.navigatorTC.getPanelSelector().removeActionListener(this);
                this.navigatorTC.setPanels(list);
                this.navigatorTC.setSelectedPanel(navigatorPanel);
                this.navigatorTC.getPanelSelector().addActionListener(this);
            }
            this.updateTCTitle((Node)(bl ? node : null));
            return;
        }
        if (navigatorPanel != null) {
            if (!bl) {
                return;
            }
            navigatorPanel.panelDeactivated();
        }
        if (bl) {
            NavigatorPanel navigatorPanel2 = list.get(0);
            navigatorPanel2.panelActivated(this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(list);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        this.navigatorTC.setActivatedNodes(this.obtainActivatedNodes());
        this.updateTCTitle((Node)(bl ? node : null));
    }

    private void updateTCTitle(Node node) {
        String string = node != null ? NbBundle.getMessage(NavigatorTC.class, (String)"FMT_Navigator", (Object)node.getDisplayName()) : NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setName(string);
    }

    List<NavigatorPanel> obtainProviders(Node node) {
        Collection<? extends NavigatorPanel> collection;
        ArrayList<? extends NavigatorPanel> arrayList = null;
        Collection collection2 = Utilities.actionsGlobalContext().lookupAll(NavigatorLookupHint.class);
        for (NavigatorLookupHint navigatorLookupHint : collection2) {
            collection = ProviderRegistry.getInstance().getProviders(navigatorLookupHint.getContentType());
            if (collection == null || collection.isEmpty()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<NavigatorPanel>(collection.size() * collection2.size());
            }
            arrayList.addAll(collection);
        }
        if (node != null) {
            NavigatorLookupHint navigatorLookupHint;
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject != null && !(navigatorLookupHint = dataObject.getPrimaryFile()).isVirtual()) {
                collection = navigatorLookupHint.getMIMEType();
                Collection<? extends NavigatorPanel> collection3 = ProviderRegistry.getInstance().getProviders((String)((Object)collection));
                if (collection3 != null && !collection3.isEmpty()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(collection3.size());
                    }
                    arrayList.addAll(collection3);
                }
            }
        }
        return arrayList;
    }

    private Node[] obtainActivatedNodes() {
        Collection collection = this.getPanelLookup().lookupAll(Node.class);
        if (collection.isEmpty()) {
            Node[] nodeArray;
            if (this.curNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = this.curNode;
            }
            return nodeArray;
        }
        return collection.toArray(new Node[0]);
    }

    public Lookup getLookup() {
        if (this.curNode == null) {
            return Lookup.EMPTY;
        }
        return this.curNode.getLookup();
    }

    public void installActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(keyStroke, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName()) && (topComponent = TopComponent.getRegistry().getActivated()) != null && topComponent != this.navigatorTC) {
            this.lastActivatedRef = new WeakReference<TopComponent>(topComponent);
        }
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                SwingUtilities.invokeLater(this);
            } else if (NavigatorController.this.curNodes != null) {
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || component == null || !SwingUtilities.isDescendingFrom(component, (Component)((Object)NavigatorController.this.navigatorTC)) || component instanceof JComboBox) {
                return;
            }
            TopComponent topComponent = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private final class PanelLookupListener
    implements LookupListener {
        private PanelLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            NavigatorController.this.navigatorTC.setActivatedNodes(NavigatorController.this.obtainActivatedNodes());
        }
    }

    private final class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup lookup;
            NavigatorPanel navigatorPanel = NavigatorController.this.navigatorTC.getSelectedPanel();
            if (navigatorPanel != null && (lookup = navigatorPanel.getLookup()) != null) {
                return lookup;
            }
            return Lookup.EMPTY;
        }
    }
}

