/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProviderRegistry {
    private static final String PANELS_FOLDER = "/Navigator/Panels/";
    private static final Lookup.Template<NavigatorPanel> NAV_PANEL_TEMPLATE = new Lookup.Template(NavigatorPanel.class);
    private static ProviderRegistry instance;
    private Map<String, Collection<? extends NavigatorPanel>> contentTypes2Providers;

    private ProviderRegistry() {
    }

    public static ProviderRegistry getInstance() {
        if (instance == null) {
            instance = new ProviderRegistry();
        }
        return instance;
    }

    public Collection<? extends NavigatorPanel> getProviders(String string) {
        Collection<? extends NavigatorPanel> collection;
        if (this.contentTypes2Providers == null) {
            this.contentTypes2Providers = new HashMap<String, Collection<? extends NavigatorPanel>>(15);
        }
        if ((collection = this.contentTypes2Providers.get(string)) == null) {
            collection = this.loadProviders(string);
            this.contentTypes2Providers.put(string, collection);
        }
        return collection;
    }

    private Collection<? extends NavigatorPanel> loadProviders(String string) {
        DataObject.Container container;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(PANELS_FOLDER + string);
        if (fileObject == null) {
            Logger.getAnonymousLogger().fine("No providers for content type " + string);
            return Collections.emptyList();
        }
        try {
            container = DataFolder.findContainer((FileObject)fileObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, "Navigator content type " + string + " is probably malformed, as it doesn't point to folder.");
            ErrorManager.getDefault().notify(16, (Throwable)illegalArgumentException);
            return Collections.emptyList();
        }
        FolderLookup folderLookup = new FolderLookup(container, "");
        Lookup.Result result = folderLookup.getLookup().lookup(NAV_PANEL_TEMPLATE);
        return result.allInstances();
    }
}

