/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class CustomizerDialog {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    private CustomizerDialog() {
    }

    public static Dialog createDialog(ActionListener actionListener, final CustomizerPane customizerPane, HelpCtx helpCtx, final ProjectCustomizer.Category[] categoryArray, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
        ListeningButton listeningButton = new ListeningButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Ok_Option"), categoryArray);
        listeningButton.setEnabled(CustomizerDialog.checkValidity(categoryArray));
        Object[] objectArray = new JButton[]{listeningButton, new JButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Ok_Option"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Cancel_Option"));
        OptionListener optionListener = new OptionListener(actionListener, categoryArray, categoryComponentProvider);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        customizerPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDialog.class, (String)"AN_ProjectCustomizer"));
        customizerPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_ProjectCustomizer"));
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPane, NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Title"), false, objectArray, (Object)objectArray[0], 0, helpCtx, null);
        customizerPane.addPropertyChangeListener(new HelpCtxChangeListener(dialogDescriptor, helpCtx));
        if (customizerPane instanceof HelpCtx.Provider) {
            dialogDescriptor.setHelpCtx(customizerPane.getHelpCtx());
        }
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                customizerPane.clearPanelComponentCache();
                LinkedList<ProjectCustomizer.Category> linkedList = new LinkedList<ProjectCustomizer.Category>(Arrays.asList(categoryArray));
                while (!linkedList.isEmpty()) {
                    ProjectCustomizer.Category category = (ProjectCustomizer.Category)linkedList.remove(0);
                    Utilities.removeCategoryChangeSupport(category);
                    if (category.getSubcategories() == null) continue;
                    linkedList.addAll(Arrays.asList(category.getSubcategories()));
                }
            }
        });
        return dialog;
    }

    private static boolean checkValidity(ProjectCustomizer.Category[] categoryArray) {
        for (ProjectCustomizer.Category category : categoryArray) {
            if (!category.isValid()) {
                return false;
            }
            ProjectCustomizer.Category[] categoryArray2 = category.getSubcategories();
            if (categoryArray2 == null || CustomizerDialog.checkValidity(categoryArray2)) continue;
            return false;
        }
        return true;
    }

    private static class HelpCtxChangeListener
    implements PropertyChangeListener {
        DialogDescriptor dialogDescriptor;
        HelpCtx defaultHelpCtx;

        HelpCtxChangeListener(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
            this.dialogDescriptor = dialogDescriptor;
            this.defaultHelpCtx = helpCtx;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("helpCtxProperty".equals(propertyChangeEvent.getPropertyName())) {
                HelpCtx helpCtx = (HelpCtx)propertyChangeEvent.getNewValue();
                this.dialogDescriptor.setHelpCtx(helpCtx == null || helpCtx == HelpCtx.DEFAULT_HELP ? this.defaultHelpCtx : helpCtx);
            }
        }
    }

    private static class ListeningButton
    extends JButton
    implements PropertyChangeListener {
        private ProjectCustomizer.Category[] categories;

        public ListeningButton(String string, ProjectCustomizer.Category[] categoryArray) {
            super(string);
            this.categories = categoryArray;
            for (ProjectCustomizer.Category category : categoryArray) {
                Utilities.getCategoryChangeSupport(category).addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "isCategoryValid") {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl && CustomizerDialog.checkValidity(this.categories));
            }
        }
    }

    private static class OptionListener
    implements ActionListener {
        private ActionListener okOptionListener;
        private ProjectCustomizer.Category[] categories;
        private Lookup.Provider prov;

        OptionListener(ActionListener actionListener, ProjectCustomizer.Category[] categoryArray, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
            this.okOptionListener = actionListener;
            this.categories = categoryArray;
            if (categoryComponentProvider instanceof Lookup.Provider) {
                this.prov = (Lookup.Provider)categoryComponentProvider;
            }
        }

        public void actionPerformed(final ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (CustomizerDialog.COMMAND_OK.equals(string)) {
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                    public Object run() {
                        OptionListener.this.okOptionListener.actionPerformed(actionEvent);
                        OptionListener.this.actionPerformed(actionEvent, OptionListener.this.categories);
                        if (OptionListener.this.prov != null) {
                            Project project = (Project)OptionListener.this.prov.getLookup().lookup(Project.class);
                            if (ProjectManager.getDefault().isModified(project)) {
                                try {
                                    ProjectManager.getDefault().saveProject(project);
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
        }

        private void actionPerformed(ActionEvent actionEvent, ProjectCustomizer.Category[] categoryArray) {
            for (int i = 0; i < categoryArray.length; ++i) {
                ActionListener actionListener = categoryArray[i].getOkButtonListener();
                if (actionListener != null) {
                    actionListener.actionPerformed(actionEvent);
                }
                if (categoryArray[i].getSubcategories() == null) continue;
                this.actionPerformed(actionEvent, categoryArray[i].getSubcategories());
            }
        }
    }
}

