/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String PROP_SUPERCLASS = "superClass";
    private static final String PROP_NULL = "nullValue";
    private static final String PROP_LOOKUP = "lookup";
    private ObjectPanel customEditor;
    private Lookup.Template<Object> template;
    private String nullValue;
    private Lookup lookup;

    public synchronized void attachEnv(PropertyEnv propertyEnv) {
        Object object = propertyEnv.getFeatureDescriptor().getValue(PROP_SUPERCLASS);
        if (object instanceof Class) {
            Class clazz = (Class)object;
            this.template = new Lookup.Template(clazz);
        } else {
            this.template = null;
        }
        object = propertyEnv.getFeatureDescriptor().getValue(PROP_NULL);
        this.nullValue = Boolean.TRUE.equals(object) ? NbBundle.getMessage(ObjectEditor.class, (String)"CTL_NullValue") : (object instanceof String ? (String)object : null);
        object = propertyEnv.getFeatureDescriptor().getValue(PROP_LOOKUP);
        Lookup lookup = this.lookup = object instanceof Lookup ? (Lookup)object : null;
        if (this.getTags() == null || this.getTags().length <= 1) {
            propertyEnv.getFeatureDescriptor().setValue("canEditAsText", Boolean.FALSE);
        }
    }

    protected Lookup lookup() {
        Lookup lookup = this.lookup;
        return lookup == null ? Lookup.getDefault() : lookup;
    }

    protected Lookup.Template<Object> template() {
        if (this.template == null) {
            this.template = new Lookup.Template(Object.class);
        }
        return this.template;
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return this.nullValue == null ? NbBundle.getMessage(ObjectEditor.class, (String)"CTL_NullValue") : this.nullValue;
        }
        Lookup.Template template = new Lookup.Template(this.template().getType(), this.template().getId(), object);
        Lookup.Item item = this.lookup().lookupItem(template);
        if (item == null) {
            return NbBundle.getMessage(ObjectEditor.class, (String)"CTL_NullItem");
        }
        return item.getDisplayName();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        Object object2;
        if (this.nullValue != null && this.nullValue.equals(string)) {
            this.setValue(null);
            return;
        }
        Collection collection = this.lookup().lookup(this.template()).allItems();
        for (Object object2 : collection) {
            if (!object2.getDisplayName().equals(string)) continue;
            this.setValue(object2.getInstance());
            this.firePropertyChange();
            return;
        }
        object2 = new IllegalArgumentException(string);
        String string2 = MessageFormat.format(NbBundle.getMessage(ObjectEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), string);
        UIExceptions.annotateUser((Throwable)object2, string, string2, null, new Date());
        throw object2;
    }

    @Override
    public String[] getTags() {
        Collection collection = this.lookup().lookup(this.template()).allItems();
        if (collection.size() <= 1) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size() + 1);
        if (this.nullValue != null) {
            arrayList.add(this.nullValue);
        }
        for (Lookup.Item item : collection) {
            arrayList.add(item.getDisplayName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.getTags() != null && this.getTags().length > 1;
    }

    @Override
    public synchronized Component getCustomEditor() {
        ObjectPanel objectPanel;
        if (!this.supportsCustomEditor()) {
            return null;
        }
        if (this.customEditor != null) {
            return this.customEditor;
        }
        Lookup.Result result = this.lookup().lookup(this.template());
        this.customEditor = objectPanel = new ObjectPanel((Lookup.Result<Object>)result);
        return this.customEditor;
    }

    private static class ItemRadioButton
    extends JRadioButton {
        Lookup.Item item;

        public ItemRadioButton(Lookup.Item item, Font font) {
            this.item = item;
            this.setName(item.getId());
            this.setText(item.getDisplayName());
            this.setFont(font);
            this.getAccessibleContext().setAccessibleName(this.getName());
            this.getAccessibleContext().setAccessibleDescription(this.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPanel
    extends JPanel
    implements ActionListener {
        public ObjectPanel(Lookup.Result<Object> result) {
            Font font;
            Font font2;
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObjectEditor.class, (String)"ACSN_ObjectTree"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ObjectEditor.class, (String)"ACSD_ObjectTree"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            ButtonGroup buttonGroup = new ButtonGroup();
            if (Utilities.isMac()) {
                font2 = new Font(this.getFont().getName(), 1, this.getFont().getSize());
                font = new Font(this.getFont().getName(), 0, this.getFont().getSize());
            } else {
                font2 = this.getFont().deriveFont(1);
                font = this.getFont().deriveFont(0);
            }
            Collection collection = result.allItems();
            Lookup.Item[] itemArray = new Lookup.Item[collection.size()];
            itemArray = collection.toArray(itemArray);
            int n2 = 7;
            for (int i = 0; i < itemArray.length; ++i) {
                ItemRadioButton itemRadioButton = new ItemRadioButton(itemArray[i], font2);
                if (itemArray[i].getInstance().equals(ObjectEditor.this.getValue())) {
                    itemRadioButton.setSelected(true);
                }
                itemRadioButton.addActionListener(this);
                buttonGroup.add(itemRadioButton);
                String string = this.getDescription(itemArray[i]);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.insets = new Insets(i == 0 ? 7 : 0, n2, string != null ? 1 : (i == itemArray.length - 1 ? 7 : 4), n2);
                gridBagConstraints.fill = 2;
                this.add((Component)itemRadioButton, gridBagConstraints);
                ++n;
                if (string == null) continue;
                JLabel jLabel = new JLabel(string);
                jLabel.setLabelFor(itemRadioButton);
                jLabel.setFont(font);
                int n3 = itemRadioButton.getIcon() != null ? itemRadioButton.getIcon().getIconWidth() : 20;
                gridBagConstraints.insets = new Insets(0, n2 + n3, 4, n2 + n3);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                this.add((Component)jLabel, gridBagConstraints);
            }
        }

        private String getDescription(Lookup.Item item) {
            String string = item.getId();
            String string2 = null;
            try {
                string2 = Introspector.getBeanInfo(item.getInstance().getClass()).getBeanDescriptor().getShortDescription();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            String string3 = item.getInstance().getClass().getName();
            String string4 = string3 = string3.lastIndexOf(46) != -1 ? string3.substring(string3.lastIndexOf(46) + 1) : string3;
            if (string3.equals(string2)) {
                string2 = null;
            }
            return string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Lookup.Item item = ((ItemRadioButton)actionEvent.getSource()).item;
            Object object = item.getInstance();
            ObjectEditor.this.setValue(item.getInstance());
            ObjectEditor.this.firePropertyChange();
        }
    }
}

