/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.openide.util.RequestProcessor;

abstract class FlashingIcon
extends JComponent
implements MouseListener {
    private static final long STOP_FLASHING_DELAY = 5000L;
    private static final long DISAPPEAR_DELAY_MILLIS = 35000L;
    private Icon icon;
    private boolean keepRunning = false;
    private boolean isIconVisible = false;
    private boolean keepFlashing = true;
    private long startTime = 0L;
    private RequestProcessor rp;
    private RequestProcessor.Task timerTask;

    protected FlashingIcon(Icon icon) {
        this.icon = icon;
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.addMouseListener(this);
        this.rp = new RequestProcessor("Exception Notification Icon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFlashing() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            this.startTime = System.currentTimeMillis();
            this.isIconVisible = !this.isIconVisible;
            this.keepRunning = true;
            this.keepFlashing = true;
            if (null == this.timerTask) {
                this.timerTask = this.rp.create((Runnable)new Timer());
            }
            this.timerTask.run();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disappear() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            this.keepRunning = false;
            this.isIconVisible = false;
            this.keepFlashing = false;
            if (null != this.timerTask) {
                this.timerTask.cancel();
            }
            this.timerTask = null;
            this.setToolTipText(null);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFlashing() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            if (this.keepRunning && !this.isIconVisible) {
                this.isIconVisible = true;
                this.repaint();
            }
        }
        this.keepFlashing = false;
    }

    protected void flashIcon() {
        this.isIconVisible = !this.isIconVisible;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.isIconVisible) {
            this.icon.paintIcon(this, graphics, 0, 0);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isIconVisible) {
            this.disappear();
            this.onMouseClick();
        }
    }

    protected abstract void onMouseClick();

    protected abstract void timeout();

    public Cursor getCursor() {
        if (this.isIconVisible) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        JToolTip jToolTip = this.createToolTip();
        jToolTip.setTipText(this.getToolTipText());
        Dimension dimension = jToolTip.getPreferredSize();
        return new Point(this.getWidth() - dimension.width, -dimension.height);
    }

    private class Timer
    implements Runnable {
        private Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FlashingIcon flashingIcon = FlashingIcon.this;
            synchronized (flashingIcon) {
                try {
                    long l = System.currentTimeMillis();
                    if (FlashingIcon.this.keepFlashing) {
                        if (l - FlashingIcon.this.startTime < 5000L) {
                            FlashingIcon.this.flashIcon();
                        } else {
                            FlashingIcon.this.stopFlashing();
                        }
                    }
                    if (l - FlashingIcon.this.startTime >= 35000L) {
                        FlashingIcon.this.disappear();
                        FlashingIcon.this.timeout();
                    } else if (null != FlashingIcon.this.timerTask) {
                        FlashingIcon.this.timerTask.schedule(500);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

