/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
Runnable,
FlavorListener,
AWTEventListener {
    private Logger log;
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result<ExClipboard.Convertor> result;
    final boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Reference<Object> lastWindowDeactivatedSource = new WeakReference<Object>(null);
    private RequestProcessor.Task syncTask = new RequestProcessor("System clipboard synchronizer").create((Runnable)this, true);
    private Transferable data;
    private ClipboardOwner dataOwner;

    public NbClipboard() {
        super("NBClipboard");
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.log = Logger.getLogger("org.netbeans.core.NbClipboard");
        this.result = Lookup.getDefault().lookupResult(ExClipboard.Convertor.class);
        this.result.addLookupListener((LookupListener)this);
        this.systemClipboard.addFlavorListener(this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : true;
        if (!this.slowSystemClipboard) {
            if (System.getProperty("sun.awt.datatransfer.timeout") == null) {
                System.setProperty("sun.awt.datatransfer.timeout", "1000");
            }
        } else {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.result.allInstances();
        ExClipboard.Convertor[] convertorArray = new ExClipboard.Convertor[collection.size()];
        this.convertors = collection.toArray(convertorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "setContents called with: ");
                this.logFlavors(transferable, Level.FINER);
            }
            transferable = this.convert(transferable);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "After conversion:");
                this.logFlavors(transferable, Level.FINER);
            }
            if (this.slowSystemClipboard) {
                super.setContents(transferable, clipboardOwner);
            } else {
                if (this.last != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.last);
                }
                this.last = transferable;
            }
            this.data = transferable;
            this.dataOwner = clipboardOwner;
            this.syncTask.schedule(0);
        }
        this.fireClipboardChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object object) {
        try {
            Transferable transferable;
            if (this.slowSystemClipboard) {
                if (this.lastWindowActivated != 0L && this.lastWindowActivated + 100L < System.currentTimeMillis()) {
                    this.lastWindowActivated = 0L;
                    this.syncTask.schedule(0);
                    this.syncTask.waitFinished(100L);
                }
                transferable = super.getContents(object);
            } else {
                this.syncTask.waitFinished();
                transferable = this.systemClipboard.getContents(object);
            }
            NbClipboard nbClipboard = this;
            synchronized (nbClipboard) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "getContents by " + object);
                    this.logFlavors(transferable, Level.FINE);
                }
                if (transferable == null) {
                    return null;
                }
                Transferable transferable2 = this.convert(transferable);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "getContents by " + object);
                    this.logFlavors(transferable2, Level.FINE);
                    transferable2 = new LoggableTransferable(transferable2);
                }
                return transferable2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(NbClipboard.class.getName()).log(Level.WARNING, null, interruptedException);
            return null;
        }
        catch (Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Transferable transferable = null;
        ClipboardOwner clipboardOwner = null;
        Object object = this;
        synchronized (object) {
            if (this.data != null) {
                transferable = this.data;
                clipboardOwner = this.dataOwner;
            }
            this.data = null;
            this.dataOwner = null;
        }
        if (transferable != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "systemClipboard updated:");
                this.logFlavors(transferable, Level.FINE);
            }
            this.systemClipboard.setContents(transferable, clipboardOwner);
            return;
        }
        try {
            object = this.systemClipboard.getContents(this);
            super.setContents((Transferable)object, null);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "internal clipboard updated:");
                this.logFlavors((Transferable)object, Level.FINE);
            }
            this.fireClipboardChange();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void waitFinished() {
        this.syncTask.waitFinished();
    }

    final void activateWindowHack(boolean bl) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (bl) {
            this.syncTask.schedule(0);
        }
    }

    private void logFlavors(Transferable transferable, Level level) {
        if (transferable == null) {
            this.log.log(level, "  no clipboard contents");
        } else {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                this.log.log(level, "  " + i + " = " + dataFlavorArray[i]);
            }
        }
    }

    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.fireClipboardChange();
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof WindowEvent)) {
            return;
        }
        if (aWTEvent.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = new WeakReference<Object>(aWTEvent.getSource());
        }
        if (aWTEvent.getID() == 205) {
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && aWTEvent.getSource() == this.lastWindowDeactivatedSource.get()) {
                this.activateWindowHack(false);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "window activated scheduling update");
            }
            this.syncTask.schedule(0);
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable transferable) {
            this.delegate = transferable;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            NbClipboard.this.log.log(Level.FINE, "Request for flavor: " + dataFlavor);
            Object object = this.delegate.getTransferData(dataFlavor);
            NbClipboard.this.log.log(Level.FINE, "Returning value: " + object);
            return object;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = this.delegate.isDataFlavorSupported(dataFlavor);
            NbClipboard.this.log.log(Level.FINE, "isDataFlavorSupported: " + dataFlavor + " result: " + bl);
            return bl;
        }
    }
}

