/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.filesystems.DefaultParser;
import org.netbeans.core.filesystems.MIMEComponent;
import org.netbeans.core.filesystems.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

final class XMLMIMEComponent
extends DefaultParser
implements MIMEComponent {
    private short parseState = 0;
    private final Smell template = new Smell();
    private static final LocalSniffingParser local = new LocalSniffingParser();
    private static final short INIT = 0;
    private static final short IN_ROOT = 1;
    private static final short IN_DOCTYPE = 2;
    private static final short IN_ELEMENT = 3;
    private static final String ROOT = "xml-rule";
    private static final String PI = "pi";
    private static final String ELEMENT = "element";
    private static final String DOCTYPE = "doctype";
    private static final String PUBLIC_ID = "public-id";
    private static final String ID = "id";
    private static final String ATTR = "attr";
    private static final String NAME = "name";
    private static final String VALUE = "text";
    private static final String NS = "ns";
    private static final String TARGET = "target";

    XMLMIMEComponent() {
    }

    public boolean acceptFileObject(FileObject fileObject) {
        SniffingParser sniffingParser = local.getParser();
        Smell smell = sniffingParser.sniff(fileObject);
        return this.template.match(smell);
    }

    public String toString() {
        return this.template.toString();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (this.parseState) {
            case 0: {
                if (!ROOT.equals(string3)) {
                    this.error();
                }
                this.parseState = 1;
                break;
            }
            case 1: {
                if (PI.equals(string3)) {
                    String string4 = attributes.getValue(TARGET);
                    if (string4 == null) {
                        this.error();
                    }
                    this.template.addPI(string4);
                    break;
                }
                if (DOCTYPE.equals(string3)) {
                    String string5 = attributes.getValue(PUBLIC_ID);
                    if (string5 == null) {
                        this.parseState = (short)2;
                        break;
                    }
                    this.template.addDoctype(string5);
                    break;
                }
                if (ELEMENT.equals(string3)) {
                    String string6 = attributes.getValue(NAME);
                    if (string6 == null) {
                        string6 = attributes.getValue(NS);
                        if (string6 != null) {
                            this.template.addElementNS(string6);
                        }
                    } else {
                        this.template.addElementName(string6);
                        string6 = attributes.getValue(NS);
                        if (string6 != null) {
                            this.template.addElementNS(string6);
                        }
                    }
                    this.parseState = (short)3;
                    break;
                }
                this.error();
                break;
            }
            case 2: {
                String string7;
                if (!PUBLIC_ID.equals(string3)) {
                    this.error();
                }
                if ((string7 = attributes.getValue(ID)) == null) {
                    this.error();
                }
                this.template.addDoctype(string7);
                break;
            }
            case 3: {
                if (ATTR.equals(string3)) {
                    String string8 = attributes.getValue(NAME);
                    if (string8 == null) {
                        this.error();
                    }
                    this.template.addElementAtt(string8, attributes.getValue(VALUE));
                    break;
                }
                if (NS.equals(string3)) {
                    String string9 = attributes.getValue(NAME);
                    if (string9 == null) {
                        this.error();
                    }
                    this.template.addElementNS(string9);
                    break;
                }
                this.error();
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        switch (this.parseState) {
            case 3: {
                if (!ELEMENT.equals(string3)) break;
                this.parseState = 1;
                break;
            }
            case 2: {
                if (!DOCTYPE.equals(string3)) break;
                this.parseState = 1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalSniffingParser
    extends ThreadLocal<WeakReference<SniffingParser>> {
        private WeakReference<SniffingParser> wref = null;

        LocalSniffingParser() {
        }

        @Override
        protected WeakReference<SniffingParser> initialValue() {
            SniffingParser sniffingParser = new SniffingParser();
            this.wref = new WeakReference<SniffingParser>(sniffingParser);
            return this.wref;
        }

        public SniffingParser getParser() {
            WeakReference weakReference = (WeakReference)this.get();
            SniffingParser sniffingParser = (SniffingParser)weakReference.get();
            if (sniffingParser == null) {
                sniffingParser = new SniffingParser();
                this.wref = new WeakReference<SniffingParser>(sniffingParser);
                super.set(this.wref);
            }
            return sniffingParser;
        }

        @Override
        public void set(WeakReference<SniffingParser> weakReference) {
        }
    }

    private static class Smell {
        private String[] doctypes = null;
        private String[] pis = null;
        private String root = null;
        private String[] nss = null;
        private String[] attns = null;
        private String[] attvs = null;

        Smell() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            stringBuffer.append("xml-check(");
            if (this.doctypes != null) {
                stringBuffer.append("doctypes:");
                for (n = 0; n < this.doctypes.length; ++n) {
                    stringBuffer.append(this.doctypes[n]).append(", ");
                }
            }
            if (this.pis != null) {
                stringBuffer.append("PIs:");
                for (n = 0; n < this.pis.length; ++n) {
                    stringBuffer.append(this.pis[n]).append(", ");
                }
            }
            if (this.root != null) {
                stringBuffer.append("root:").append(this.root);
            }
            if (this.nss != null) {
                stringBuffer.append("root-namespaces:");
                for (n = 0; n < this.nss.length; ++n) {
                    stringBuffer.append(this.nss[n]).append(", ");
                }
            }
            if (this.attns != null) {
                stringBuffer.append("attributes:");
                for (n = 0; n < this.attns.length; ++n) {
                    stringBuffer.append(this.attns[n]).append("='").append(this.attvs[n]).append("'");
                }
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        private void addDoctype(String string) {
            this.doctypes = this.doctypes == null ? new String[]{string} : Util.addString(this.doctypes, string);
        }

        private void addPI(String string) {
            this.pis = this.pis == null ? new String[]{string} : Util.addString(this.pis, string);
        }

        private void addElementNS(String string) {
            this.nss = this.nss == null ? new String[]{string} : Util.addString(this.nss, string);
        }

        private void addElementName(String string) {
            this.root = string;
        }

        private void addElementAtt(String string, String string2) {
            if (this.attns == null) {
                this.attns = new String[]{string};
                this.attvs = new String[]{string2};
            } else {
                this.attns = Util.addString(this.attns, string);
                this.attvs = Util.addString(this.attvs, string2);
            }
        }

        public boolean match(Smell smell) {
            if (smell == null) {
                return false;
            }
            if (this.doctypes != null && smell.doctypes != null && Util.contains(this.doctypes, smell.doctypes[0])) {
                return true;
            }
            if (this.root != null && this.root.equals(smell.root) ? (this.nss == null ? this.attMatch(smell) : smell.nss != null && Util.contains(this.nss, smell.nss[0]) && this.attMatch(smell)) : this.root == null && this.nss != null && smell.nss != null && Util.contains(this.nss, smell.nss[0]) && this.attMatch(smell)) {
                return true;
            }
            if (this.pis != null && smell.pis != null) {
                for (int i = 0; i < this.pis.length; ++i) {
                    for (int j = 0; j < smell.pis.length; ++j) {
                        if (!this.pis[i].equals(smell.pis[j])) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean attMatch(Smell smell) {
            if (this.attns == null) {
                return true;
            }
            if (smell.attns == null) {
                return false;
            }
            for (int i = 0; i < this.attns.length; ++i) {
                int n = Util.indexOf(smell.attns, this.attns[i]);
                if (n == -1) {
                    return false;
                }
                if (this.attvs[i] == null || this.attvs[i].equals(smell.attvs[n])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SniffingParser
    extends DefaultParser
    implements LexicalHandler {
        private FileObject lastFileObject = null;
        private Smell print = null;
        private static final SAXException STOP = new SAXException("STOP");

        SniffingParser() {
            super(null);
        }

        protected Smell sniff(FileObject fileObject) {
            if (fileObject == null) {
                return null;
            }
            if (fileObject.equals(this.lastFileObject)) {
                return this.print;
            }
            if (!fileObject.isValid()) {
                return null;
            }
            if (fileObject.getSize() == 0L) {
                return null;
            }
            this.print = new Smell();
            this.parse(fileObject);
            if (this.state == -1) {
                return null;
            }
            this.lastFileObject = fileObject;
            return this.print;
        }

        protected XMLReader createXMLReader() {
            XMLReader xMLReader = null;
            try {
                xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sAXException) {
                    Logger.getLogger(XMLMIMEComponent.class.getName()).fine(NbBundle.getMessage(XMLMIMEComponent.class, (String)"W-003"));
                }
            }
            catch (SAXException sAXException) {
                Logger.getLogger(XMLMIMEComponent.class.getName()).log(Level.WARNING, null, sAXException);
            }
            return xMLReader;
        }

        protected boolean isStopException(Exception exception) {
            return STOP.getMessage().equals(exception.getMessage());
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string != null) {
                this.print.addElementNS(string);
            }
            if ("".equals(string2)) {
                string2 = null;
            }
            this.print.addElementName(string2 != null ? string2 : string3);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.print.addElementAtt(attributes.getQName(i), attributes.getValue(i));
            }
            throw STOP;
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.print.addPI(string);
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.print.addDoctype(string2);
        }

        public void endDTD() {
        }

        public void startEntity(String string) {
        }

        public void endEntity(String string) {
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }

        public void comment(char[] cArray, int n, int n2) {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            Logger.getLogger(XMLMIMEComponent.class.getName()).warning(sAXParseException.getMessage());
            this.state = (short)-1;
            throw STOP;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            Logger logger = Logger.getLogger("org.netbeans.core.filesystems.XMLMIMEComponent");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[while parsing " + this.fo + "] " + sAXParseException.getSystemId() + ":" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
            }
            this.state = (short)-1;
            throw STOP;
        }
    }
}

