/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.MemoryFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class FileUtil {
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    static final Set<String> transientAttributes = new HashSet<String>();
    private static Dictionary<String, String> map;
    private static final Map<FileObject, Boolean> archiveFileCache;
    private static FileSystemView fileSystemView;
    private static float javaSpecVersion;

    private FileUtil() {
    }

    public static FileObject createFolder(File file) throws IOException {
        FileObject fileObject = null;
        File file2 = FileUtil.getRoot(file);
        if (!file2.exists()) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    public static FileObject createData(File file) throws IOException {
        FileObject fileObject = null;
        File file2 = FileUtil.getRoot(file);
        if (!file2.exists()) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createData(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createData(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    private static File getRoot(File file) {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        assert (file2 != null);
        return file2;
    }

    private static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        assert (file3 != null) : file2.getAbsolutePath() + "not found in " + file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        FileObject fileObject3 = fileObject2.createData(string, string2);
        FileLock fileLock = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject3.lock();
            inputStream = fileObject.getInputStream();
            outputStream = fileObject3 instanceof AbstractFileObject ? ((AbstractFileObject)fileObject3).getOutputStream(fileLock, false) : fileObject3.getOutputStream(fileLock);
            FileUtil.copy(inputStream, outputStream);
            FileUtil.copyAttributes(fileObject, fileObject3);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject3;
    }

    public static FileSystem createMemoryFileSystem() {
        return new MemoryFileSystem();
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        return fileObject.copy(fileObject2, string, string2);
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        return FileUtil.copyFile(fileObject, fileObject2, string, fileObject.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject moveFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            FileObject fileObject3 = fileObject.move(fileLock, fileObject2, string, fileObject.getExt());
            return fileObject3;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static FileObject createFolder(FileObject fileObject, String string) throws IOException {
        String string2 = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            FileObject fileObject2;
            block4: {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    try {
                        fileObject2 = fileObject.createFolder(string);
                    }
                    catch (SyncFailedException syncFailedException) {
                        fileObject.refresh();
                        fileObject2 = fileObject.getFileObject(string);
                        if (fileObject2 != null) break block4;
                        throw syncFailedException;
                    }
                }
            }
            fileObject = fileObject2;
        }
        return fileObject;
    }

    public static FileObject createData(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        block12: {
            String string2;
            String string3;
            String string4;
            if (fileObject == null) {
                throw new IllegalArgumentException("Null folder");
            }
            if (string == null) {
                throw new IllegalArgumentException("Null name");
            }
            int n = string.lastIndexOf(47);
            if (n >= string.length()) {
                throw new IOException("Wrong file name.");
            }
            if (n != -1) {
                String string5 = string.substring(0, n);
                string4 = string.substring(n + 1);
                fileObject = FileUtil.createFolder(fileObject, string5);
                assert (fileObject != null);
            } else {
                string4 = string;
            }
            if ((n = string4.lastIndexOf(46)) != -1) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            fileObject2 = fileObject.getFileObject(string3, string2);
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.createData(string3, string2);
                    assert (fileObject2 != null) : "FileObject.createData cannot return null; called on " + fileObject + " + " + string3 + " + " + string2;
                }
                catch (SyncFailedException syncFailedException) {
                    fileObject.refresh();
                    fileObject2 = fileObject.getFileObject(string3, string2);
                    if (fileObject2 != null) break block12;
                    throw syncFailedException;
                }
            }
        }
        return fileObject2;
    }

    public static File toFile(FileObject fileObject) {
        File file = (File)fileObject.getAttribute("java.io.File");
        if (file == null) {
            URL uRL = null;
            int[] nArray = new int[]{0, 1};
            for (int i = 0; (uRL == null || "file".equals(uRL.getProtocol())) && i < nArray.length; ++i) {
                uRL = URLMapper.findURL(fileObject, nArray[i]);
            }
            if (uRL != null && "file".equals(uRL.getProtocol())) {
                file = new File(URI.create(uRL.toExternalForm()));
            }
        }
        return file != null ? FileUtil.normalizeFile(file) : null;
    }

    public static FileObject toFileObject(File file) {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && !file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        FileObject fileObject = null;
        try {
            URL uRL = FileUtil.fileToURL(file);
            if (uRL.getAuthority() != null && (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048)) {
                return null;
            }
            fileObject = URLMapper.findFileObject(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            fileObject = null;
        }
        return fileObject;
    }

    static URL fileToURL(File file) throws MalformedURLException {
        URL uRL = null;
        uRL = !Utilities.isWindows() || FileUtil.canBeCanonicalizedOnWindows(file) ? file.toURI().toURL() : new URL("file:/" + file.getAbsolutePath());
        return uRL;
    }

    @Deprecated
    public static FileObject[] fromFile(File file) {
        FileObject[] fileObjectArray;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        try {
            URL uRL = file.toURI().toURL();
            if (uRL.getAuthority() != null && (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048)) {
                return null;
            }
            fileObjectArray = URLMapper.findFileObjects(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            fileObjectArray = null;
        }
        return fileObjectArray;
    }

    public static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration<String> enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = enumeration.nextElement();
            if (transientAttributes.contains(string) || FileUtil.isTransient(fileObject, string) || (object = fileObject.getAttribute(string)) == null) continue;
            fileObject2.setAttribute(string, object);
        }
    }

    static boolean isTransient(FileObject fileObject, String string) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fileObject, string);
    }

    @Deprecated
    public static void extractJar(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileUtil.extractJarImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        Object object;
        JarEntry jarEntry;
        HashMap<Object, DefaultAttributes.Table> hashMap = new HashMap<Object, DefaultAttributes.Table>(7);
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            String string = jarEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (jarEntry.isDirectory()) {
                FileUtil.createFolder(fileObject, string);
                continue;
            }
            if (DefaultAttributes.acceptName(string)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jarInputStream, string);
                hashMap.put(string, table);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData(fileObject, string);
            object = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream((FileLock)object);
                try {
                    FileUtil.copy(jarInputStream, outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                ((FileLock)object).releaseLock();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            int n = ((String)object).lastIndexOf(47);
            String string = n != -1 ? ((String)object).substring(0, n + 1) : "";
            String string2 = fileObject.isRoot() ? string : fileObject.getPath() + '/' + string;
            DefaultAttributes.Table table = (DefaultAttributes.Table)entry.getValue();
            for (String string3 : table.keySet()) {
                String string4 = string2 + string3;
                FileObject fileObject3 = fileObject.getFileSystem().findResource(string4);
                if (fileObject3 == null) continue;
                Enumeration<String> enumeration = table.attrs(string3);
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    Object object2 = table.getAttr(string3, string5);
                    if (object2 == null) continue;
                    fileObject3.setAttribute(string5, object2);
                }
            }
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String findFreeFileName(FileObject fileObject, String string, String string2) {
        if (FileUtil.checkFreeName(fileObject, string, string2)) {
            return string;
        }
        int n = 1;
        String string3;
        while (!FileUtil.checkFreeName(fileObject, string3 = string + "_" + n, string2)) {
            ++n;
        }
        return string3;
    }

    public static String findFreeFolderName(FileObject fileObject, String string) {
        if (FileUtil.checkFreeName(fileObject, string, null)) {
            return string;
        }
        int n = 1;
        String string2;
        while (!FileUtil.checkFreeName(fileObject, string2 = string + "_" + n, null)) {
            ++n;
        }
        return string2;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        if (!FileUtil.isParentOf(fileObject, fileObject2) && fileObject != fileObject2) {
            return null;
        }
        String string = fileObject2.getPath().substring(fileObject.getPath().length());
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private static boolean checkFreeName(FileObject fileObject, String string, String string2) {
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 || Utilities.isMac()) {
            Enumeration<? extends FileObject> enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                fileObject = enumeration.nextElement();
                String string3 = fileObject.getName();
                String string4 = fileObject.getExt();
                if (!string3.equalsIgnoreCase(string)) continue;
                if (!(string2 != null && string2.trim().length() != 0 || string4 != null && string4.trim().length() != 0)) {
                    return fileObject.isVirtual();
                }
                if (string2 == null || string4 == null || !string2.equalsIgnoreCase(string4)) continue;
                return fileObject.isVirtual();
            }
            return true;
        }
        if (string2 == null) {
            if ((fileObject = fileObject.getFileObject(string)) == null) {
                return true;
            }
            return fileObject.isVirtual();
        }
        if ((fileObject = fileObject.getFileObject(string, string2)) == null) {
            return true;
        }
        return fileObject.isVirtual();
    }

    public static FileObject findBrother(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        return fileObject2.getFileObject(fileObject.getName(), string);
    }

    @Deprecated
    public static String getMIMEType(String string) {
        String string2 = map.get(string);
        if (string2 != null) {
            return string2;
        }
        return map.get(string.toLowerCase());
    }

    public static String getMIMEType(FileObject fileObject) {
        String string = MIMESupport.findMIMEType(fileObject, null);
        if (string == null) {
            string = FileUtil.getMIMEType(fileObject.getExt());
        }
        return string;
    }

    static String getMIMETypeOrDefault(FileObject fileObject) {
        String string = FileUtil.getMIMEType(fileObject.getExt());
        String string2 = MIMESupport.findMIMEType(fileObject, string);
        if (string2 == null) {
            string2 = "content/unknown";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setMIMEType(String string, String string2) {
        Dictionary<String, String> dictionary = map;
        synchronized (dictionary) {
            String string3 = map.get(string);
            if (string3 == null) {
                map.put(string, string2);
            } else if (!string3.equals(string2)) {
                throw new IllegalArgumentException("Cannot overwrite existing MIME type mapping for extension `" + string + "' with " + string2 + " (was " + string3 + ")");
            }
        }
    }

    public static URLStreamHandler nbfsURLStreamHandler() {
        return FileURL.HANDLER;
    }

    public static boolean isParentOf(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null) {
            throw new IllegalArgumentException("Tried to pass null folder arg");
        }
        if (fileObject2 == null) {
            throw new IllegalArgumentException("Tried to pass null fo arg");
        }
        if (fileObject.isData()) {
            return false;
        }
        try {
            if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                return false;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
        for (FileObject fileObject3 = fileObject2.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
            if (fileObject3 != fileObject) continue;
            return true;
        }
        return false;
    }

    public static FileChangeListener weakFileChangeListener(FileChangeListener fileChangeListener, Object object) {
        return (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)fileChangeListener, (Object)object);
    }

    public static FileStatusListener weakFileStatusListener(FileStatusListener fileStatusListener, Object object) {
        return (FileStatusListener)WeakListeners.create(FileStatusListener.class, (EventListener)fileStatusListener, (Object)object);
    }

    public static String getFileDisplayName(FileObject fileObject) {
        String string = null;
        File file = FileUtil.toFile(fileObject);
        if (file != null) {
            string = file.getAbsolutePath();
        } else {
            FileObject fileObject2 = FileUtil.getArchiveFile(fileObject);
            if (fileObject2 != null) {
                string = FileUtil.getArchiveDisplayName(fileObject, fileObject2);
            }
        }
        if (string == null) {
            try {
                string = fileObject.isRoot() ? fileObject.getFileSystem().getDisplayName() : NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)fileObject.getPath(), (Object)fileObject.getFileSystem().getDisplayName());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = fileObject.getPath();
            }
        }
        return string;
    }

    private static String getArchiveDisplayName(FileObject fileObject, FileObject fileObject2) {
        String string = null;
        File file = FileUtil.toFile(fileObject2);
        if (file != null) {
            String string2 = file.getAbsolutePath();
            if (fileObject.isRoot()) {
                string = string2;
            } else {
                String string3 = fileObject.getPath();
                string = NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)string3, (Object)string2);
            }
        }
        return string;
    }

    public static File normalizeFile(File file) {
        File file2 = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? FileUtil.normalizeFileOnWindows(file) : (Utilities.isMac() ? FileUtil.normalizeFileOnMac(file) : FileUtil.normalizeFileOnUnixAlike(file));
        return file.getPath().equals(file2.getPath()) ? file : file2;
    }

    private static File normalizeFileOnUnixAlike(File file) {
        file = file.getAbsolutePath().equals("/..") ? new File("/") : new File(file.toURI().normalize()).getAbsoluteFile();
        return file;
    }

    private static File normalizeFileOnMac(File file) {
        File file2 = file;
        try {
            boolean bl;
            File file3 = new File(file.toURI().normalize());
            File file4 = file.getCanonicalFile();
            boolean bl2 = bl = !file4.getAbsolutePath().equalsIgnoreCase(file3.getAbsolutePath());
            file2 = bl ? FileUtil.normalizeSymLinkOnMac(file3) : file4;
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe("Normalization failed on file " + file + ": " + iOException);
            file2 = file.getAbsoluteFile();
        }
        return file2;
    }

    private static File normalizeSymLinkOnMac(File file) throws IOException {
        File file2;
        File file3 = file2 = File.listRoots()[0];
        String string = File.separator + ".." + File.separator;
        Object object = file.getAbsolutePath();
        int n = ((String)object).lastIndexOf(string);
        if (n > -1) {
            object = ((String)object).substring(n + string.length());
        }
        String string2 = object;
        object = new StringTokenizer(string2, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            boolean bl;
            File file4 = new File(file3, ((StringTokenizer)object).nextToken());
            boolean bl2 = bl = !(file3 = file4.getCanonicalFile()).getAbsolutePath().equalsIgnoreCase(file4.getAbsolutePath());
            if (bl) {
                file2 = new File(file2, file4.getName());
                continue;
            }
            file2 = new File(file2, file3.getName());
        }
        return file2;
    }

    private static File normalizeFileOnWindows(File file) {
        File file2 = null;
        if (FileUtil.canBeCanonicalizedOnWindows(file)) {
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                Logger.getAnonymousLogger().severe("getCanonicalFile() on file " + file + " failed. " + iOException.toString());
            }
        }
        return file2 != null ? file2 : file.getAbsoluteFile();
    }

    private static boolean canBeCanonicalizedOnWindows(File file) {
        boolean bl = true;
        if (file.getParent() == null && FileUtil.is4089199()) {
            FileSystemView fileSystemView = FileUtil.getFileSystemView();
            bl = fileSystemView != null ? !fileSystemView.isFloppyDrive(file) && file.exists() : false;
        }
        return bl;
    }

    private static boolean is4089199() {
        return Utilities.isWindows() && (double)FileUtil.getJavaSpecVersion() < 1.6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getJavaSpecVersion() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (javaSpecVersion == 0.0f) {
                javaSpecVersion = Float.valueOf(System.getProperty("java.specification.version")).floatValue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return javaSpecVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystemView getFileSystemView() {
        boolean bl = false;
        final FileSystemView[] fileSystemViewArray = new FileSystemView[]{fileSystemView};
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            bl = FileUtil.is4089199() && fileSystemViewArray[0] == null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                if (SwingUtilities.isEventDispatchThread()) {
                    fileSystemViewArray[0] = FileSystemView.getFileSystemView();
                    clazz = FileUtil.class;
                    synchronized (FileUtil.class) {
                        fileSystemView = fileSystemViewArray[0];
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            fileSystemViewArray[0] = FileSystemView.getFileSystemView();
                            Class<FileUtil> clazz = FileUtil.class;
                            synchronized (FileUtil.class) {
                                FileUtil.fileSystemView = fileSystemViewArray[0];
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }
            return fileSystemView;
        }
    }

    public static FileObject getArchiveRoot(FileObject fileObject) {
        URL uRL = URLMapper.findURL(fileObject, 1);
        if (uRL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveRoot(uRL));
    }

    public static URL getArchiveRoot(URL uRL) {
        try {
            return new URL("jar:" + uRL + "!/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static FileObject getArchiveFile(FileObject fileObject) {
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            if (fileSystem instanceof JarFileSystem) {
                File file = ((JarFileSystem)fileSystem).getJarFile();
                return FileUtil.toFileObject(file);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static URL getArchiveFile(URL uRL) {
        String string;
        int n;
        String string2 = uRL.getProtocol();
        if ("jar".equals(string2) && (n = (string = uRL.getPath()).indexOf("!/")) >= 0) {
            try {
                return new URL(string.substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isArchiveFile(FileObject fileObject) {
        Object object;
        if (fileObject == null) {
            throw new IllegalArgumentException("Cannot pass null to FileUtil.isArchiveFile");
        }
        if (!fileObject.isValid()) {
            return false;
        }
        if (fileObject.isVirtual()) {
            String string = fileObject.getPath();
            int n = string.lastIndexOf(46);
            if (n == -1) return false;
            if (n <= string.lastIndexOf(47) + 1) return false;
            return true;
        }
        if (fileObject.isFolder()) {
            return false;
        }
        Boolean bl = archiveFileCache.get(fileObject);
        if (bl != null) return bl;
        try {
            object = fileObject.getInputStream();
            try {
                byte[] byArray = new byte[4];
                int n = ((InputStream)object).read(byArray, 0, 4);
                if (n != 4) {
                    boolean bl2 = false;
                    return bl2;
                }
                bl = Arrays.equals(ZIP_HEADER_1, byArray) || Arrays.equals(ZIP_HEADER_2, byArray);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.INFO, null, iOException);
        }
        if (bl == null) {
            object = fileObject.getPath();
            int n = ((String)object).lastIndexOf(46);
            bl = n != -1 && n > ((String)object).lastIndexOf(47) + 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        archiveFileCache.put(fileObject, bl);
        return bl;
    }

    public static boolean isArchiveFile(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("Cannot pass null URL to FileUtil.isArchiveFile");
        }
        if ("jar".equals(uRL.getProtocol())) {
            return false;
        }
        FileObject fileObject = URLMapper.findFileObject(uRL);
        if (fileObject != null && !fileObject.isVirtual()) {
            return FileUtil.isArchiveFile(fileObject);
        }
        String string = uRL.getPath();
        int n = string.lastIndexOf(46);
        return n != -1 && n > string.lastIndexOf(47) + 1;
    }

    public static void preventFileChooserSymlinkTraversal(JFileChooser jFileChooser, File file) {
        if (!Utilities.isWindows() && Utilities.getOperatingSystem() != 2048) {
            jFileChooser.setCurrentDirectory(FileUtil.wrapFileNoCanonicalize(file));
            jFileChooser.setFileSystemView(new NonCanonicalizingFileSystemView());
        } else {
            jFileChooser.setCurrentDirectory(file);
        }
    }

    static boolean assertDeprecatedMethod() {
        Thread.dumpStack();
        return true;
    }

    private static File wrapFileNoCanonicalize(File file) {
        if (file instanceof NonCanonicalizingFile) {
            return file;
        }
        if (file != null) {
            return new NonCanonicalizingFile(file);
        }
        return null;
    }

    private static File[] wrapFilesNoCanonicalize(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = FileUtil.wrapFileNoCanonicalize(fileArray[i]);
            }
        }
        return fileArray;
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("templateCategory");
        transientAttributes.add("instantiatingIterator");
        transientAttributes.add("instantiatingWizardURL");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        map = new Hashtable<String, String>();
        FileUtil.setMIMEType("xml", "text/xml");
        archiveFileCache = new WeakHashMap<FileObject, Boolean>();
    }

    private static final class NonCanonicalizingFile
    extends File {
        public NonCanonicalizingFile(File file) {
            this(file.getPath());
        }

        private NonCanonicalizingFile(String string) {
            super(string);
        }

        private NonCanonicalizingFile(URI uRI) {
            super(uRI);
        }

        public File getCanonicalFile() throws IOException {
            return FileUtil.wrapFileNoCanonicalize(FileUtil.normalizeFile(super.getAbsoluteFile()));
        }

        public String getCanonicalPath() throws IOException {
            return FileUtil.normalizeFile(super.getAbsoluteFile()).getAbsolutePath();
        }

        public File getParentFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getParentFile());
        }

        public File getAbsoluteFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getAbsoluteFile());
        }

        public File[] listFiles() {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles());
        }

        public File[] listFiles(FileFilter fileFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(fileFilter));
        }

        public File[] listFiles(FilenameFilter filenameFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(filenameFilter));
        }
    }

    private static final class NonCanonicalizingFileSystemView
    extends FileSystemView {
        private final FileSystemView delegate = FileSystemView.getFileSystemView();

        public boolean isFloppyDrive(File file) {
            return this.delegate.isFloppyDrive(file);
        }

        public boolean isComputerNode(File file) {
            return this.delegate.isComputerNode(file);
        }

        public File createNewFolder(File file) throws IOException {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createNewFolder(file));
        }

        public boolean isDrive(File file) {
            return this.delegate.isDrive(file);
        }

        public boolean isFileSystemRoot(File file) {
            return this.delegate.isFileSystemRoot(file);
        }

        public File getHomeDirectory() {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getHomeDirectory());
        }

        public File createFileObject(File file, String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createFileObject(file, string));
        }

        public Boolean isTraversable(File file) {
            return this.delegate.isTraversable(file);
        }

        public boolean isFileSystem(File file) {
            return this.delegate.isFileSystem(file);
        }

        public File getChild(File file, String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getChild(file, string));
        }

        public File getParentDirectory(File file) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getParentDirectory(file));
        }

        public Icon getSystemIcon(File file) {
            return this.delegate.getSystemIcon(file);
        }

        public boolean isParent(File file, File file2) {
            return this.delegate.isParent(file, file2);
        }

        public String getSystemTypeDescription(File file) {
            return this.delegate.getSystemTypeDescription(file);
        }

        public File getDefaultDirectory() {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getDefaultDirectory());
        }

        public String getSystemDisplayName(File file) {
            return this.delegate.getSystemDisplayName(file);
        }

        public File[] getRoots() {
            return FileUtil.wrapFilesNoCanonicalize(this.delegate.getRoots());
        }

        public boolean isHiddenFile(File file) {
            return this.delegate.isHiddenFile(file);
        }

        public File[] getFiles(File file, boolean bl) {
            return FileUtil.wrapFilesNoCanonicalize(this.delegate.getFiles(file, bl));
        }

        public boolean isRoot(File file) {
            return this.delegate.isRoot(file);
        }

        public File createFileObject(String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createFileObject(string));
        }
    }
}

