/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.GetLeftEditorAction;
import org.netbeans.core.multiview.GetRightEditorAction;
import org.netbeans.core.multiview.MultiViewActionMap;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponentLookup;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.multiview.TabsComponent;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.windows.TopComponent;

public final class MultiViewPeer {
    static final String MULTIVIEW_ID = "MultiView-";
    MultiViewModel model;
    TabsComponent tabs;
    SelectionListener selListener = new SelectionListener();
    CloseOperationHandler closeHandler;
    transient MultiViewTopComponentLookup lookup;
    TopComponent peer;
    private MultiViewModel.ActionRequestObserverFactory factory;
    private MultiViewActionMap delegatingMap;
    private boolean activated = false;
    private Object editorSettingsListener;
    private DelegateUndoRedo delegateUndoRedo;

    public MultiViewPeer(TopComponent pr, MultiViewModel.ActionRequestObserverFactory fact) {
        this.peer = pr;
        this.factory = fact;
        this.editorSettingsListener = this.createEditorListener();
        this.delegateUndoRedo = new DelegateUndoRedo();
    }

    public void setMultiViewDescriptions(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc) {
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        this.model = new MultiViewModel(descriptions, defaultDesc, this.factory);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
    }

    public void setCloseOperationHandler(CloseOperationHandler handler) {
        this.closeHandler = handler;
    }

    void setDeserializedMultiViewDescriptions(MultiViewDescription[] descriptions, MultiViewDescription defaultDesc, Map existingElements) {
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        this.model = new MultiViewModel(descriptions, defaultDesc, this.factory, existingElements);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
    }

    MultiViewModel getModel() {
        return this.model;
    }

    void initComponents() {
        this.initActionMap();
        this.peer.setLayout((LayoutManager)new BorderLayout());
        this.tabs = new TabsComponent(this.isToolbarVisible());
        this.peer.add((Component)this.tabs);
        ActionMap map = this.peer.getActionMap();
        AccessTogglesAction act = new AccessTogglesAction();
        map.put("NextViewAction", new GetRightEditorAction());
        map.put("PreviousViewAction", new GetLeftEditorAction());
        map.put("accesstoggles", act);
        InputMap input = this.peer.getInputMap(1);
        KeyStroke stroke = KeyStroke.getKeyStroke("control F10");
        input.put(stroke, "accesstoggles");
        input = this.peer.getInputMap(0);
        input.put(stroke, "accesstoggles");
        this.peer.putClientProperty((Object)"MultiViewBorderHack.topOffset", (Object)new Integer(this.tabs.getPreferredSize().height - 1));
    }

    private void initActionMap() {
        this.delegatingMap = new MultiViewActionMap(this.peer, new ActionMap());
        if (this.peer instanceof TopComponent.Cloneable) {
            this.delegatingMap.put("cloneWindow", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    TopComponent cloned = ((TopComponent.Cloneable)MultiViewPeer.this.peer).cloneComponent();
                    cloned.open();
                    cloned.requestActive();
                }
            });
        }
        this.delegatingMap.put("closeWindow", new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                MultiViewPeer.this.peer.close();
            }
        });
        this.peer.setActionMap((ActionMap)this.delegatingMap);
    }

    void peerComponentClosed() {
        Iterator it = this.model.getCreatedElements().iterator();
        while (it.hasNext()) {
            MultiViewElement el = (MultiViewElement)it.next();
            this.model.markAsHidden(el);
            el.componentClosed();
        }
    }

    void peerComponentShowing() {
        MultiViewElement el = this.model.getActiveElement();
        el.componentShowing();
        this.delegatingMap.setDelegateMap(el.getVisualRepresentation().getActionMap());
        ((MultiViewTopComponentLookup)this.peer.getLookup()).setElementLookup(el.getLookup());
        JComponent jc = el.getToolbarRepresentation();
        jc.setOpaque(false);
        this.tabs.setInnerToolBar(jc);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
        if (this.editorSettingsListener != null) {
            this.addEditorListener(this.editorSettingsListener);
        }
    }

    void peerComponentHidden() {
        this.model.getActiveElement().componentHidden();
        if (this.editorSettingsListener != null) {
            this.removeEditorListener(this.editorSettingsListener);
        }
    }

    void peerComponentDeactivated() {
        this.activated = false;
        this.model.getActiveElement().componentDeactivated();
    }

    boolean isActivated() {
        return this.activated;
    }

    void peerComponentActivated() {
        this.activated = true;
        this.model.getActiveElement().componentActivated();
    }

    void peerComponentOpened() {
        this.showCurrentElement(true);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
    }

    boolean requestFocusInWindow() {
        return this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
    }

    void requestFocus() {
        this.model.getActiveElement().getVisualRepresentation().requestFocus();
    }

    void hideElement(MultiViewDescription desc) {
        if (desc != null) {
            MultiViewElement el = this.model.getElementForDescription(desc);
            el.componentHidden();
        }
    }

    void showCurrentElement() {
        this.showCurrentElement(false);
    }

    private void showCurrentElement(boolean calledFromComponentOpened) {
        MultiViewElement el = this.model.getActiveElement();
        MultiViewDescription desc = this.model.getActiveDescription();
        this.tabs.switchToCard(el, desc.getDisplayName());
        this.peer.setIcon(desc.getIcon());
        if ((this.peer.isOpened() || calledFromComponentOpened) && !this.model.wasShownBefore(el)) {
            el.componentOpened();
            this.model.markAsShown(el);
        }
        if (!calledFromComponentOpened) {
            if (this.peer.isVisible()) {
                el.componentShowing();
            }
            this.delegatingMap.setDelegateMap(el.getVisualRepresentation().getActionMap());
            ((MultiViewTopComponentLookup)this.peer.getLookup()).setElementLookup(el.getLookup());
            if (this.peer.isVisible()) {
                this.tabs.setInnerToolBar(el.getToolbarRepresentation());
                this.tabs.setToolbarBarVisible(this.isToolbarVisible());
            }
        }
    }

    Action[] peerGetActions(Action[] superActions) {
        Action[] acts = this.model.getActiveElement().getActions();
        block0: for (int i = 0; i < acts.length; ++i) {
            Action act = acts[i];
            for (int j = 0; j < superActions.length; ++j) {
                Action superact = superActions[j];
                if (superact == null || act == null || !superact.getClass().equals(act.getClass())) continue;
                acts[i] = superActions[j];
                continue block0;
            }
        }
        return acts;
    }

    MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return new MVTCHandler();
    }

    int getPersistenceType() {
        MultiViewDescription[] descs = this.model.getDescriptions();
        int type = 2;
        for (int i = 0; i < descs.length; ++i) {
            if (!(descs[i] instanceof Serializable)) {
                Logger.getLogger(MultiViewTopComponent.class.getName()).warning("The MultiviewDescription instance " + descs[i].getClass() + " is not serializable. Cannot persist TopComponent.");
                type = 2;
                break;
            }
            if (descs[i].getPersistenceType() == 0) {
                type = descs[i].getPersistenceType();
            }
            if (descs[i].getPersistenceType() != 1 || type == 0) continue;
            type = descs[i].getPersistenceType();
        }
        return type;
    }

    String preferredID() {
        StringBuffer retValue = new StringBuffer(MULTIVIEW_ID);
        MultiViewDescription[] descs = this.model.getDescriptions();
        for (int i = 0; i < descs.length; ++i) {
            retValue.append(descs[i].preferredID());
            retValue.append("|");
        }
        return retValue.toString();
    }

    void peerWriteExternal(ObjectOutput out) throws IOException {
        if (this.closeHandler != null) {
            if (this.closeHandler instanceof Serializable) {
                out.writeObject(this.closeHandler);
            } else {
                Logger.getAnonymousLogger().info("The CloseOperationHandler isn not serializable. MultiView component id=" + this.preferredID());
            }
        }
        MultiViewDescription[] descs = this.model.getDescriptions();
        MultiViewDescription curr = this.model.getActiveDescription();
        int currIndex = 0;
        for (int i = 0; i < descs.length; ++i) {
            MultiViewElement elem;
            out.writeObject(descs[i]);
            if (descs[i].getPersistenceType() != 2 && (elem = this.model.getElementForDescription(descs[i], false)) != null && elem instanceof Serializable) {
                out.writeObject(elem);
            }
            if (descs[i] != curr) continue;
            currIndex = i;
        }
        out.writeObject(new Integer(currIndex));
    }

    void peerReadExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object obj;
        ArrayList<Object> descList = new ArrayList<Object>();
        HashMap map = new HashMap();
        int current = 0;
        CloseOperationHandler close = null;
        while (true) {
            if ((obj = in.readObject()) instanceof MultiViewDescription) {
                descList.add(obj);
            } else if (obj instanceof MultiViewElement) {
                map.put(descList.get(descList.size() - 1), obj);
            } else if (obj instanceof Integer) break;
            if (!(obj instanceof CloseOperationHandler)) continue;
            close = (CloseOperationHandler)obj;
        }
        Integer integ = (Integer)obj;
        current = integ;
        if (close == null) {
            close = SpiAccessor.DEFAULT.createDefaultCloseHandler();
        }
        this.setCloseOperationHandler(close);
        MultiViewDescription[] descs = new MultiViewDescription[descList.size()];
        descs = descList.toArray(descs);
        MultiViewDescription currDesc = descs[current];
        this.setDeserializedMultiViewDescriptions(descs, currDesc, map);
    }

    private Action[] getDefaultTCActions() {
        if (this.peer instanceof MultiViewTopComponent) {
            return ((MultiViewTopComponent)this.peer).getDefaultTCActions();
        }
        return new Action[0];
    }

    JEditorPane getEditorPane() {
        MultiViewElement el;
        if (this.model != null && (el = this.model.getActiveElement()) != null && el.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)el.getVisualRepresentation();
            return pane.getEditorPane();
        }
        return null;
    }

    HelpCtx getHelpCtx() {
        return this.model.getActiveDescription().getHelpCtx();
    }

    UndoRedo peerGetUndoRedo() {
        return this.delegateUndoRedo;
    }

    private UndoRedo privateGetUndoRedo() {
        return this.model.getActiveElement().getUndoRedo() != null ? this.model.getActiveElement().getUndoRedo() : UndoRedo.NONE;
    }

    boolean canClose() {
        Collection col = this.model.getCreatedElements();
        Iterator it = col.iterator();
        ArrayList<CloseOperationState> badOnes = new ArrayList<CloseOperationState>();
        while (it.hasNext()) {
            MultiViewElement el = (MultiViewElement)it.next();
            CloseOperationState state = el.canCloseElement();
            if (state.canClose()) continue;
            badOnes.add(state);
        }
        if (badOnes.size() > 0) {
            CloseOperationState[] states = new CloseOperationState[badOnes.size()];
            states = badOnes.toArray(states);
            return this.closeHandler.resolveCloseOperation(states);
        }
        return true;
    }

    public void updateName() {
        MultiViewElement el;
        if (this.model != null && (el = this.model.getActiveElement()).getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)el.getVisualRepresentation();
            pane.updateName();
            this.peer.setDisplayName(pane.getComponent().getDisplayName());
        }
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new MultiViewTopComponentLookup(this.delegatingMap);
        }
        return this.lookup;
    }

    void addEditorListener(Object listener) {
        try {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> settingsClass = Class.forName("org.netbeans.editor.Settings", false, loader);
            Class<?> listenerClass = Class.forName("org.netbeans.editor.SettingsChangeListener", false, loader);
            Method addSettingsListener = settingsClass.getMethod("addSettingsChangeListener", listenerClass);
            addSettingsListener.invoke(settingsClass, listener);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void removeEditorListener(Object listener) {
        try {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> settingsClass = Class.forName("org.netbeans.editor.Settings", false, loader);
            Class<?> listenerClass = Class.forName("org.netbeans.editor.SettingsChangeListener", false, loader);
            Method addSettingsListener = settingsClass.getMethod("removeSettingsChangeListener", listenerClass);
            addSettingsListener.invoke(settingsClass, listener);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    Object createEditorListener() {
        try {
            Class<?> listenerClass;
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                listenerClass = Class.forName("org.netbeans.editor.SettingsChangeListener", false, loader);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(MultiViewPeer.class.getName()).log(Level.CONFIG, "Disabling interaction with editor/lib", ex);
                return null;
            }
            InvocationHandler ih = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            (this).MultiViewPeer.this.tabs.setToolbarBarVisible(MultiViewPeer.this.isToolbarVisible());
                        }
                    });
                    return null;
                }
            };
            return Proxy.newProxyInstance(loader, new Class[]{listenerClass}, ih);
        }
        catch (Throwable t) {
            Logger.getLogger(MultiViewPeer.class.getName()).log(Level.WARNING, null, t);
            return null;
        }
    }

    boolean isToolbarVisible() {
        JEditorPane pane = this.getEditorPane();
        if (pane != null) {
            Action obj = pane.getActionMap().get("toggle-toolbar");
            if (obj == null) {
                return true;
            }
        } else {
            return true;
        }
        SharedClassObject option = null;
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            MultiViewPeer.class.getClassLoader();
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> editorBaseOption = Class.forName("org.netbeans.modules.editor.options.BaseOptions", true, loader);
            option = SharedClassObject.findObject(editorBaseOption);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        if (option != null) {
            try {
                Method is = option.getClass().getMethod("isToolbarVisible", new Class[0]);
                Object ret = is.invoke((Object)option, new Object[0]);
                if (ret instanceof Boolean) {
                    return (Boolean)ret;
                }
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public String toString() {
        return "[model=" + this.model + "]";
    }

    private class AccessTogglesAction
    extends AbstractAction {
        AccessTogglesAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F10"));
        }

        public void actionPerformed(ActionEvent e) {
            MultiViewPeer.this.tabs.requestFocusForSelectedButton();
        }
    }

    private class DelegateUndoRedo
    implements UndoRedo {
        private List listeners = new ArrayList();

        private DelegateUndoRedo() {
        }

        public boolean canUndo() {
            return MultiViewPeer.this.privateGetUndoRedo().canUndo();
        }

        public boolean canRedo() {
            return MultiViewPeer.this.privateGetUndoRedo().canRedo();
        }

        public void undo() throws CannotUndoException {
            MultiViewPeer.this.privateGetUndoRedo().undo();
        }

        public void redo() throws CannotRedoException {
            MultiViewPeer.this.privateGetUndoRedo().redo();
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
            MultiViewPeer.this.privateGetUndoRedo().addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
            MultiViewPeer.this.privateGetUndoRedo().removeChangeListener(l);
        }

        public String getUndoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getRedoPresentationName();
        }

        private void fireElementChange() {
            Iterator it = new ArrayList(this.listeners).iterator();
            while (it.hasNext()) {
                ChangeListener elem = (ChangeListener)it.next();
                ChangeEvent event = new ChangeEvent(this);
                elem.stateChanged(event);
            }
        }

        void updateListeners(MultiViewElement old, MultiViewElement fresh) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ChangeListener elem = (ChangeListener)it.next();
                if (old.getUndoRedo() != null) {
                    old.getUndoRedo().removeChangeListener(elem);
                }
                if (fresh.getUndoRedo() == null) continue;
                fresh.getUndoRedo().addChangeListener(elem);
            }
            this.fireElementChange();
        }
    }

    private class MVTCHandler
    implements MultiViewHandlerDelegate {
        private MultiViewPerspective[] perspectives = null;

        private MVTCHandler() {
        }

        public MultiViewPerspective[] getDescriptions() {
            return MultiViewPeer.this.model.getPerspectives();
        }

        public MultiViewPerspective getSelectedDescription() {
            return MultiViewPeer.this.model.getSelectedPerspective();
        }

        public void requestActive(MultiViewPerspective pers) {
            MultiViewDescription desc = Accessor.DEFAULT.extractDescription(pers);
            if (MultiViewPeer.this.model.getActiveDescription() != desc) {
                MultiViewPeer.this.model.getActiveElement().componentDeactivated();
                MultiViewPeer.this.tabs.changeActiveManually(desc);
                MultiViewPeer.this.model.getActiveElement().componentActivated();
            }
        }

        public void requestVisible(MultiViewPerspective pers) {
            MultiViewDescription desc = Accessor.DEFAULT.extractDescription(pers);
            MultiViewPeer.this.tabs.changeVisibleManually(desc);
        }
    }

    private class SelectionListener
    implements MultiViewModel.ElementSelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(MultiViewDescription oldOne, MultiViewDescription newOne) {
            MultiViewPeer.this.hideElement(oldOne);
            MultiViewPeer.this.showCurrentElement();
            MultiViewPeer.this.delegateUndoRedo.updateListeners(MultiViewPeer.this.model.getElementForDescription(oldOne), MultiViewPeer.this.model.getElementForDescription(newOne));
        }

        public void selectionActivatedByButton() {
            MultiViewElement elem = MultiViewPeer.this.model.getActiveElement();
            elem.getVisualRepresentation().requestFocus();
            elem.componentActivated();
        }
    }
}

