/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.OutputWindow;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.actions.FindAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

public class Controller {
    private static final int ACTION_COPY = 0;
    private static final int ACTION_WRAP = 1;
    private static final int ACTION_SAVEAS = 2;
    private static final int ACTION_CLOSE = 3;
    private static final int ACTION_NEXTERROR = 4;
    private static final int ACTION_PREVERROR = 5;
    private static final int ACTION_SELECTALL = 6;
    private static final int ACTION_FIND = 7;
    private static final int ACTION_FINDNEXT = 8;
    private static final int ACTION_NAVTOLINE = 9;
    private static final int ACTION_POSTMENU = 10;
    private static final int ACTION_FINDPREVIOUS = 11;
    private static final int ACTION_CLEAR = 12;
    private static final int ACTION_NEXTTAB = 13;
    private static final int ACTION_PREVTAB = 14;
    Action copyAction = new ControllerAction(0, "ACTION_COPY");
    Action wrapAction = new ControllerAction(1, "ACTION_WRAP");
    Action saveAsAction = new ControllerAction(2, "ACTION_SAVEAS");
    Action closeAction = new ControllerAction(3, "ACTION_CLOSE");
    Action nextErrorAction = new ControllerAction(4, "ACTION_NEXT_ERROR");
    Action prevErrorAction = new ControllerAction(5, "ACTION_PREV_ERROR");
    Action selectAllAction = new ControllerAction(6, "ACTION_SELECT_ALL");
    Action findAction = new ControllerAction(7, "ACTION_FIND");
    Action findNextAction = new ControllerAction(8, "ACTION_FIND_NEXT");
    Action findPreviousAction = new ControllerAction(11, "ACTION_FIND_PREVIOUS");
    Action navToLineAction = new ControllerAction(9, "navToLine", KeyStroke.getKeyStroke(10, 0));
    Action postMenuAction = new ControllerAction(10, "postMenu", KeyStroke.getKeyStroke(121, 64));
    Action clearAction = new ControllerAction(12, "ACTION_CLEAR");
    Action nextTabAction = new ControllerAction(13, "NextViewAction", null);
    Action prevTabAction = new ControllerAction(14, "PreviousViewAction", null);
    private Object[] popupItems = new Object[]{this.copyAction, new JSeparator(), this.findAction, this.findNextAction, new JSeparator(), this.wrapAction, new JSeparator(), this.saveAsAction, this.clearAction, this.closeAction};
    private Action[] kbdActions = new Action[]{this.copyAction, this.selectAllAction, this.findAction, this.findNextAction, this.findPreviousAction, this.wrapAction, this.saveAsAction, this.closeAction, this.navToLineAction, this.postMenuAction, this.clearAction};
    private CoalescedNameUpdater nameUpdater = null;
    private static String lastDir;
    private boolean firstF12 = true;
    boolean ignoreCaretChanges = false;
    public static final boolean LOG;
    public static final boolean VERBOSE;
    static final boolean logStdOut;
    private static OutputStream logStream;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$core$output2$OutputTab;
    static /* synthetic */ Class class$org$netbeans$core$output2$OutputWindow;
    static /* synthetic */ Class class$javax$swing$JPopupMenu;

    public static void ensureViewInDefault(final NbIO io, final boolean reuse) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OutputWindow.findDefault();
                IOEvent evt = new IOEvent(io, 0, reuse);
                NbIO.post(evt);
            }
        });
    }

    Controller() {
    }

    private OutputTab createOutputTab(OutputWindow win, NbIO io, boolean activateContainer, boolean reuse) {
        AbstractOutputTab[] ov = win.getTabs();
        JComponent result = null;
        if (LOG) {
            Controller.log("Find or create component for nbio " + io);
        }
        for (int i = 0; i < ov.length; ++i) {
            OutputTab oc = (OutputTab)ov[i];
            if (oc.getIO() != io) continue;
            if (LOG) {
                Controller.log("Found an existing tab");
            }
            result = oc;
            break;
        }
        if (result == null) {
            if (LOG) {
                Controller.log("Didn't find an existing open tab, checking hidden tabs");
            }
            OutputTab[] hidden = win.getHiddenTabs();
            for (int i = 0; i < hidden.length; ++i) {
                OutputTab oc = hidden[i];
                if (hidden[i].getIO() != io) continue;
                if (LOG) {
                    Controller.log("Found a hidden tab with the same IO.  Unhiding it for reuse");
                }
                result = oc;
                this.unhideHiddenView(win, (OutputTab)result);
                break;
            }
        }
        if (LOG) {
            Controller.log("FindOrCreate: " + io.getName() + " found=" + (result != null) + " for io " + io);
        }
        if (result == null) {
            if (LOG) {
                Controller.log("Find or create creating " + io.getName());
            }
            result = this.createAndInstallView(win, io);
        }
        if (result != null) {
            result.getActionMap().put("jumpPrev", this.prevErrorAction);
            result.getActionMap().put("jumpNext", this.nextErrorAction);
            result.getActionMap().put(FindAction.class.getName(), this.findAction);
            result.getActionMap().put("copy-to-clipboard", this.copyAction);
        }
        if (result != null) {
            win.setSelectedTab((AbstractOutputTab)result);
        }
        return result;
    }

    private OutputTab createAndInstallView(OutputWindow win, NbIO io) {
        if (LOG) {
            Controller.log("Create and install a new tab for : " + io.getName());
        }
        OutputTab result = new OutputTab(io);
        result.setName(io.getName() + " ");
        Action[] a = io.getToolbarActions();
        if (a != null) {
            result.setToolbarActions(a);
        }
        for (int i = 0; i < this.kbdActions.length; ++i) {
            result.installKeyboardAction(this.kbdActions[i]);
        }
        if (LOG) {
            Controller.log("Adding and selecting new tab " + result);
        }
        win.add(result);
        win.setSelectedTab(result);
        AbstractOutputTab[] aot = win.getTabs();
        for (int i = 0; i < aot.length; ++i) {
            this.updateName(win, (OutputTab)aot[i]);
        }
        return result;
    }

    private void unhideHiddenView(OutputWindow win, OutputTab hidden) {
        if (LOG) {
            Controller.log("Unhiding hidden tab for " + hidden.getIO());
        }
        win.add(hidden);
        win.removeHiddenView(hidden);
    }

    private void updateName(OutputWindow win, OutputTab tab) {
        if (this.nameUpdater == null) {
            if (LOG) {
                Controller.log("Update name for " + tab.getIO() + " dispatching a name updater");
            }
            this.nameUpdater = new CoalescedNameUpdater(win);
            SwingUtilities.invokeLater(this.nameUpdater);
        }
        this.nameUpdater.add(tab);
    }

    private void forceName(OutputWindow win, OutputTab tab) {
        if (LOG) {
            Controller.log("ForceName ensuring non-html tab name");
        }
        if (this.nameUpdater != null) {
            if (LOG) {
                Controller.log("  an update was queued, aborting it");
            }
            this.nameUpdater.remove(tab);
        }
        if (win.isAncestorOf(tab)) {
            String escaped;
            try {
                escaped = XMLUtil.toAttributeValue((String)(tab.getIO().getName() + " "));
            }
            catch (CharConversionException e) {
                escaped = tab.getIO().getName() + " ";
            }
            if (LOG) {
                Controller.log("  setting non-html name " + escaped);
            }
            win.setTabTitle(tab, escaped.replace("&apos;", "'"));
        }
    }

    public void actionPerformed(OutputWindow win, OutputTab tab, int id) {
        switch (id) {
            case 0: {
                tab.getOutputPane().copy();
                break;
            }
            case 1: {
                boolean wrapped = tab.getOutputPane().isWrapped();
                tab.getOutputPane().setWrapped(!wrapped);
                break;
            }
            case 2: {
                this.saveAs(tab);
                break;
            }
            case 3: {
                this.close(win, tab, false);
                break;
            }
            case 4: {
                this.sendCaretToError(win, tab, false);
                break;
            }
            case 5: {
                this.sendCaretToError(win, tab, true);
                break;
            }
            case 6: {
                tab.getOutputPane().selectAll();
                break;
            }
            case 7: {
                int start = tab.getOutputPane().getSelectionStart();
                int end = tab.getOutputPane().getSelectionEnd();
                String str = null;
                if (start > 0 && end > start) {
                    try {
                        str = tab.getOutputPane().getDocument().getText(start, end - start);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
                FindDialogPanel.showFindDialog(tab.getFindActionListener(this.findNextAction, this.findPreviousAction, this.copyAction), str);
                break;
            }
            case 8: {
                this.findNext(tab);
                break;
            }
            case 11: {
                this.findPrevious(tab);
                break;
            }
            case 9: {
                if (LOG) {
                    Controller.log("Action NAVTOLINE received");
                }
                this.openLineIfError(tab);
                break;
            }
            case 10: {
                if (LOG) {
                    Controller.log("Action POSTMENU received");
                }
                this.postPopupMenu(win, tab, new Point(0, 0), tab);
                break;
            }
            case 12: {
                NbIO io;
                if (LOG) {
                    Controller.log("Action CLEAR receieved");
                }
                if ((io = tab.getIO()) != null) {
                    NbWriter writer = io.writer();
                    if (writer != null) {
                        try {
                            if (LOG) {
                                Controller.log("Resetting the writer for Clear");
                            }
                            writer.reset();
                            this.forceName(win, tab);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                        break;
                    }
                    if (!LOG) break;
                    Controller.log("IO's NbWriter is null");
                    break;
                }
                if (!LOG) break;
                Controller.log("Clear on a tab with no IO");
                break;
            }
            case 13: {
                if (LOG) {
                    Controller.log("Action NEXTTAB received");
                }
                win.selectNextTab(tab);
                break;
            }
            case 14: {
                if (LOG) {
                    Controller.log("Action PREVTAB received");
                }
                win.selectPreviousTab(tab);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void openLineIfError(OutputTab tab) {
        OutWriter out = tab.getIO().out();
        if (out != null) {
            int line = tab.getOutputPane().getCaretLine();
            OutputListener lis = out.getLines().getListenerForLine(line);
            if (lis != null) {
                if (LOG) {
                    Controller.log(" Sending action for getLine " + line);
                }
                this.ignoreCaretChanges = true;
                tab.getOutputPane().sendCaretToLine(line, true);
                this.ignoreCaretChanges = false;
                ControllerOutputEvent coe = new ControllerOutputEvent(tab.getIO(), line);
                lis.outputLineAction((OutputEvent)coe);
            }
        }
    }

    private void findNext(OutputTab tab) {
        OutWriter out = tab.getIO().out();
        if (out != null) {
            String lastPattern = FindDialogPanel.getPanel().getPattern();
            if (lastPattern != null) {
                out.getLines().find(lastPattern);
            }
            Matcher matcher = out.getLines().getForwardMatcher();
            int pos = tab.getOutputPane().getCaretPos();
            if (pos >= tab.getOutputPane().getLength() || pos < 0) {
                pos = 0;
            }
            if (matcher != null && matcher.find(pos)) {
                tab.getOutputPane().setSelection(matcher.start(), matcher.end());
                this.copyAction.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void findPrevious(OutputTab tab) {
        OutWriter out = tab.getIO().out();
        if (out != null) {
            String lastPattern = FindDialogPanel.getPanel().getPattern();
            if (lastPattern != null) {
                out.getLines().find(lastPattern);
            }
            Matcher matcher = out.getLines().getReverseMatcher();
            int length = tab.getOutputPane().getLength();
            int pos = length - tab.getOutputPane().getSelectionStart();
            if (pos >= tab.getOutputPane().getLength() - 1 || pos < 0) {
                pos = 0;
            }
            if (LOG) {
                Controller.log("Reverse search from " + pos);
            }
            if (matcher != null && matcher.find(pos)) {
                int start = length - matcher.end();
                int end = length - matcher.start();
                tab.getOutputPane().setSelection(start, end);
                this.copyAction.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void updateActions(OutputWindow win, OutputTab tab) {
        if (tab == win.getSelectedTab()) {
            OutputPane pane = (OutputPane)tab.getOutputPane();
            int len = pane.getLength();
            boolean enable = len > 0;
            this.findAction.setEnabled(enable);
            OutWriter out = tab.getIO().out();
            this.saveAsAction.setEnabled(enable);
            this.selectAllAction.setEnabled(enable);
            this.copyAction.setEnabled(pane.hasSelection());
            boolean hasErrors = out == null ? false : out.getLines().firstListenerLine() != -1;
            this.nextErrorAction.setEnabled(hasErrors);
            this.prevErrorAction.setEnabled(hasErrors);
        }
    }

    public void close(OutputWindow win, OutputTab tab, boolean programmatic) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean hadFocus = focusOwner != null && (focusOwner == win || win.isAncestorOf(focusOwner));
        win.remove(tab);
        boolean winClosed = false;
        if (!programmatic && win.getTabs().length == 0) {
            if (LOG) {
                Controller.log("Last tab closed by user, closing output window.");
            }
            win.close();
            winClosed = true;
        }
        if (hadFocus && !winClosed && win.getSelectedTab() != null) {
            if (LOG) {
                Controller.log("Trying to send focus to the newly selected tab");
            }
            win.getSelectedTab().requestFocus();
        }
        if (LOG) {
            Controller.log("Close received, removing " + tab + " from component");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs(OutputTab tab) {
        OutWriter out = tab.getIO().out();
        if (out == null) {
            return;
        }
        File f = Controller.showFileChooser(tab);
        if (f != null) {
            try {
                OutWriter outWriter = out;
                synchronized (outWriter) {
                    out.getLines().saveAs(f.getPath());
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static File showFileChooser(JComponent owner) {
        File f = null;
        String dlgTtl = NbBundle.getMessage((Class)Controller.class, (String)"TITLE_SAVE_DLG");
        boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (isAqua) {
            FileDialog fd = new FileDialog((Frame)owner.getTopLevelAncestor(), dlgTtl, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                fd.setDirectory(lastDir);
            }
            fd.setModal(true);
            fd.setVisible(true);
            String s = fd.getDirectory() + fd.getFile();
            f = new File(s);
            if (f.exists() && f.isDirectory()) {
                f = null;
            }
        } else {
            File dir;
            JFileChooser jfc = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && (dir = new File(lastDir)).exists()) {
                jfc.setCurrentDirectory(dir);
            }
            jfc.setName(dlgTtl);
            jfc.setDialogTitle(dlgTtl);
            if (jfc.showSaveDialog(owner.getTopLevelAncestor()) == 0) {
                f = jfc.getSelectedFile();
            }
        }
        if (f != null && f.exists() && !isAqua) {
            String msg = NbBundle.getMessage((Class)Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{f.getName()});
            String title = NbBundle.getMessage((Class)Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(owner.getTopLevelAncestor(), msg, title, 2) != 0) {
                f = null;
            }
        }
        if (f != null) {
            lastDir = f.getParent();
        }
        return f;
    }

    public void selectionChanged(OutputWindow win, OutputTab former, OutputTab current) {
        if (former != null) {
            former.updateTimestamp();
        }
        if (current != null) {
            current.updateTimestamp();
            this.updateActions(win, current);
        }
    }

    public void notifyActivated(OutputWindow win) {
        OutputTab tab = (OutputTab)win.getSelectedTab();
        if (tab != null) {
            this.updateActions(win, tab);
        }
    }

    private void sendCaretToError(OutputWindow win, OutputTab tab, boolean backward) {
        if (tab == null && (tab = (OutputTab)win.getSelectedTab()) == null) {
            return;
        }
        OutWriter out = tab.getIO().out();
        if (out != null) {
            int line;
            int n = line = this.firstF12 ? 0 : Math.max(0, tab.getOutputPane().getCaretLine());
            if (line >= tab.getOutputPane().getLineCount() - 1) {
                line = 0;
            }
            int newline = out.getLines().nearestListenerLine(line, backward);
            if (LOG) {
                Controller.log("sendCaretToError - caret line: " + line + " nearest listener line " + newline);
            }
            if (newline == line) {
                if (!backward && line != tab.getOutputPane().getLineCount()) {
                    newline = out.getLines().nearestListenerLine(line + 1, backward);
                } else if (backward && line > 0) {
                    newline = out.getLines().nearestListenerLine(line - 1, backward);
                } else {
                    return;
                }
            }
            if (newline != -1) {
                if (LOG) {
                    Controller.log("Sending caret to error line " + newline);
                }
                tab.getOutputPane().sendCaretToLine(newline, true);
                if (!win.isActivated()) {
                    OutputListener l = out.getLines().getListenerForLine(newline);
                    ControllerOutputEvent ce = new ControllerOutputEvent(tab.getIO(), newline);
                    l.outputLineAction((OutputEvent)ce);
                }
            }
            this.firstF12 = false;
        }
    }

    public void notifyRemoved(OutputTab tab) {
        NbWriter w;
        NbIO io;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (LOG) {
            Controller.log("Tab " + tab + " has been CLOSED.  Disposing its IO.");
        }
        if ((io = tab.getIO()) != null) {
            io.setClosed(true);
        }
        if ((w = io.writer()) != null && w.isClosed()) {
            tab.setDocument(null);
        } else if (w != null) {
            tab.getDocument().disposeQuietly();
        }
    }

    public void notifyInput(OutputWindow win, OutputTab tab, String txt) {
        NbIO.IOReader in;
        NbIO io;
        if (LOG) {
            Controller.log("Notify input on " + tab + " - " + txt);
        }
        if ((io = tab.getIO()) != null && (in = io.in()) != null) {
            if (LOG) {
                Controller.log("Sending input to " + in);
            }
            in.pushText(txt + "\n");
            io.getOut().println(txt);
        }
    }

    private OutputListener listenerForLine(OutputTab tab, int line) {
        OutWriter out = tab.getIO().out();
        if (out != null) {
            return out.getLines().getListenerForLine(line);
        }
        return null;
    }

    public void lineClicked(OutputWindow win, OutputTab tab, int line) {
        OutputListener l = this.listenerForLine(tab, line);
        if (l != null) {
            ControllerOutputEvent oe = new ControllerOutputEvent(tab.getIO(), line);
            l.outputLineAction((OutputEvent)oe);
            tab.getOutputPane().sendCaretToLine(line, true);
        }
    }

    public void postPopupMenu(OutputWindow win, OutputTab tab, Point p, Component src) {
        if (LOG) {
            Controller.log("post popup menu for " + tab.getName());
        }
        JPopupMenu popup = new JPopupMenu();
        popup.putClientProperty("container", win);
        popup.putClientProperty("component", tab);
        Action[] a = tab.getToolbarActions();
        if (a.length > 0) {
            boolean added = false;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].getValue("Name") == null) continue;
                popup.add(new ProxyAction(a[i]));
                added = true;
            }
            if (added) {
                popup.add(new JSeparator());
            }
        }
        for (int i = 0; i < this.popupItems.length; ++i) {
            if (this.popupItems[i] instanceof JSeparator) {
                popup.add((JSeparator)this.popupItems[i]);
                continue;
            }
            if (this.popupItems[i] != this.wrapAction) {
                popup.add((Action)this.popupItems[i]);
                continue;
            }
            JCheckBoxMenuItem item = new JCheckBoxMenuItem((Action)this.popupItems[i]);
            item.setSelected(tab.getOutputPane().isWrapped());
            popup.add(item);
        }
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        JTextComponent c = tab.getOutputPane().getTextView();
        Object escHandle = c.getInputMap().get(esc);
        c.getInputMap().remove(esc);
        tab.getInputMap(1).remove(esc);
        popup.addPopupMenuListener(new PMListener(this.popupItems, escHandle));
        popup.show(src, p.x, p.y);
    }

    public void caretEnteredLine(OutputTab tab, int line) {
        if (!this.ignoreCaretChanges) {
            OutputListener l = this.listenerForLine(tab, line);
            if (LOG) {
                Controller.log("Caret entered line " + line + " notifying listener " + l);
            }
            if (l != null) {
                ControllerOutputEvent oe = new ControllerOutputEvent(tab.getIO(), line);
                l.outputLineSelected((OutputEvent)oe);
            }
        } else if (LOG) {
            Controller.log("Caret entered line " + line + " which has no listener");
        }
    }

    public void documentChanged(OutputWindow win, OutputTab tab) {
        if (tab.getIO().isFocusTaken()) {
            win.setSelectedTab(tab);
            win.requestVisible();
        }
        this.updateName(win, tab);
        if (tab == win.getSelectedTab() && win.isActivated()) {
            this.updateActions(win, tab);
        }
    }

    public void performCommand(OutputWindow win, OutputTab tab, NbIO io, int command, boolean value, Object data) {
        if (LOG) {
            Controller.log("PERFORMING: " + IOEvent.cmdToString(command) + " value=" + value + " on " + io + " tob " + tab);
        }
        OutWriter out = io.out();
        switch (command) {
            case 0: {
                this.createOutputTab(win, io, io.isFocusTaken(), value);
                break;
            }
            case 2: {
                if (value && tab == null) {
                    tab = this.createOutputTab(win, io, io.isFocusTaken(), value);
                }
                if (tab == null) break;
                tab.setInputVisible(value);
                win.setSelectedTab(tab);
                break;
            }
            case 6: {
                if (tab == null) {
                    tab = this.createOutputTab(win, io, io.isFocusTaken(), value);
                }
                if (!win.isOpened()) {
                    win.open();
                }
                if (!io.isFocusTaken()) {
                    win.requestVisibleForNewTab();
                } else {
                    win.requestActiveForNewTab();
                }
                if (win.getSelectedTab() == tab) break;
                if (tab.getParent() == null) {
                    win.add(tab);
                }
                win.setSelectedTab(tab);
                this.updateName(win, tab);
                break;
            }
            case 10: {
                if (tab == null && data != null) {
                    tab = this.createOutputTab(win, io, io.isFocusTaken(), value);
                }
                Action[] a = (Action[])data;
                tab.setToolbarActions(a);
                break;
            }
            case 7: {
                if (tab != null) {
                    this.close(win, tab, true);
                    win.revalidate();
                    win.repaint();
                    break;
                }
                io.dispose();
                break;
            }
            case 8: {
                if (value) {
                    if (tab == null) {
                        if (io.out() == null) break;
                        io.out().dispose();
                        break;
                    }
                    if (tab.getParent() != null) {
                        this.updateName(win, tab);
                        if (tab.getIO().out() != null && tab.getIO().out().getLines().firstListenerLine() == -1) {
                            tab.getOutputPane().ensureCaretPosition();
                        }
                        if (tab != win.getSelectedTab()) break;
                        this.updateActions(win, tab);
                        break;
                    }
                    win.removeHiddenView(tab);
                    if (io.out() == null) break;
                    io.out().dispose();
                    break;
                }
                if (tab == null || tab.getParent() == null) break;
                this.updateName(win, tab);
                break;
            }
            case 9: {
                this.firstF12 = true;
                if (tab == null) {
                    if (LOG) {
                        Controller.log("Got a reset on an io with no tab.  Creating a tab.");
                    }
                    this.performCommand(win, null, io, 0, value, data);
                    win.requestVisible();
                    return;
                }
                if (LOG) {
                    Controller.log("Setting io " + io + " on tab " + tab);
                }
                tab.setIO(io);
                win.setSelectedTab(tab);
                this.updateName(win, tab);
                if (!LOG) break;
                Controller.log("Reset on " + tab + " tab displayable " + tab.isDisplayable() + " io " + io + " io.out " + io.out());
                break;
            }
            case 12: {
                win.setTabIcon(tab, io.getIcon());
            }
        }
    }

    private void navigateToFirstErrorLine(OutputTab comp) {
        OutWriter out = comp.getIO().out();
        if (out != null) {
            int line = comp.getFirstNavigableListenerLine();
            if (LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + line);
            }
            if (line > 0) {
                comp.getOutputPane().sendCaretToLine(line, false);
                if (Controller.isSDI(comp)) {
                    comp.requestActive();
                }
            }
        }
    }

    private static boolean isSDI(OutputTab comp) {
        Container c = comp.getTopLevelAncestor();
        return c != WindowManager.getDefault().getMainWindow();
    }

    public void hasSelectionChanged(OutputWindow outputWindow, OutputTab tab, boolean val) {
        if (tab == outputWindow.getSelectedTab()) {
            this.copyAction.setEnabled(val);
            this.selectAllAction.setEnabled(!tab.getOutputPane().isAllSelected());
        }
    }

    public void hasOutputListenersChanged(OutputWindow win, OutputTab tab, boolean hasOutputListeners) {
        if (hasOutputListeners && win.getSelectedTab() == tab && tab.isShowing()) {
            this.navigateToFirstErrorLine(tab);
        }
    }

    public static void log(String s) {
        s = Long.toString(System.currentTimeMillis()) + ":" + s + "(" + Thread.currentThread() + ")  ";
        if (logStdOut) {
            System.out.println(s);
            return;
        }
        OutputStream os = Controller.getLogStream();
        byte[] b = new byte[s.length() + 1];
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)c[i];
        }
        b[b.length - 1] = 10;
        try {
            os.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(s);
        }
        try {
            os.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void logStack() {
        if (logStdOut) {
            new Exception().printStackTrace();
            return;
        }
        Exception e = new Exception();
        e.fillInStackTrace();
        StackTraceElement[] ste = e.getStackTrace();
        for (int i = 1; i < Math.min(22, ste.length); ++i) {
            Controller.log("   *   " + ste[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream getLogStream() {
        if (logStream == null) {
            String spec = System.getProperty("java.io.tmpdir") + File.separator + "outlog.txt";
            Class clazz = Controller.class;
            synchronized (clazz) {
                try {
                    File f = new File(spec);
                    if (f.exists()) {
                        f.delete();
                    }
                    f.createNewFile();
                    logStream = new FileOutputStream(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logStream = System.err;
                }
            }
        }
        return logStream;
    }

    public void inputEof(OutputTab tab) {
        NbIO io;
        NbIO.IOReader in;
        if (LOG) {
            Controller.log("Input EOF");
        }
        if ((in = (io = tab.getIO()).in()) != null) {
            in.eof();
        }
    }

    static {
        $assertionsDisabled = !Controller.class.desiredAssertionStatus();
        lastDir = null;
        LOG = Boolean.getBoolean("nb.output.log") || Boolean.getBoolean("nb.output.log.verbose");
        VERBOSE = Boolean.getBoolean("nb.output.log.verbose");
        logStdOut = Boolean.getBoolean("nb.output.log.stdout");
        logStream = null;
    }

    private class CoalescedNameUpdater
    implements Runnable {
        private HashSet components = new HashSet();
        private OutputWindow win;

        CoalescedNameUpdater(OutputWindow win) {
            this.win = win;
        }

        public void add(OutputTab tab) {
            this.components.add(tab);
        }

        public void remove(OutputTab tab) {
            this.components.remove(tab);
        }

        public void run() {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                String name;
                String escaped;
                OutputTab t = (OutputTab)i.next();
                NbIO io = t.getIO();
                if (LOG) {
                    Controller.log("Update name for " + io.getName() + " stream " + "closed is " + io.isStreamClosed());
                }
                if (!this.win.isAncestorOf(t)) continue;
                try {
                    escaped = XMLUtil.toAttributeValue((String)io.getName());
                }
                catch (CharConversionException e) {
                    escaped = io.getName();
                }
                boolean wasReset = io.checkReset();
                boolean useHtml = io.isStreamClosed() && !wasReset;
                String string = name = useHtml ? io.getName() + " " : "<html><b>" + escaped + " </b>&nbsp;</html>";
                if (LOG) {
                    Controller.log("  set name to " + name);
                }
                this.win.setTabTitle(t, name.replace("&apos;", "'"));
            }
            Controller.this.nameUpdater = null;
        }
    }

    private static class ControllerAction
    extends AbstractAction {
        private int id;

        ControllerAction(int id, String bundleKey) {
            if (bundleKey != null) {
                String name = NbBundle.getMessage((Class)(class$org$netbeans$core$output2$Controller == null ? (class$org$netbeans$core$output2$Controller = Controller.class$("org.netbeans.core.output2.Controller")) : class$org$netbeans$core$output2$Controller), (String)bundleKey);
                KeyStroke accelerator = ControllerAction.getAcceleratorFor(bundleKey);
                this.id = id;
                this.putValue("Name", name);
                this.putValue("AcceleratorKey", accelerator);
            }
        }

        ControllerAction(int id, String name, KeyStroke stroke) {
            this.id = id;
            this.putValue("Name", name);
            this.putValue("AcceleratorKey", stroke);
        }

        void clearListeners() {
            PropertyChangeListener[] l = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < l.length; ++i) {
                this.removePropertyChangeListener(l[i]);
            }
        }

        private static KeyStroke getAcceleratorFor(String name) {
            String key = name + ".accel";
            if (Utilities.isMac()) {
                key = key + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage((Class)(class$org$netbeans$core$output2$Controller == null ? (class$org$netbeans$core$output2$Controller = Controller.class$("org.netbeans.core.output2.Controller")) : class$org$netbeans$core$output2$Controller), (String)key));
        }

        public int getID() {
            return this.id;
        }

        public void actionPerformed(ActionEvent e) {
            Controller cont;
            JPopupMenu jpm;
            OutputWindow win;
            OutputTab outComp;
            Component c;
            if (LOG) {
                Controller.log("ACTION PERFORMED: " + this.getValue("Name"));
            }
            Object object = (c = (Component)e.getSource()) instanceof OutputTab ? (OutputTab)c : (c instanceof OutputWindow ? null : (outComp = (OutputTab)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$output2$OutputTab == null ? (class$org$netbeans$core$output2$OutputTab = Controller.class$("org.netbeans.core.output2.OutputTab")) : class$org$netbeans$core$output2$OutputTab, c)));
            OutputWindow outputWindow = c instanceof OutputWindow ? (OutputWindow)((Object)c) : (win = (OutputWindow)((Object)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$output2$OutputWindow == null ? (class$org$netbeans$core$output2$OutputWindow = Controller.class$("org.netbeans.core.output2.OutputWindow")) : class$org$netbeans$core$output2$OutputWindow, outComp)));
            if (win == null) {
                win = OutputWindow.findDefault();
            }
            if (outComp == null && win != null) {
                outComp = (OutputTab)win.getSelectedTab();
            }
            if (win == null && outComp == null && (jpm = (JPopupMenu)SwingUtilities.getAncestorOfClass(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = Controller.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, c)) != null) {
                win = (OutputWindow)jpm.getClientProperty("win");
                outComp = (OutputTab)jpm.getClientProperty("component");
            }
            if ((cont = win.getController()) != null) {
                cont.actionPerformed(win, outComp, this.getID());
            }
        }
    }

    static class ControllerOutputEvent
    extends OutputEvent {
        private int line;

        ControllerOutputEvent(NbIO io, int line) {
            super((InputOutput)io);
            this.line = line;
        }

        void setLine(int line) {
            this.line = line;
        }

        public String getLine() {
            NbIO io = (NbIO)this.getSource();
            OutWriter out = io.out();
            try {
                if (out != null) {
                    String s = out.getLines().getLine(this.line);
                    if (s.endsWith("\n")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (s.endsWith("\r")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }
            }
            catch (IOException ioe) {
                IOException nue = new IOException("Could not fetch line " + this.line + " on " + io.getName());
                nue.initCause(ioe);
                Exceptions.printStackTrace((Throwable)ioe);
            }
            return null;
        }
    }

    private static class PMListener
    implements PopupMenuListener {
        private Object[] popupItems;
        private Object handle;

        PMListener(Object[] popupItems, Object escHandle) {
            this.popupItems = popupItems;
            this.handle = escHandle;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            popup.removeAll();
            popup.setInvoker(null);
            AbstractOutputTab tab = (AbstractOutputTab)popup.getClientProperty("component");
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            JTextComponent c = tab.getOutputPane().getTextView();
            c.getInputMap().put(esc, this.handle);
            tab.getInputMap(1).put(esc, this.handle);
            popup.putClientProperty("container", null);
            popup.putClientProperty("component", null);
            popup.removePopupMenuListener(this);
            for (int i = 0; i < this.popupItems.length; ++i) {
                if (!(this.popupItems[i] instanceof ControllerAction)) continue;
                ((ControllerAction)this.popupItems[i]).clearListeners();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(e);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action original) {
            this.orig = original;
        }

        public Object getValue(String key) {
            if ("SmallIcon".equals(key)) {
                return null;
            }
            return this.orig.getValue(key);
        }

        public void putValue(String key, Object value) {
            this.orig.putValue(key, value);
        }

        public void setEnabled(boolean b) {
            this.orig.setEnabled(b);
        }

        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.orig.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.orig.removePropertyChangeListener(listener);
        }

        public void actionPerformed(ActionEvent e) {
            this.orig.actionPerformed(e);
        }
    }
}

