/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class FileMapStorage
implements Storage {
    private FileChannel writeChannel;
    private FileChannel readChannel;
    private static final int BASE_BUFFER_SIZE = 8196;
    private static final long MAX_MAP_RANGE = 0x1400000L;
    private ByteBuffer master;
    private ByteBuffer contents;
    private long mappedRange;
    private long mappedStart;
    private ByteBuffer buffer = null;
    protected int bytesWritten = 0;
    private File outfile = null;
    private int outstandingBufferCount = 0;

    FileMapStorage() {
        this.init();
    }

    private void init() {
        this.contents = null;
        this.mappedRange = -1L;
        this.mappedStart = 0L;
        this.master = ByteBuffer.allocateDirect(8196);
        this.readChannel = null;
        this.writeChannel = null;
        this.buffer = null;
        this.bytesWritten = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFileExists() throws IOException {
        if (this.outfile == null) {
            File dir;
            String outdir = System.getProperty("java.io.tmpdir");
            if (!outdir.endsWith(File.separator)) {
                outdir = outdir + File.separator;
            }
            if (!(dir = new File(outdir)).exists() || !dir.canWrite()) {
                IllegalStateException ise = new IllegalStateException("Cannot write to " + outdir);
                Exceptions.attachLocalizedMessage((Throwable)ise, (String)NbBundle.getMessage((Class)OutWriter.class, (String)"FMT_CannotWrite", (Object)outdir));
                throw ise;
            }
            Class clazz = FileMapStorage.class;
            synchronized (clazz) {
                StringBuilder fname = new StringBuilder(outdir).append("output").append(Long.toString(System.currentTimeMillis()));
                this.outfile = new File(fname.toString());
                while (this.outfile.exists()) {
                    fname.append('x');
                    this.outfile = new File(fname.toString());
                }
                this.outfile.createNewFile();
                this.outfile.deleteOnExit();
            }
        }
    }

    public String toString() {
        return this.outfile == null ? "[unused or disposed FileMapStorage]" : this.outfile.getPath();
    }

    private FileChannel writeChannel() {
        try {
            if (this.writeChannel == null) {
                this.ensureFileExists();
                FileOutputStream fos = new FileOutputStream(this.outfile, true);
                this.writeChannel = fos.getChannel();
            }
            return this.writeChannel;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private FileChannel readChannel() {
        if (this.readChannel == null) {
            try {
                this.ensureFileExists();
                FileInputStream fis = new FileInputStream(this.outfile);
                this.readChannel = fis.getChannel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.readChannel;
    }

    public synchronized ByteBuffer getWriteBuffer(int size) throws IOException {
        if (this.master.capacity() - this.master.position() < size) {
            int newSize = Math.max(16392, size + 8196);
            this.master = ByteBuffer.allocateDirect(newSize);
        }
        if (this.buffer == null) {
            this.buffer = this.master.slice();
        } else {
            int charsRemaining = AbstractLines.toCharIndex(this.buffer.capacity() - this.buffer.position());
            if (charsRemaining < size) {
                this.buffer.flip();
                this.buffer = this.master.slice();
            }
        }
        ++this.outstandingBufferCount;
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer bb, boolean addNewLine) throws IOException {
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            if (bb == this.buffer) {
                this.buffer = null;
            }
        }
        int position = this.size();
        int byteCount = bb.position();
        bb.flip();
        if (this.writeChannel().isOpen()) {
            this.writeChannel().write(bb);
            if (addNewLine) {
                this.writeChannel().write(ByteBuffer.wrap(OutWriter.lineSepBytes));
            }
            FileMapStorage fileMapStorage2 = this;
            synchronized (fileMapStorage2) {
                this.bytesWritten += byteCount + (addNewLine ? OutWriter.lineSepBytes.length : 0);
                --this.outstandingBufferCount;
            }
        }
        return position;
    }

    public synchronized void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing file map storage");
            Controller.logStack();
        }
        if (this.writeChannel != null && this.writeChannel.isOpen()) {
            try {
                this.writeChannel.close();
                this.writeChannel = null;
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (this.readChannel != null && this.readChannel.isOpen()) {
            try {
                this.readChannel.close();
                this.readChannel = null;
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (this.outfile != null && this.outfile.exists()) {
            try {
                this.outfile.delete();
                this.outfile = null;
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.buffer = null;
        this.contents = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getReadBuffer(int start, int byteCount) throws IOException {
        ByteBuffer cont;
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            cont = this.contents;
            if (cont == null || (long)(start + byteCount) > this.mappedRange || (long)start < this.mappedStart) {
                FileChannel ch = this.readChannel();
                long offset = start + byteCount;
                this.mappedStart = Math.max(0L, (long)start - 0xA00000L);
                long prevMappedRange = this.mappedRange;
                this.mappedRange = Math.min(ch.size(), (long)start + 0xA00000L);
                try {
                    try {
                        this.contents = cont = ch.map(FileChannel.MapMode.READ_ONLY, this.mappedStart, this.mappedRange - this.mappedStart);
                    }
                    catch (IOException ioe) {
                        Logger.getAnonymousLogger().info("Failed to memory map output file for reading.  Trying to read it normally.");
                        Exceptions.printStackTrace((Throwable)ioe);
                        cont = ByteBuffer.allocate((int)(this.mappedRange - this.mappedStart));
                        ch.position(this.mappedStart).read(cont);
                        this.contents = cont;
                    }
                }
                catch (IOException ioe) {
                    Logger.getAnonymousLogger().info("Failed to read output file. Start:" + start + " bytes reqd=" + byteCount + " mapped range=" + this.mappedRange + " previous mapped range=" + prevMappedRange + " channel size: " + ch.size());
                    throw ioe;
                }
            }
            if ((long)start - this.mappedStart > (long)(cont.limit() - byteCount)) {
                cont.position(Math.max(0, cont.limit() - byteCount));
            } else {
                cont.position((int)((long)start - this.mappedStart));
            }
        }
        int limit = Math.min(cont.limit(), byteCount);
        try {
            return (ByteBuffer)cont.slice().limit(limit);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error setting limit to " + limit + " contents size = " + cont.limit() + " requested: read " + "buffer from " + start + " to be " + byteCount + " bytes");
        }
    }

    public synchronized int size() {
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        if (this.buffer != null) {
            if (Controller.LOG) {
                Controller.log("FILEMAP STORAGE flush(): " + this.outstandingBufferCount);
            }
            this.write(this.buffer, false);
            this.writeChannel.force(false);
            this.buffer = null;
        }
    }

    public void close() throws IOException {
        if (this.writeChannel != null) {
            this.flush();
            this.writeChannel.close();
            this.writeChannel = null;
            if (Controller.LOG) {
                Controller.log("FILEMAP STORAGE CLOSE.  Outstanding buffer count: " + this.outstandingBufferCount);
            }
        }
    }

    public boolean isClosed() {
        return this.writeChannel == null || !this.writeChannel.isOpen();
    }
}

