/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.OutputWindow;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;

final class OutputTab
extends AbstractOutputTab {
    private NbIO io;
    private long timestamp = 0L;
    private int firstNavigableListenerLine = -1;
    private boolean hasOutputListeners = false;
    private ActionListener findActionListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$core$output2$FindDialogPanel;

    OutputTab(NbIO io) {
        this.io = io;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + io);
        }
        OutputDocument doc = new OutputDocument(((NbWriter)io.getOut()).out());
        this.setDocument(doc);
    }

    public void addNotify() {
        super.addNotify();
        if (this.io != null) {
            this.io.setClosed(false);
        }
    }

    public void removeNotify() {
        if (this.io != null) {
            this.io.setClosed(true);
        }
        super.removeNotify();
    }

    public void setDocument(Document doc) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        OutputDocument old = this.getDocument();
        this.hasOutputListeners = false;
        this.firstNavigableListenerLine = -1;
        super.setDocument(doc);
        if (old != null && old instanceof OutputDocument) {
            old.dispose();
        }
    }

    public void setIO(NbIO io) {
        if (Controller.LOG) {
            Controller.log("Replacing io on " + this + " with " + io + " out is " + (io != null ? io.getOut() : null));
        }
        if (io != null) {
            this.setDocument(new OutputDocument(((NbWriter)io.getOut()).out()));
            io.setClosed(false);
        } else {
            if (this.io != null) {
                this.io.setClosed(true);
            }
            this.io = null;
            this.setDocument(null);
        }
    }

    public OutputDocument getDocument() {
        Document d = this.getOutputPane().getDocument();
        if (d instanceof OutputDocument) {
            return (OutputDocument)d;
        }
        return null;
    }

    protected AbstractOutputPane createOutputPane() {
        return new OutputPane();
    }

    protected void inputSent(String txt) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + txt);
        }
        this.getOutputPane().lockScroll();
        this.findOutputWindow().inputSent(this, txt);
    }

    protected void inputEof() {
        if (Controller.LOG) {
            Controller.log("Input EOF on OutputTab: ");
        }
        this.findOutputWindow().inputEof(this);
    }

    public void hasSelectionChanged(boolean val) {
        OutputWindow win = this.findOutputWindow();
        if (win != null) {
            win.hasSelectionChanged(this, val);
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    private OutputWindow findOutputWindow() {
        if (this.getParent() != null) {
            return (OutputWindow)((Object)SwingUtilities.getAncestorOfClass(OutputWindow.class, this));
        }
        return (OutputWindow)this.getClientProperty("outputWindow");
    }

    void requestActive() {
        this.findOutputWindow().requestActive();
    }

    public void lineClicked(int line) {
        this.findOutputWindow().lineClicked(this, line);
    }

    boolean linePressed(int line, Point p) {
        OutWriter out = this.getIO().out();
        if (out != null) {
            return out.getLines().getListenerForLine(line) != null;
        }
        return false;
    }

    public void postPopupMenu(Point p, Component src) {
        this.findOutputWindow().postPopupMenu(this, p, src);
    }

    public void caretEnteredLine(int line) {
        this.findOutputWindow().caretEnteredLine(this, line);
    }

    public int getFirstNavigableListenerLine() {
        if (this.firstNavigableListenerLine != -1) {
            return this.firstNavigableListenerLine;
        }
        int result = -1;
        OutWriter out = this.io.out();
        if (out != null) {
            if (Controller.LOG) {
                Controller.log("Looking for first appropriate listener line to send the caret to");
            }
            result = out.getLines().firstImportantListenerLine();
        }
        return result;
    }

    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged() {
        OutputWindow win = this.findOutputWindow();
        if (win != null) {
            boolean hadOutputListeners = this.hasOutputListeners;
            if (this.getFirstNavigableListenerLine() == -1) {
                return;
            }
            boolean bl = this.hasOutputListeners = this.getIO().out() != null && this.getIO().out().getLines().firstListenerLine() >= 0;
            if (this.hasOutputListeners != hadOutputListeners) {
                win.hasOutputListenersChanged(this, this.hasOutputListeners);
            }
            win.documentChanged(this);
        }
    }

    public boolean shouldRelock(int dot) {
        OutWriter w;
        if (this.io != null && (w = this.io.out()) != null && !w.isClosed()) {
            int dist = Math.abs(w.getLines().getCharCount() - dot);
            return dist < 100;
        }
        return false;
    }

    ActionListener getFindActionListener(Action next, Action prev, Action copy) {
        if (this.findActionListener == null) {
            this.findActionListener = new FindActionListener(this, next, prev, copy);
        }
        return this.findActionListener;
    }

    static {
        $assertionsDisabled = !OutputTab.class.desiredAssertionStatus();
    }

    static class FindActionListener
    implements ActionListener {
        OutputTab tab;
        Action findNextAction;
        Action findPreviousAction;
        Action copyAction;

        FindActionListener(OutputTab tab, Action findNextAction, Action findPreviousAction, Action copyAction) {
            this.tab = tab;
            this.findNextAction = findNextAction;
            this.findPreviousAction = findPreviousAction;
            this.copyAction = copyAction;
        }

        public void actionPerformed(ActionEvent e) {
            Matcher matcher;
            String s;
            FindDialogPanel panel = (FindDialogPanel)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$output2$FindDialogPanel == null ? (class$org$netbeans$core$output2$FindDialogPanel = OutputTab.class$("org.netbeans.core.output2.FindDialogPanel")) : class$org$netbeans$core$output2$FindDialogPanel, (JComponent)e.getSource());
            if (panel == null) {
                panel = (FindDialogPanel)((JComponent)e.getSource()).getClientProperty("panel");
            }
            if ((s = panel.getPattern()) == null || s.length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            OutWriter out = this.tab.getIO().out();
            if (out != null && !out.isDisposed() && (matcher = out.getLines().find(s)) != null && matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                this.tab.getOutputPane().setSelection(start, end);
                this.findNextAction.setEnabled(true);
                this.findPreviousAction.setEnabled(true);
                this.copyAction.setEnabled(true);
                panel.getTopLevelAncestor().setVisible(false);
                this.tab.requestFocus();
            }
        }
    }
}

