/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.core.output2.OutputDocument;
import org.openide.util.Exceptions;

public class WrappedTextView
extends View {
    private JTextComponent comp;
    private int charsPerLine = -1;
    private int fontDescent = -1;
    private static final Segment SEGMENT = new Segment();
    private int width = -1;
    private boolean changed = true;
    private int charWidth = -1;
    private int charHeight = -1;
    static final int[] ln = new int[3];
    private boolean aa = false;
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    static Color selectedFg;
    static Color unselectedFg;
    static Color selectedLinkFg;
    static Color unselectedLinkFg;
    static Color selectedImportantLinkFg;
    static Color unselectedImportantLinkFg;
    static Color selectedErr;
    static Color unselectedErr;
    static final Color arrowColor;
    private static Map hintsMap;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    public WrappedTextView(Element elem, JTextComponent comp) {
        super(elem);
        this.comp = comp;
    }

    public float getPreferredSpan(int axis) {
        OutputDocument doc = this.odoc();
        float result = 0.0f;
        if (doc != null) {
            switch (axis) {
                case 0: {
                    result = this.getCharsPerLine();
                    break;
                }
                case 1: {
                    this.updateInfo(null);
                    result = doc.getLines().getLogicalLineCountIfWrappedAt(this.getCharsPerLine()) * this.charHeight() + this.fontDescent();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(axis));
                }
            }
        }
        return result;
    }

    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    private int charWidth() {
        if (this.charWidth == -1) {
            return 12;
        }
        return this.charWidth;
    }

    private int charHeight() {
        if (this.charHeight == -1) {
            return 7;
        }
        return this.charHeight;
    }

    private OutputDocument odoc() {
        Document doc = this.comp.getDocument();
        if (doc instanceof OutputDocument) {
            return (OutputDocument)doc;
        }
        return null;
    }

    public void setChanged() {
        this.changed = true;
        this.updateInfo(null);
        this.preferenceChanged(this, true, true);
    }

    private int getCharsPerLine() {
        if (this.charsPerLine == -1) {
            return 80;
        }
        return this.getWidth() / this.charWidth();
    }

    private int getWidth() {
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.comp.getParent();
            this.width = jv.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        return this.width;
    }

    private int fontDescent() {
        if (this.fontDescent == -1) {
            return 4;
        }
        return this.fontDescent;
    }

    public void updateInfo(Graphics g) {
        if (this.charWidth == -1 || this.changed) {
            if (g != null) {
                this.aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
                FontMetrics fm = g.getFontMetrics(this.comp.getFont());
                this.charWidth = fm.charWidth('m');
                this.charHeight = fm.getHeight();
                this.fontDescent = fm.getMaxDescent();
                this.charsPerLine = this.width / this.charWidth;
            }
            if (this.comp.getParent() instanceof JViewport) {
                JViewport jv = (JViewport)this.comp.getParent();
                this.width = jv.getExtentSize().width - (this.aa ? 18 : 17);
            } else {
                this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
            }
        }
    }

    private static int margin() {
        return 9;
    }

    public void paint(Graphics g, Shape allocation) {
        ((Graphics2D)g).addRenderingHints(WrappedTextView.getHints());
        this.updateInfo(g);
        this.comp.getHighlighter().paint(g);
        Rectangle vis = this.comp.getVisibleRect();
        OutputDocument d = this.odoc();
        if (d != null) {
            int physicalLine;
            Rectangle clip = g.getClipBounds();
            clip.y = Math.max(0, clip.y - this.charHeight());
            clip.height += this.charHeight() * 2;
            int lineCount = d.getElementCount();
            if (lineCount == 0) {
                return;
            }
            int charsPerLine = this.getCharsPerLine();
            WrappedTextView.ln[0] = physicalLine = clip.y / this.charHeight;
            d.getLines().toLogicalLineIndex(ln, charsPerLine);
            int firstline = ln[0];
            int count = lineCount - firstline;
            g.setColor(this.comp.getForeground());
            Segment seg = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int selStart = this.comp.getSelectionStart();
            int selEnd = this.comp.getSelectionEnd();
            int y = clip.y - clip.y % this.charHeight() + this.charHeight();
            try {
                for (int i = 0; i < count; ++i) {
                    int charpos;
                    int lenToDraw;
                    int lineStart = d.getLineStart(i + firstline);
                    int lineEnd = d.getLineEnd(i + firstline);
                    int length = lineEnd - lineStart;
                    g.setColor(WrappedTextView.getColorForLocation(lineStart, d, true));
                    d.getText(lineStart, length, seg);
                    int logicalLines = seg.count <= charsPerLine ? 1 : 1 + length / charsPerLine;
                    int currLogicalLine = 0;
                    if (i == 0 && logicalLines > 0) {
                        while (ln[1] > currLogicalLine) {
                            this.drawArrow(g, y - (logicalLines - ++currLogicalLine) * this.charHeight(), currLogicalLine == ln[1]);
                        }
                    }
                    while (currLogicalLine < logicalLines && (lenToDraw = Math.min(charsPerLine, length - (charpos = currLogicalLine * charsPerLine))) > 0) {
                        this.drawLogicalLine(seg, currLogicalLine, logicalLines, g, y, lineStart, charpos, selStart, lenToDraw, selEnd);
                        if (g.getColor() == unselectedLinkFg || g.getColor() == unselectedImportantLinkFg) {
                            this.underline(g, seg, charpos, lenToDraw, currLogicalLine, y);
                        }
                        y += this.charHeight();
                        ++currLogicalLine;
                    }
                    if (y <= clip.y + clip.height && i + firstline != lineCount - 1) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void drawLogicalLine(Segment seg, int currLogicalLine, int logicalLines, Graphics g, int y, int lineStart, int charpos, int selStart, int lenToDraw, int selEnd) {
        int realPos;
        if (currLogicalLine != logicalLines - 1) {
            this.drawArrow(g, y, currLogicalLine == logicalLines - 2);
        }
        if ((realPos = lineStart + charpos) >= selStart && realPos + lenToDraw <= selEnd) {
            Color c = g.getColor();
            g.setColor(this.comp.getSelectionColor());
            g.fillRect(WrappedTextView.margin(), y + this.fontDescent() - this.charHeight(), lenToDraw * this.charWidth(), this.charHeight());
            g.setColor(c);
        } else if (realPos <= selStart && realPos + lenToDraw >= selStart) {
            int selx = WrappedTextView.margin() + this.charWidth() * (selStart - realPos);
            int selLen = selEnd > realPos + lenToDraw ? (lenToDraw + realPos - selStart) * this.charWidth() : (selEnd - selStart) * this.charWidth();
            Color c = g.getColor();
            g.setColor(this.comp.getSelectionColor());
            g.fillRect(selx, y + this.fontDescent() - this.charHeight(), selLen, this.charHeight());
            g.setColor(c);
        } else if (realPos > selStart && realPos + lenToDraw >= selEnd) {
            int selLen = (selEnd - realPos) * this.charWidth();
            Color c = g.getColor();
            g.setColor(this.comp.getSelectionColor());
            g.fillRect(WrappedTextView.margin(), y + this.fontDescent() - this.charHeight(), selLen, this.charHeight());
            g.setColor(c);
        }
        g.drawChars(seg.array, charpos, lenToDraw, WrappedTextView.margin(), y);
    }

    private void underline(Graphics g, Segment seg, int charpos, int lenToDraw, int currLogicalLine, int y) {
        int underlineStart = WrappedTextView.margin();
        int underlineEnd = underlineStart + g.getFontMetrics().charsWidth(seg.array, charpos, lenToDraw);
        if (currLogicalLine == 0) {
            for (int k = 1; k < lenToDraw && Character.isWhitespace(seg.array[charpos + k]); ++k) {
                underlineStart += this.charWidth();
                underlineEnd -= this.charWidth();
            }
        } else {
            underlineStart = WrappedTextView.margin();
        }
        g.drawLine(underlineStart, y + 1, underlineEnd, y + 1);
    }

    private void drawArrow(Graphics g, int y, boolean drawHead) {
        int rpos;
        int fontHeight = this.charHeight();
        Color c = g.getColor();
        g.setColor(WrappedTextView.arrowColor());
        int w = this.getWidth() + 15;
        y += 2;
        int n = rpos = this.aa ? 8 : 4;
        if (this.aa) {
            g.drawArc(w - rpos, y - fontHeight / 2, rpos + 1, fontHeight, 265, 185);
        } else {
            g.drawLine(w - rpos, y - fontHeight / 2, w, y - fontHeight / 2);
            g.drawLine(w, y - fontHeight / 2 + 1, w, y + fontHeight / 2 - 1);
            g.drawLine(w - rpos, y + fontHeight / 2, w, y + fontHeight / 2);
        }
        if (this.aa) {
            ++w;
        }
        if (drawHead) {
            rpos = this.aa ? 7 : 8;
            int[] xpoints = new int[]{w - rpos, w - rpos + 5, w - rpos + 5};
            int[] ypoints = new int[]{y + fontHeight / 2, y + fontHeight / 2 - 5, y + fontHeight / 2 + 5};
            g.fillPolygon(xpoints, ypoints, 3);
        }
        g.setColor(WrappedTextView.arrowColor());
        g.drawLine(1, y - fontHeight / 2, 5, y - fontHeight / 2);
        g.drawLine(1, y - fontHeight / 2, 1, y + fontHeight / 2);
        g.drawLine(1, y + fontHeight / 2, 5, y + fontHeight / 2);
        g.setColor(c);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle result = new Rectangle();
        result.setBounds(0, 0, this.charWidth(), this.charHeight());
        OutputDocument od = this.odoc();
        if (od != null) {
            int line = od.getElementIndex(pos);
            int start = od.getLineStart(line);
            int column = pos - start;
            int charsPerLine = this.getCharsPerLine();
            int row = od.getLines().getLogicalLineCountAbove(line, charsPerLine);
            if (column > charsPerLine) {
                row += column / charsPerLine;
                column %= charsPerLine;
            }
            result.y = row * this.charHeight() + this.fontDescent();
            result.x = WrappedTextView.margin() + column * this.charWidth();
        }
        return result;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        OutputDocument od = this.odoc();
        if (od != null) {
            int physicalLine;
            int ix = (int)x - WrappedTextView.margin();
            int iy = (int)y - this.fontDescent();
            int charsPerLine = this.getCharsPerLine();
            WrappedTextView.ln[0] = physicalLine = iy / this.charHeight;
            od.getLines().toLogicalLineIndex(ln, charsPerLine);
            int logicalLine = ln[0];
            int wraps = ln[2] - 1;
            int totalLines = od.getElementCount();
            if (totalLines == 0) {
                return 0;
            }
            if (logicalLine >= totalLines) {
                return od.getLength() - 1;
            }
            int lineStart = od.getLineStart(logicalLine);
            int lineLength = od.getLines().length(logicalLine);
            int column = ix / this.charWidth();
            if (column > lineLength - 1) {
                column = lineLength - 1;
            }
            return wraps > 0 ? Math.min(od.getLineEnd(logicalLine) - 1, lineStart + ln[1] * charsPerLine + column) : lineStart + column;
        }
        return 0;
    }

    private static Color getColorForLocation(int start, Document d, boolean selected) {
        OutputDocument od = (OutputDocument)d;
        int line = od.getElementIndex(start);
        boolean hyperlink = od.getLines().isHyperlink(line);
        boolean important = hyperlink ? od.getLines().isImportantHyperlink(line) : false;
        boolean isErr = od.getLines().isErr(line);
        return hyperlink ? (important ? (selected ? selectedImportantLinkFg : unselectedImportantLinkFg) : (selected ? selectedLinkFg : unselectedLinkFg)) : (selected ? (isErr ? selectedErr : selectedFg) : (isErr ? unselectedErr : unselectedFg));
    }

    static {
        arrowColor = new Color(80, 162, 80);
        hintsMap = null;
        selectedFg = UIManager.getColor("nb.output.foreground.selected");
        if (selectedFg == null) {
            Color color = selectedFg = UIManager.getColor("textText") == null ? Color.BLACK : UIManager.getColor("textText");
        }
        if ((unselectedFg = UIManager.getColor("nb.output.foreground")) == null) {
            unselectedFg = selectedFg;
        }
        if ((selectedLinkFg = UIManager.getColor("nb.output.link.foreground.selected")) == null) {
            selectedLinkFg = Color.BLUE.darker();
        }
        if ((unselectedLinkFg = UIManager.getColor("nb.output.link.foreground")) == null) {
            unselectedLinkFg = selectedLinkFg;
        }
        if ((selectedImportantLinkFg = UIManager.getColor("nb.output.link.foreground.important.selected")) == null) {
            selectedImportantLinkFg = selectedLinkFg.brighter();
        }
        if ((unselectedImportantLinkFg = UIManager.getColor("nb.output.link.foreground.important")) == null) {
            unselectedImportantLinkFg = selectedImportantLinkFg;
        }
        if ((selectedErr = UIManager.getColor("nb.output.err.foreground.selected")) == null) {
            selectedErr = new Color(164, 0, 0);
        }
        if ((unselectedErr = UIManager.getColor("nb.output.err.foreground")) == null) {
            unselectedErr = selectedErr;
        }
    }
}

