/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractOutputWindow
extends TopComponent
implements ChangeListener,
PropertyChangeListener {
    protected JTabbedPane pane = TabbedPaneFactory.createCloseButtonTabbedPane();
    private static final String ICON_PROP = "tabIcon";
    private JToolBar toolbar = null;
    private Runnable pendingFocusRunnable = null;
    private AbstractOutputTab lastKnownSelection = null;
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID()) || UIManager.getLookAndFeel().getClass().getSuperclass().getName().indexOf("Synth") != -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractOutputWindow() {
        this.pane.addChangeListener(this);
        this.pane.addPropertyChangeListener("close", this);
        this.setFocusable(true);
        this.setBackground(UIManager.getColor("text"));
        this.toolbar = new JToolBar();
        this.toolbar.setOrientation(1);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
        this.toolbar.setFloatable(false);
        Insets ins = this.toolbar.getMargin();
        JButton sample = new JButton();
        sample.setBorderPainted(false);
        sample.setOpaque(false);
        sample.setText(null);
        sample.setIcon(new Icon(){

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return 16;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        });
        this.toolbar.add(sample);
        Dimension buttonPref = sample.getPreferredSize();
        Dimension minDim = new Dimension(buttonPref.width + ins.left + ins.right, buttonPref.height + ins.top + ins.bottom);
        this.toolbar.setMinimumSize(minDim);
        this.toolbar.setPreferredSize(minDim);
        this.toolbar.remove(sample);
        this.setLayout(new BorderLayout());
        this.add(this.toolbar, "West");
        this.toolbar.setBorder(new VariableRightBorder(this.pane));
        this.toolbar.setBorderPainted(true);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if ("close".equals(pce.getPropertyName())) {
            AbstractOutputTab tab = (AbstractOutputTab)pce.getNewValue();
            this.closeRequest(tab);
        }
    }

    protected abstract void closeRequest(AbstractOutputTab var1);

    protected abstract void removed(AbstractOutputTab var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component c, Object constraints, int idx) {
        this.setFocusable(false);
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean hadFocus = this.hasFocus() || this.isAncestorOf(focusOwner);
        Object object = this.getTreeLock();
        synchronized (object) {
            if (c instanceof AbstractOutputTab) {
                AbstractOutputTab aop = this.getInternalTab();
                if (aop != null) {
                    if (aop == c) {
                        return;
                    }
                    super.remove((Component)aop);
                    if (!$assertionsDisabled && this.pane.getParent() == this) {
                        throw new AssertionError();
                    }
                    this.pane.add(aop);
                    this.setTabIcon(aop, (Icon)aop.getClientProperty(ICON_PROP));
                    this.pane.add(c);
                    this.setTabIcon((AbstractOutputTab)c, (Icon)((AbstractOutputTab)c).getClientProperty(ICON_PROP));
                    super.addImpl((Component)this.pane, constraints, idx);
                    this.updateSingletonName(null);
                    this.revalidate();
                } else if (this.pane.getParent() == this) {
                    this.pane.add(c);
                    this.setTabIcon((AbstractOutputTab)c, (Icon)((AbstractOutputTab)c).getClientProperty(ICON_PROP));
                    this.revalidate();
                } else {
                    super.addImpl(c, constraints, idx);
                    this.setTabIcon((AbstractOutputTab)c, (Icon)((AbstractOutputTab)c).getClientProperty(ICON_PROP));
                    this.setToolbarButtons(((AbstractOutputTab)c).getToolbarButtons());
                    this.revalidate();
                }
                if (hadFocus) {
                    this.requestFocus();
                }
                return;
            }
            super.addImpl(c, constraints, idx);
        }
        if (this.getComponentCount() == 2 && this.getComponent(1) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(1).getName());
        }
        this.revalidate();
    }

    public final AbstractOutputTab[] getTabs() {
        ArrayList<Component> al = new ArrayList<Component>(this.pane.getParent() == this ? this.pane.getTabCount() : this.getComponentCount());
        if (this.pane.getParent() == this) {
            int tabs = this.pane.getTabCount();
            for (int i = 0; i < tabs; ++i) {
                Component c = this.pane.getComponentAt(i);
                if (!(c instanceof AbstractOutputTab)) continue;
                al.add(c);
            }
        } else {
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof AbstractOutputTab)) continue;
                al.add(c[i]);
            }
        }
        AbstractOutputTab[] result = new AbstractOutputTab[al.size()];
        return al.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component c) {
        AbstractOutputTab removedSelectedView = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (c.getParent() == this.pane && c instanceof AbstractOutputTab) {
                if (c == this.pane.getSelectedComponent()) {
                    if (Controller.LOG) {
                        Controller.log("Selected view is being removed: " + c.getName());
                    }
                    removedSelectedView = (AbstractOutputTab)c;
                }
                this.checkWinXPLFBug();
                this.pane.remove(c);
                if (this.pane.getTabCount() == 1) {
                    Component comp = this.pane.getComponentAt(0);
                    this.pane.remove(comp);
                    super.remove((Component)this.pane);
                    this.add(comp);
                    this.updateSingletonName(c.getName());
                    this.setToolbarButtons(((AbstractOutputTab)comp).getToolbarButtons());
                    this.revalidate();
                }
            } else {
                if (c == this.getSelectedTab()) {
                    removedSelectedView = (AbstractOutputTab)c;
                }
                super.remove(c);
                this.setToolbarButtons(new JButton[0]);
                this.updateSingletonName(null);
            }
            if (removedSelectedView != null) {
                this.fire(removedSelectedView);
            }
        }
        if (c instanceof AbstractOutputTab && c.getParent() == null) {
            this.removed((AbstractOutputTab)c);
        }
        if (this.getComponentCount() == 2 && this.getComponent(1) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(1).getName());
        }
        this.revalidate();
        this.setFocusable(this.getComponentCount() == 1);
    }

    private AbstractOutputTab getInternalTab() {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof AbstractOutputTab)) continue;
            return (AbstractOutputTab)c[i];
        }
        return null;
    }

    public final AbstractOutputTab getSelectedTab() {
        if (this.pane.getParent() == this) {
            return (AbstractOutputTab)this.pane.getSelectedComponent();
        }
        return this.getInternalTab();
    }

    public void setSelectedTab(AbstractOutputTab op) {
        if (!$assertionsDisabled && op.getParent() != this && op.getParent() != this.pane) {
            throw new AssertionError();
        }
        if (Controller.LOG) {
            Controller.log("SetSelectedTab: " + op + " parent is " + op.getParent());
        }
        if (this.pane.getParent() == this && op != this.pane.getSelectedComponent()) {
            this.pane.setSelectedComponent(op);
        }
        this.getActionMap().setParent(op.getActionMap());
    }

    public void setTabTitle(AbstractOutputTab tab, String name) {
        if (tab.getParent() == this.pane) {
            this.pane.setTitleAt(this.pane.indexOfComponent(tab), name);
        } else if (tab.getParent() == this) {
            this.updateSingletonName(name);
        }
        tab.setName(name);
    }

    public void setTabIcon(AbstractOutputTab tab, Icon icon) {
        if (icon != null) {
            tab.putClientProperty(ICON_PROP, icon);
            if (this.pane.indexOfComponent(tab) != -1) {
                this.pane.setIconAt(this.pane.indexOfComponent(tab), icon);
                this.pane.setDisabledIconAt(this.pane.indexOfComponent(tab), icon);
            }
        }
    }

    public void requestFocus() {
        if (!this.isShowing()) {
            return;
        }
        AbstractOutputTab tab = this.getSelectedTab();
        if (tab != null && this.pendingFocusRunnable == null) {
            this.pendingFocusRunnable = new Runnable(){

                public void run() {
                    AbstractOutputTab tab = AbstractOutputWindow.this.getSelectedTab();
                    if (tab != null) {
                        tab.requestFocus();
                    }
                    AbstractOutputWindow.this.pendingFocusRunnable = null;
                }
            };
            SwingUtilities.invokeLater(this.pendingFocusRunnable);
        } else {
            super.requestFocus();
        }
    }

    protected abstract void updateSingletonName(String var1);

    protected void fire(AbstractOutputTab formerSelection) {
        AbstractOutputTab selection = this.getSelectedTab();
        if (formerSelection != selection) {
            this.selectionChanged(formerSelection, selection);
            this.lastKnownSelection = selection;
            if (selection != null) {
                this.setToolbarButtons(selection.getToolbarButtons());
            } else {
                this.setToolbarButtons(new JButton[0]);
            }
        }
    }

    private void setToolbarButtons(JButton[] buttons) {
        this.toolbar.removeAll();
        for (int i = 0; i < buttons.length; ++i) {
            this.toolbar.add(buttons[i]);
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.pane.getSelectedComponent() instanceof AbstractOutputPane) {
            ((AbstractOutputPane)this.pane.getSelectedComponent()).ensureCaretPosition();
        }
        this.fire(this.lastKnownSelection);
    }

    protected abstract void selectionChanged(AbstractOutputTab var1, AbstractOutputTab var2);

    public void paint(Graphics g) {
        if (this.isGtk) {
            Color c = this.getBackground();
            if (c == null) {
                c = Color.WHITE;
            }
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public final void selectNextTab(AbstractOutputTab tab) {
        AbstractOutputTab[] tabs = this.getTabs();
        if (tabs.length > 1) {
            int nextTabIndex = this.getSelectedTabIndex(tabs, tab) + 1;
            if (nextTabIndex > tabs.length - 1) {
                nextTabIndex = 0;
            }
            this.setSelectedTab(tabs[nextTabIndex]);
        }
    }

    public final void selectPreviousTab(AbstractOutputTab tab) {
        AbstractOutputTab[] tabs = this.getTabs();
        if (tabs.length > 1) {
            int prevTabIndex = this.getSelectedTabIndex(tabs, tab) - 1;
            if (prevTabIndex < 0) {
                prevTabIndex = tabs.length - 1;
            }
            this.setSelectedTab(tabs[prevTabIndex]);
        }
    }

    private int getSelectedTabIndex(AbstractOutputTab[] tabs, AbstractOutputTab tab) {
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] != tab) continue;
            return i;
        }
        return -1;
    }

    private void checkWinXPLFBug() {
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            TabbedPaneUI ui = this.pane.getUI();
            try {
                Method method = ui.getClass().getDeclaredMethod("setRolloverTab", Integer.TYPE);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)ui, new Integer(-1));
                    method.setAccessible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !AbstractOutputWindow.class.desiredAssertionStatus();
    }

    private class VariableRightBorder
    implements Border {
        private JTabbedPane pane;

        public VariableRightBorder(JTabbedPane pane) {
            this.pane = pane;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.pane.getParent() != AbstractOutputWindow.this) {
                Color old = g.getColor();
                g.setColor(this.getColor());
                g.drawLine(x + width - 1, y, x + width - 1, y + height);
                g.setColor(old);
            }
        }

        public Color getColor() {
            if (Utilities.isMac()) {
                Color c1 = UIManager.getColor("controlShadow");
                Color c2 = UIManager.getColor("control");
                return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
            }
            return UIManager.getColor("controlShadow");
        }

        public Insets getBorderInsets(Component c) {
            if (this.pane.getParent() == AbstractOutputWindow.this) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(0, 0, 0, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

