/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class DefaultSettings
implements Settings,
ModelListener,
CategoryListener {
    private static final String NODE_ATTR_PREFIX = "psa_";
    private static final String NULL_VALUE = "null";
    private static final String XML_ROOT = "root";
    private static final String XML_CATEGORY = "category";
    private static final String XML_ITEM = "item";
    private static final String XML_ATTR_NAME = "name";
    private static final String[] KNOWN_PROPERTIES = new String[]{"psa_iconSize", "psa_isExpanded", "psa_isVisible", "psa_showItemNames"};
    private static final int ICON_SIZE_ATTR_INDEX = 0;
    private static final int IS_EXPANDED_ATTR_INDEX = 1;
    private static final int IS_VISIBLE_ATTR_INDEX = 2;
    private static final int SHOW_ITEM_NAMES_ATTR_INDEX = 3;
    private Model model;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String prefsName;
    private static Logger ERR = Logger.getLogger("org.netbeans.modules.palette");
    private boolean isLoading = false;

    public DefaultSettings(Model model) {
        this.model = model;
        this.prefsName = this.constructPrefsFileName(model);
        if (Utilities.isWindows()) {
            this.prefsName = this.prefsName.toLowerCase();
        }
        model.addModelListener(this);
        Category[] categories = model.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            categories[i].addCategoryListener(this);
        }
        this.load();
    }

    private String constructPrefsFileName(Model model) {
        FileObject fo;
        DataFolder dof = (DataFolder)model.getRoot().lookup(DataFolder.class);
        if (null != dof && null != (fo = dof.getPrimaryFile())) {
            return fo.getPath();
        }
        return model.getName();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(DefaultSettings.class).node("CommonPaletteSettings").node(this.prefsName);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public boolean isVisible(Item item) {
        Node node = this.getNode(item.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Item item, boolean visible) {
        Node node = this.getNode(item.getLookup());
        this.set(node, "isVisible", visible, true);
    }

    public boolean isVisible(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Category category, boolean visible) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isVisible", visible, true);
    }

    public boolean isNodeVisible(Node node) {
        return this.get(node, "isVisible", true);
    }

    public void setNodeVisible(Node node, boolean visible) {
        this.set(node, "isVisible", visible, true);
    }

    public boolean isExpanded(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isExpanded", false);
    }

    public void setExpanded(Category category, boolean expanded) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isExpanded", expanded, false);
    }

    public int getIconSize() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "iconSize", 1);
    }

    public void setIconSize(int iconSize) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "iconSize", iconSize, 1);
    }

    public void setShowItemNames(boolean showNames) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "showItemNames", showNames, true);
    }

    public boolean getShowItemNames() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "showItemNames", true);
    }

    private Node getNode(Lookup lkp) {
        return (Node)lkp.lookup(Node.class);
    }

    private boolean get(Node node, String attrName, boolean defaultValue) {
        Object value = this.get(node, attrName, (Object)defaultValue);
        return null == value ? defaultValue : Boolean.valueOf(value.toString());
    }

    private int get(Node node, String attrName, int defaultValue) {
        Object value = this.get(node, attrName, (Object)defaultValue);
        try {
            if (null != value) {
                return Integer.parseInt(value.toString());
            }
        }
        catch (NumberFormatException nfE) {
            // empty catch block
        }
        return defaultValue;
    }

    private Object get(Node node, String attrName, Object defaultValue) {
        Object res = null;
        if (null != node && (null == (res = node.getValue(NODE_ATTR_PREFIX + attrName)) || NULL_VALUE.equals(res))) {
            res = this.getNodeDefaultValue(node, attrName);
        }
        if (null == res) {
            res = defaultValue;
        }
        return res;
    }

    private Object getNodeDefaultValue(Node node, String attrName) {
        DataObject dobj;
        Object res = node.getValue(attrName);
        if (null == res && null != (dobj = (DataObject)node.getCookie(DataObject.class))) {
            res = dobj.getPrimaryFile().getAttribute(attrName);
        }
        return res;
    }

    private void set(Node node, String attrName, boolean newValue, boolean defaultValue) {
        this.set(node, attrName, (Object)newValue, (Object)defaultValue);
    }

    private void set(Node node, String attrName, int newValue, int defaultValue) {
        this.set(node, attrName, (Object)newValue, (Object)defaultValue);
    }

    private void set(Node node, String attrName, Object newValue, Object defaultValue) {
        if (null == node) {
            return;
        }
        Object oldValue = this.get(node, attrName, defaultValue);
        if (oldValue.equals(newValue)) {
            return;
        }
        node.setValue(NODE_ATTR_PREFIX + attrName, newValue);
        this.store();
        this.propertySupport.firePropertyChange(attrName, oldValue, newValue);
    }

    public void categoryModified(Category src) {
        this.store();
    }

    public void categoriesRemoved(Category[] removedCategories) {
        for (int i = 0; i < removedCategories.length; ++i) {
            removedCategories[i].removeCategoryListener(this);
        }
        this.store();
    }

    public void categoriesAdded(Category[] addedCategories) {
        for (int i = 0; i < addedCategories.length; ++i) {
            addedCategories[i].addCategoryListener(this);
        }
        this.store();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void categoriesReordered() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        try {
            this.isLoading = true;
            Preferences pref = this.getPreferences();
            this.setIconSize(pref.getInt("iconSize", this.getIconSize()));
            this.setShowItemNames(pref.getBoolean("showItemNames", this.getShowItemNames()));
            for (Category category : this.model.getCategories()) {
                this.setVisible(category, pref.getBoolean(category.getName() + '-' + "isVisible", this.isVisible(category)));
                this.setExpanded(category, pref.getBoolean(category.getName() + '-' + "isExpanded", this.isExpanded(category)));
                for (Item item : category.getItems()) {
                    this.setVisible(item, pref.getBoolean(category.getName() + '-' + item.getName() + '-' + "isVisible", this.isVisible(item)));
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    private void store() {
        if (this.isLoading) {
            return;
        }
        Preferences pref = this.getPreferences();
        try {
            pref.clear();
        }
        catch (BackingStoreException bsE) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_StoreSettings"), bsE);
        }
        pref.putInt("iconSize", this.getIconSize());
        pref.putBoolean("showItemNames", this.getShowItemNames());
        for (Category category : this.model.getCategories()) {
            pref.putBoolean(category.getName() + '-' + "isVisible", this.isVisible(category));
            pref.putBoolean(category.getName() + '-' + "isExpanded", this.isExpanded(category));
            for (Item item : category.getItems()) {
                pref.putBoolean(category.getName() + '-' + item.getName() + '-' + "isVisible", this.isVisible(item));
            }
        }
    }

    public int getItemWidth() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "itemWidth", -1);
    }

    public void reset() {
        Node root = (Node)this.model.getRoot().lookup(Node.class);
        this.clearAttributes(root);
        Category[] categories = this.model.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            Node cat = (Node)categories[i].getLookup().lookup(Node.class);
            this.clearAttributes(cat);
            Item[] items = categories[i].getItems();
            for (int j = 0; j < items.length; ++j) {
                Node it = (Node)items[j].getLookup().lookup(Node.class);
                this.clearAttributes(it);
            }
        }
        try {
            this.getPreferences().removeNode();
        }
        catch (BackingStoreException bsE) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_StoreSettings"), bsE);
        }
    }

    private void clearAttributes(Node node) {
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            node.setValue(KNOWN_PROPERTIES[i], (Object)NULL_VALUE);
        }
    }
}

