/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.util.LinkedList;
import java.util.List;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PaletteItemHandler
extends DefaultHandler {
    private static final String XML_ROOT = "editor_palette_item";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_BODY = "body";
    private static final String TAG_CLASS = "class";
    private static final String ATTR_CLASSNAME = "name";
    private static final String TAG_CUSTOMIZER = "customizer";
    private static final String ATTR_CUSTNAME = "name";
    private static final String TAG_ICON16 = "icon16";
    private static final String ATTR_URL = "urlvalue";
    private static final String TAG_ICON32 = "icon32";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_INLINE_DESCRIPTION = "inline-description";
    private static final String TAG_DISPLAY_NAME = "display-name";
    private static final String TAG_TOOLTIP = "tooltip";
    private static final String ATTR_BUNDLE = "localizing-bundle";
    private static final String ATTR_DISPLAY_NAME_KEY = "display-name-key";
    private static final String ATTR_TOOLTIP_KEY = "tooltip-key";
    private LinkedList<String> bodyLines;
    private boolean insideBody = false;
    private String body;
    private String className;
    private String icon16URL;
    private String icon32URL;
    private String bundleName;
    private String displayNameKey;
    private String tooltipKey;
    private String displayName;
    private String tooltip;
    private StringBuffer textBuffer;

    public String getBody() {
        return this.body;
    }

    public String getClassName() {
        return this.className;
    }

    public String getIcon16URL() {
        return this.icon16URL;
    }

    public String getIcon32URL() {
        return this.icon32URL;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (XML_ROOT.equals(qName)) {
            String version = attributes.getValue(ATTR_VERSION);
            if (version == null) {
                String message = NbBundle.getBundle(PaletteItemHandler.class).getString("MSG_UnknownEditorPaletteItemVersion");
                throw new SAXException(message);
            }
            if (!"1.0".equals(version) && !"1.1".equals(version)) {
                String message = NbBundle.getBundle(PaletteItemHandler.class).getString("MSG_UnsupportedEditorPaletteItemVersion");
                throw new SAXException(message);
            }
        } else if (TAG_BODY.equals(qName)) {
            this.bodyLines = new LinkedList();
            this.insideBody = true;
        } else if (TAG_CLASS.equals(qName)) {
            this.className = attributes.getValue("name");
        } else if (TAG_ICON16.equals(qName)) {
            this.icon16URL = attributes.getValue(ATTR_URL);
        } else if (TAG_ICON32.equals(qName)) {
            this.icon32URL = attributes.getValue(ATTR_URL);
        } else if (TAG_DESCRIPTION.equals(qName)) {
            this.bundleName = attributes.getValue(ATTR_BUNDLE);
            this.displayNameKey = attributes.getValue(ATTR_DISPLAY_NAME_KEY);
            this.tooltipKey = attributes.getValue(ATTR_TOOLTIP_KEY);
        } else if (TAG_INLINE_DESCRIPTION.equals(qName)) {
            this.bundleName = null;
            this.displayNameKey = null;
            this.tooltipKey = null;
        } else if (TAG_DISPLAY_NAME.equals(qName)) {
            this.textBuffer = new StringBuffer();
        } else if (TAG_TOOLTIP.equals(qName)) {
            this.textBuffer = new StringBuffer();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_BODY.equals(qName)) {
            this.insideBody = false;
            this.body = this.trimSurroundingLines(this.bodyLines);
        } else if (TAG_DISPLAY_NAME.equals(qName)) {
            this.displayName = this.textBuffer.toString();
            this.textBuffer = null;
        } else if (TAG_TOOLTIP.equals(qName)) {
            this.tooltip = this.textBuffer.toString();
            this.textBuffer = null;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.insideBody) {
            String chars = new String(buf, offset, len).trim();
            this.bodyLines.add(chars + "\n");
        } else if (null != this.textBuffer) {
            this.textBuffer.append(buf, offset, len);
        }
    }

    private String trimSurroundingLines(List<String> lines) {
        int nlines;
        int firstNonEmpty = nlines = lines.size();
        for (int i = 0; i < firstNonEmpty; ++i) {
            String line = lines.get(i);
            if (line.trim().length() == 0) continue;
            firstNonEmpty = i;
        }
        int lastNonEmpty = -1;
        for (int i = nlines - 1; i > lastNonEmpty; --i) {
            String line = lines.get(i);
            if (line.trim().length() == 0) continue;
            lastNonEmpty = i;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = firstNonEmpty; i <= lastNonEmpty; ++i) {
            sb.append(lines.get(i));
        }
        String body = sb.toString();
        if (body.length() > 0 && body.charAt(body.length() - 1) == '\n') {
            body = body.substring(0, body.length() - 1);
        }
        return body;
    }
}

