/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.DnDSupport;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class PalettePanel
extends JPanel
implements Scrollable {
    private static PalettePanel theInstance;
    private PaletteController controller;
    private Model model;
    private Settings settings;
    private ModelListener modelListener;
    private PropertyChangeListener settingsListener;
    private CategoryDescriptor[] descriptors = new CategoryDescriptor[0];
    private Category selectedCategory;
    private Object lock = new Object();
    private MouseListener mouseListener;
    private JScrollPane scrollPane;
    private DnDSupport dndSupport;

    private PalettePanel() {
        this.setLayout(new PaletteLayoutManager());
        this.addMouseListener(this.mouseListener());
        this.dndSupport = new DnDSupport(this);
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    public static synchronized PalettePanel getDefault() {
        if (null == theInstance) {
            theInstance = new PalettePanel();
        }
        return theInstance;
    }

    public JScrollPane getScrollPane() {
        if (null == this.scrollPane) {
            this.scrollPane = new JScrollPane(this);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.addMouseListener(this.mouseListener());
            this.scrollPane.getViewport().setBackground(UIManager.getColor("Panel.background"));
            this.scrollPane.setViewportBorder(null);
        }
        return this.scrollPane;
    }

    private CategoryDescriptor getCategoryDescriptor(Category category) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            CategoryDescriptor descriptor = this.descriptors[i];
            if (descriptor.getCategory() != category) continue;
            return descriptor;
        }
        return null;
    }

    private CategoryDescriptor[] computeDescriptors(Category[] categories) {
        if (null == categories) {
            return new CategoryDescriptor[0];
        }
        categories = this.getVisibleCategories(categories);
        CategoryDescriptor[] descriptors = new CategoryDescriptor[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            Category category = categories[i];
            CategoryDescriptor descriptor = this.getCategoryDescriptor(category);
            if (descriptor == null) {
                descriptor = new CategoryDescriptor(this, category);
                descriptor.setShowNames(this.getSettings().getShowItemNames());
                descriptor.setIconSize(this.getSettings().getIconSize());
            } else {
                descriptor.refresh();
            }
            descriptor.setWidth(this.getWidth());
            descriptors[i] = descriptor;
        }
        return descriptors;
    }

    private Category[] getVisibleCategories(Category[] cats) {
        ArrayList<Category> tmp = new ArrayList<Category>(cats.length);
        for (int i = 0; i < cats.length; ++i) {
            if (!this.settings.isVisible(cats[i])) continue;
            tmp.add(cats[i]);
        }
        return tmp.toArray(new Category[tmp.size()]);
    }

    void computeHeights(Category openedCategory) {
        this.computeHeights(this.descriptors, openedCategory);
    }

    private void computeHeights(CategoryDescriptor[] paletteCategoryDescriptors, Category openedCategory) {
        if (paletteCategoryDescriptors == null || paletteCategoryDescriptors.length <= 0) {
            return;
        }
        this.revalidate();
    }

    private static boolean arrayContains(Object[] objects, Object object) {
        if (objects == null || object == null) {
            return false;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != object) continue;
            return true;
        }
        return false;
    }

    private void setDescriptors(CategoryDescriptor[] paletteCategoryDescriptors) {
        int i;
        for (i = 0; i < this.descriptors.length; ++i) {
            CategoryDescriptor descriptor = this.descriptors[i];
            if (PalettePanel.arrayContains(paletteCategoryDescriptors, descriptor)) continue;
            this.remove(descriptor.getComponent());
            this.dndSupport.remove(descriptor);
        }
        for (i = 0; i < paletteCategoryDescriptors.length; ++i) {
            CategoryDescriptor paletteCategoryDescriptor = paletteCategoryDescriptors[i];
            if (PalettePanel.arrayContains(this.descriptors, paletteCategoryDescriptor)) continue;
            this.add(paletteCategoryDescriptor.getComponent());
            this.dndSupport.add(paletteCategoryDescriptor);
        }
        if (this.descriptors.length == 0 && paletteCategoryDescriptors.length > 0) {
            boolean isAnyCategoryOpened = false;
            for (int i2 = 0; i2 < paletteCategoryDescriptors.length; ++i2) {
                if (!paletteCategoryDescriptors[i2].isOpened()) continue;
                isAnyCategoryOpened = true;
                break;
            }
            if (!isAnyCategoryOpened) {
                paletteCategoryDescriptors[0].setOpened(true);
            }
        }
        this.descriptors = paletteCategoryDescriptors;
        this.revalidate();
    }

    public void doRefresh() {
        if (null != this.controller) {
            this.controller.refresh();
        }
    }

    public void refresh() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PalettePanel.this.lock;
                synchronized (object) {
                    PalettePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    CategoryDescriptor[] paletteCategoryDescriptors = PalettePanel.this.computeDescriptors(null != PalettePanel.this.model ? PalettePanel.this.model.getCategories() : null);
                    PalettePanel.this.setDescriptors(paletteCategoryDescriptors);
                    if (null != PalettePanel.this.settings) {
                        PalettePanel.this.setIconSize(PalettePanel.this.settings.getIconSize());
                        PalettePanel.this.setShowItemNames(PalettePanel.this.settings.getShowItemNames());
                        PalettePanel.this.setItemWidth(PalettePanel.this.settings.getShowItemNames() ? PalettePanel.this.settings.getItemWidth() : -1);
                    }
                    if (null != PalettePanel.this.model) {
                        Item item = PalettePanel.this.model.getSelectedItem();
                        Category category = PalettePanel.this.model.getSelectedCategory();
                        PalettePanel.this.setSelectedItemFromModel(category, item);
                    }
                    PalettePanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    void select(Category category, Item item) {
        CategoryDescriptor selectedDescriptor;
        if (category != this.selectedCategory && (selectedDescriptor = this.findDescriptorFor(this.selectedCategory)) != null) {
            selectedDescriptor.setSelectedItem(null);
        }
        this.selectedCategory = category;
        if (null != this.model) {
            if (null == category || null == item) {
                this.model.clearSelection();
            } else {
                this.model.setSelectedItem(category.getLookup(), item.getLookup());
            }
        }
    }

    private void setSelectedItemFromModel(Category category, Item item) {
        CategoryDescriptor descriptor;
        CategoryDescriptor selectedDescriptor;
        if (null != this.selectedCategory && !this.selectedCategory.equals(category) && (selectedDescriptor = this.findDescriptorFor(this.selectedCategory)) != null) {
            selectedDescriptor.setSelectedItem(null);
        }
        if ((descriptor = this.findDescriptorFor(category)) == null) {
            return;
        }
        if (item != null) {
            this.selectedCategory = category;
        }
        descriptor.setSelectedItem(item);
    }

    private CategoryDescriptor findDescriptorFor(Category category) {
        if (null != this.descriptors) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                CategoryDescriptor descriptor = this.descriptors[i];
                if (!descriptor.getCategory().equals(category)) continue;
                return descriptor;
            }
        }
        return null;
    }

    private void scrollToCategory(final Category category) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PalettePanel.this.lock;
                synchronized (object) {
                    CategoryDescriptor descriptor = PalettePanel.this.findDescriptorFor(category);
                    if (null != descriptor) {
                        PalettePanel.this.scrollPane.validate();
                        Point loc = descriptor.getComponent().getLocation();
                        PalettePanel.this.scrollPane.getViewport().setViewPosition(loc);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(PaletteController newController, Model newModel, Settings newSettings) {
        Object object = this.lock;
        synchronized (object) {
            if (newModel == this.model && newSettings == this.settings) {
                return;
            }
            Model old = this.model;
            if (this.model != null && null != this.modelListener) {
                this.model.removeModelListener(this.modelListener);
            }
            if (this.settings != null && null != this.settingsListener) {
                this.settings.removePropertyChangeListener(this.settingsListener);
            }
            this.model = newModel;
            this.settings = newSettings;
            this.controller = newController;
            if (this.model != null) {
                this.model.addModelListener(this.getModelListener());
            }
            if (null != this.settings) {
                this.settings.addPropertyChangeListener(this.getSettingsListener());
            }
            this.refresh();
        }
    }

    private MouseListener mouseListener() {
        if (null == this.mouseListener) {
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isRightMouseButton(event) && null != PalettePanel.this.model) {
                        JPopupMenu popup = Utilities.actionsToPopup((Action[])PalettePanel.this.model.getActions(), (Component)PalettePanel.this);
                        Utils.addCustomizationMenuItems(popup, PalettePanel.this.getController(), PalettePanel.this.getSettings());
                        popup.show((Component)event.getSource(), event.getX(), event.getY());
                    }
                }
            };
        }
        return this.mouseListener;
    }

    private void setShowItemNames(boolean showNames) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setShowNames(showNames);
        }
        this.repaint();
    }

    private void setIconSize(int iconSize) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setIconSize(iconSize);
        }
        this.repaint();
    }

    private void setItemWidth(int itemWidth) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].setItemWidth(itemWidth);
        }
        this.repaint();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx ctx = null;
        if (null != this.getModel()) {
            Node selNode;
            Item selItem = this.getModel().getSelectedItem();
            if (null != selItem && null != (selNode = (Node)selItem.getLookup().lookup(Node.class))) {
                ctx = selNode.getHelpCtx();
            }
            if (null == ctx || HelpCtx.DEFAULT_HELP.equals((Object)ctx)) {
                Node selNode2;
                CategoryDescriptor selCategory = null;
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isSelected()) continue;
                    selCategory = this.descriptors[i];
                    break;
                }
                if (null != selCategory && null != (selNode2 = (Node)selCategory.getCategory().getLookup().lookup(Node.class))) {
                    ctx = selNode2.getHelpCtx();
                }
            }
            if ((null == ctx || HelpCtx.DEFAULT_HELP.equals((Object)ctx)) && null != (selNode = (Node)this.getModel().getRoot().lookup(Node.class))) {
                ctx = selNode.getHelpCtx();
            }
        }
        if (null == ctx || HelpCtx.DEFAULT_HELP.equals(ctx)) {
            ctx = new HelpCtx("CommonPalette");
        }
        return ctx;
    }

    private ModelListener getModelListener() {
        if (null == this.modelListener) {
            this.modelListener = new ModelListener(){

                public void categoriesAdded(Category[] addedCategories) {
                    PalettePanel.this.refresh();
                    if (null != addedCategories && addedCategories.length > 0) {
                        PalettePanel.this.scrollToCategory(addedCategories[0]);
                    }
                }

                public void categoriesRemoved(Category[] removedCategories) {
                    PalettePanel.this.refresh();
                }

                public void categoriesReordered() {
                    PalettePanel.this.refresh();
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectedItem".equals(evt.getPropertyName())) {
                        Item selectedItem = PalettePanel.this.model.getSelectedItem();
                        Category selectedCategory = PalettePanel.this.model.getSelectedCategory();
                        PalettePanel.this.setSelectedItemFromModel(selectedCategory, selectedItem);
                    }
                }
            };
        }
        return this.modelListener;
    }

    private PropertyChangeListener getSettingsListener() {
        if (null == this.settingsListener) {
            this.settingsListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("isVisible".equals(evt.getPropertyName())) {
                        PalettePanel.this.refresh();
                        for (int i = 0; null != PalettePanel.this.descriptors && i < PalettePanel.this.descriptors.length; ++i) {
                            PalettePanel.this.descriptors[i].computeItems();
                        }
                    } else if ("iconSize".equals(evt.getPropertyName())) {
                        PalettePanel.this.setIconSize(PalettePanel.this.getSettings().getIconSize());
                    } else if ("showItemNames".equals(evt.getPropertyName())) {
                        PalettePanel.this.setShowItemNames(PalettePanel.this.getSettings().getShowItemNames());
                        PalettePanel.this.setItemWidth(PalettePanel.this.getSettings().getShowItemNames() ? PalettePanel.this.getSettings().getItemWidth() : -1);
                    }
                }
            };
        }
        return this.settingsListener;
    }

    Model getModel() {
        return this.model;
    }

    Settings getSettings() {
        return this.settings;
    }

    PaletteController getController() {
        return this.controller;
    }

    public void updateUI() {
        super.updateUI();
        if (null != this.model) {
            this.model.refresh();
        }
    }

    private class PaletteLayoutManager
    implements LayoutManager {
        private PaletteLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            int width = PalettePanel.this.getWidth();
            int height = 0;
            for (int i = 0; i < PalettePanel.this.descriptors.length; ++i) {
                CategoryDescriptor paletteCategoryDescriptor = PalettePanel.this.descriptors[i];
                paletteCategoryDescriptor.setPositionY(height);
                JComponent comp = paletteCategoryDescriptor.getComponent();
                comp.setSize(width, comp.getPreferredSize().height);
                height += paletteCategoryDescriptor.getComponent().getHeight();
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = PalettePanel.this.getWidth();
            for (int i = 0; i < PalettePanel.this.descriptors.length; ++i) {
                CategoryDescriptor descriptor = PalettePanel.this.descriptors[i];
                height += descriptor.getPreferredHeight(width) + 1;
            }
            return new Dimension(10, height);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

