/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

final class PaletteSwitch
implements Runnable,
LookupListener {
    static final String PROP_PALETTE_CONTENTS = "component_palette_contents";
    private static PaletteSwitch theInstance;
    private PropertyChangeListener registryListener;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private PaletteController currentPalette = this.findPalette();
    private boolean isGroupOpen = false;
    private Lookup.Result lookupRes;

    private PaletteSwitch() {
    }

    public static synchronized PaletteSwitch getDefault() {
        if (null == theInstance) {
            theInstance = new PaletteSwitch();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null == this.registryListener) {
                this.registryListener = this.createRegistryListener();
                TopComponent.getRegistry().addPropertyChangeListener(this.registryListener);
                this.switchLookupListener();
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null != this.registryListener) {
                TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
                this.registryListener = null;
                this.currentPalette = null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public PaletteController getCurrentPalette() {
        return this.currentPalette;
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        PaletteController oldPalette = this.currentPalette;
        this.currentPalette = this.findPalette();
        this.showHidePaletteTopComponent(oldPalette, this.currentPalette);
        this.propertySupport.firePropertyChange(PROP_PALETTE_CONTENTS, oldPalette, this.currentPalette);
    }

    private PaletteController findPalette() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        TopComponent activeTc = registry.getActivated();
        PaletteController palette = this.getPaletteFromTopComponent(activeTc, true);
        ArrayList<PaletteController> availablePalettes = new ArrayList<PaletteController>(3);
        if (null == palette) {
            Set openedTcs = registry.getOpened();
            for (TopComponent tc : openedTcs) {
                palette = this.getPaletteFromTopComponent(tc, true);
                if (null == palette) continue;
                availablePalettes.add(palette);
            }
            if (null != this.currentPalette && (availablePalettes.contains(this.currentPalette) || this.isPaletteMaximized())) {
                palette = this.currentPalette;
            } else if (availablePalettes.size() > 0) {
                palette = (PaletteController)availablePalettes.get(0);
            }
        }
        return palette;
    }

    private boolean isPaletteMaximized() {
        boolean isMaximized = true;
        boolean currentPaletteStillAvailable = false;
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set openedTcs = registry.getOpened();
        for (TopComponent tc : openedTcs) {
            PaletteController palette;
            if (tc.isShowing() && !(tc instanceof PaletteTopComponent)) {
                isMaximized = false;
                break;
            }
            if (currentPaletteStillAvailable || null == (palette = this.getPaletteFromTopComponent(tc, false)) || palette != this.currentPalette) continue;
            currentPaletteStillAvailable = true;
        }
        return isMaximized && currentPaletteStillAvailable;
    }

    PaletteController getPaletteFromTopComponent(TopComponent tc, boolean mustBeShowing) {
        DataObject dob;
        Node[] activeNodes;
        if (null == tc || !tc.isShowing() && mustBeShowing) {
            return null;
        }
        PaletteController pc = (PaletteController)tc.getLookup().lookup(PaletteController.class);
        if (null == pc && WindowManager.getDefault().isEditorTopComponent(tc) && null != (activeNodes = tc.getActivatedNodes()) && activeNodes.length > 0 && null != (dob = (DataObject)activeNodes[0].getLookup().lookup(DataObject.class))) {
            while (dob instanceof DataShadow) {
                dob = ((DataShadow)dob).getOriginal();
            }
            FileObject fo = dob.getPrimaryFile();
            if (!fo.isVirtual()) {
                String mimeType = fo.getMIMEType();
                pc = this.getPaletteFromMimeType(mimeType);
            }
        }
        return pc;
    }

    PaletteController getPaletteFromMimeType(String mimeType) {
        MimePath path = MimePath.get((String)mimeType);
        Lookup lkp = MimeLookup.getLookup((MimePath)path);
        return (PaletteController)lkp.lookup(PaletteController.class);
    }

    private void showHidePaletteTopComponent(PaletteController prevPalette, PaletteController newPalette) {
        if (prevPalette == newPalette && null != newPalette) {
            return;
        }
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup("commonpalette");
        if (null == group) {
            return;
        }
        if (null == prevPalette && null != newPalette) {
            group.open();
            this.isGroupOpen = true;
        } else if ((null != prevPalette && null == newPalette || null == prevPalette && null == newPalette) && this.isGroupOpen) {
            PalettePanel.getDefault().setContent(null, null, null);
            group.close();
            this.isGroupOpen = false;
        }
    }

    private void switchLookupListener() {
        TopComponent active = TopComponent.getRegistry().getActivated();
        if (null != this.lookupRes) {
            this.lookupRes.removeLookupListener((LookupListener)this);
            this.lookupRes = null;
        }
        if (null != active) {
            this.lookupRes = active.getLookup().lookup(new Lookup.Template(PaletteController.class));
            this.lookupRes.addLookupListener((LookupListener)this);
            this.lookupRes.allItems();
        }
    }

    private PropertyChangeListener createRegistryListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentNodes".equals(evt.getPropertyName()) || "opened".equals(evt.getPropertyName()) || "activated".equals(evt.getPropertyName())) {
                    if ("activated".equals(evt.getPropertyName())) {
                        PaletteSwitch.this.switchLookupListener();
                    }
                    PaletteSwitch.this.run();
                }
            }
        };
    }

    public void resultChanged(LookupEvent ev) {
        this.run();
    }
}

