/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.editor.java.HTMLJavadocParser;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCompletionDoc
implements CompletionDocumentation {
    private ClasspathInfo cpInfo;
    private Doc doc;
    private String content = null;
    private Hashtable<String, ElementHandle<? extends Element>> links = new Hashtable();
    private int linkCounter = 0;
    private URL docURL = null;
    private AbstractAction goToSource = null;
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String THROWS_TAG = "@throws";
    private static final String SEE_TAG = "@see";
    private static final String SINCE_TAG = "@since";
    private static final String INHERIT_DOC_TAG = "@inheritDoc";
    private static final String LINKPLAIN_TAG = "@linkplain";
    private static final String CODE_TAG = "@code";
    private static final String DEPRECATED_TAG = "@deprecated";

    public static final JavaCompletionDoc create(CompilationController controller, Element element) {
        return new JavaCompletionDoc(controller, element, null);
    }

    private JavaCompletionDoc(CompilationController controller, Element element, URL url) {
        ElementUtilities eu = controller.getElementUtilities();
        this.cpInfo = controller.getClasspathInfo();
        this.doc = eu.javaDocFor(element);
        if (element != null) {
            final FileObject fo = SourceUtils.getFile((Element)element, (ClasspathInfo)controller.getClasspathInfo());
            if (fo != null) {
                final ElementHandle handle = ElementHandle.create((Element)element);
                this.goToSource = new AbstractAction(){

                    public void actionPerformed(ActionEvent evt) {
                        UiUtils.open((FileObject)fo, (ElementHandle)handle);
                    }
                };
            }
            if (url != null) {
                this.docURL = url;
            } else {
                CharSequence fragment;
                this.docURL = SourceUtils.getJavadoc((Element)element, (ClasspathInfo)this.cpInfo);
                if (this.docURL != null && (fragment = this.getFragment(element)).length() > 0) {
                    try {
                        this.docURL = new URL(this.docURL.toExternalForm() + "#" + fragment);
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.content = this.prepareContent(eu);
    }

    public String getText() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public CompletionDocumentation resolveLink(final String link) {
        final CompletionDocumentation[] ret = new CompletionDocumentation[1];
        try {
            JavaSource js;
            final ElementHandle<? extends Element> linkDoc = this.links.get(link);
            FileObject fo = linkDoc != null ? SourceUtils.getFile(linkDoc, (ClasspathInfo)this.cpInfo) : null;
            JavaSource javaSource = js = fo != null ? JavaSource.forFileObject((FileObject)fo) : JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            if (js != null) {
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (linkDoc != null) {
                            ret[0] = new JavaCompletionDoc(controller, linkDoc.resolve((CompilationInfo)controller), null);
                        } else {
                            int idx = link.indexOf(35);
                            URI uri = URI.create(idx < 0 ? link : link.substring(0, idx));
                            if (uri != null) {
                                String path;
                                int startIdx;
                                if (!uri.isAbsolute()) {
                                    uri = uri.normalize();
                                }
                                startIdx = (startIdx = (path = uri.toString()).lastIndexOf("..")) < 0 ? 0 : startIdx + 3;
                                int endIdx = path.lastIndexOf(46);
                                if (endIdx >= 0) {
                                    path = path.substring(startIdx, endIdx);
                                }
                                String clsName = path.replace('/', '.');
                                Element e = controller.getElements().getTypeElement(clsName);
                                if (e != null) {
                                    if (idx >= 0) {
                                        String fragment = link.substring(idx + 1);
                                        String name = (idx = fragment.indexOf(40)) < 0 ? fragment : fragment.substring(0, idx);
                                        for (Element element : e.getEnclosedElements()) {
                                            if (!element.getSimpleName().contentEquals(name) || !fragment.contentEquals(JavaCompletionDoc.this.getFragment(element))) continue;
                                            e = element;
                                            break;
                                        }
                                    }
                                    ret[0] = new JavaCompletionDoc(controller, e, new URL(JavaCompletionDoc.this.docURL, link));
                                }
                            }
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return ret[0];
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }

    private String prepareContent(ElementUtilities eu) {
        StringBuilder sb = new StringBuilder();
        if (this.doc != null) {
            if (this.doc instanceof ProgramElementDoc) {
                sb.append(this.getContainingClassOrPacakgeHeader(eu, (ProgramElementDoc)this.doc));
            }
            if (this.doc.isMethod() || this.doc.isConstructor() || this.doc.isAnnotationTypeElement()) {
                sb.append(this.getMethodHeader(eu, (ExecutableMemberDoc)this.doc));
            } else if (this.doc.isField() || this.doc.isEnumConstant()) {
                sb.append(this.getFieldHeader(eu, (FieldDoc)this.doc));
            } else if (this.doc.isClass() || this.doc.isInterface() || this.doc.isAnnotationType()) {
                sb.append(this.getClassHeader(eu, (ClassDoc)this.doc));
            }
            sb.append("<p>");
            if (this.doc.commentText().length() > 0 || this.doc.tags().length > 0) {
                sb.append(this.getDeprecatedTag(eu, this.doc));
                sb.append(this.inlineTags(eu, this.doc, this.doc.inlineTags()));
                sb.append("</p><p>");
                sb.append(this.getTags(eu, this.doc));
            } else {
                String jdText;
                String string = jdText = this.docURL != null ? HTMLJavadocParser.getJavadocText(this.docURL, false) : null;
                if (jdText != null) {
                    sb.append(jdText);
                } else {
                    sb.append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"javadoc_content_not_found"));
                }
            }
            sb.append("</p>");
        } else {
            sb.append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"javadoc_content_not_found"));
        }
        return sb.toString();
    }

    private CharSequence getContainingClassOrPacakgeHeader(ElementUtilities eu, ProgramElementDoc peDoc) {
        StringBuilder sb = new StringBuilder();
        ClassDoc cls = peDoc.containingClass();
        if (cls != null) {
            Element e = eu.elementFor((Doc)cls);
            if (e != null) {
                switch (e.getEnclosingElement().getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case PACKAGE: {
                        if (cls.containingClass() == null && cls.containingPackage() == null) break;
                        sb.append("<font size='+0'><b>");
                        this.createLink(sb, e, cls.qualifiedName());
                        sb.append("</b></font>");
                    }
                }
            }
        } else {
            PackageDoc pkg = peDoc.containingPackage();
            if (pkg != null) {
                sb.append("<font size='+0'><b>");
                this.createLink(sb, eu.elementFor((Doc)pkg), pkg.name());
                sb.append("</b></font>");
            }
        }
        return sb;
    }

    private CharSequence getMethodHeader(ElementUtilities eu, ExecutableMemberDoc mdoc) {
        Type[] exs;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        sb.append(this.getAnnotations(eu, (ProgramElementDoc)mdoc));
        int len = sb.length();
        sb.append(Modifier.toString(mdoc.modifierSpecifier() & 0xFFFFFEFF));
        len = sb.length() - len;
        TypeVariable[] tvars = mdoc.typeParameters();
        if (tvars.length > 0) {
            if (len > 0) {
                sb.append(' ');
                ++len;
            }
            sb.append("&lt;");
            for (int i2 = 0; i2 < tvars.length; ++i2) {
                len += this.appendType(eu, sb, (Type)tvars[i2], false, true);
                if (i2 >= tvars.length - 1) continue;
                sb.append(",");
                ++len;
            }
            sb.append("&gt;");
            len += 2;
        }
        if (!mdoc.isConstructor()) {
            if (len > 0) {
                sb.append(' ');
                ++len;
            }
            len += this.appendType(eu, sb, ((MethodDoc)mdoc).returnType(), false, false);
        }
        String name = mdoc.name();
        len += name.length();
        sb.append(" <b>").append(name).append("</b>");
        if (!mdoc.isAnnotationTypeElement()) {
            sb.append('(');
            ++len;
            Parameter[] params = mdoc.parameters();
            for (i = 0; i < params.length; ++i) {
                boolean varArg = i == params.length - 1 && mdoc.isVarArgs();
                this.appendType(eu, sb, params[i].type(), varArg, false);
                sb.append(' ').append(params[i].name());
                String dim = params[i].type().dimension();
                if (dim.length() > 0 && varArg) {
                    dim = dim.substring(2) + "...";
                }
                if (i >= params.length - 1) continue;
                sb.append(",\n");
                this.appendSpace(sb, len);
            }
            sb.append(')');
        }
        if ((exs = mdoc.thrownExceptionTypes()).length > 0) {
            sb.append("\nthrows ");
            for (i = 0; i < exs.length; ++i) {
                this.appendType(eu, sb, exs[i], false, false);
                if (i >= exs.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("</pre>");
        return sb;
    }

    private CharSequence getFieldHeader(ElementUtilities eu, FieldDoc fdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        sb.append(this.getAnnotations(eu, (ProgramElementDoc)fdoc));
        int len = sb.length();
        sb.append(fdoc.modifiers());
        len = sb.length() - len;
        if (len > 0) {
            sb.append(' ');
        }
        this.appendType(eu, sb, fdoc.type(), false, false);
        sb.append(" <b>").append(fdoc.name()).append("</b>");
        sb.append("</pre>");
        return sb;
    }

    private CharSequence getClassHeader(ElementUtilities eu, ClassDoc cdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        sb.append(this.getAnnotations(eu, (ProgramElementDoc)cdoc));
        int mods = cdoc.modifierSpecifier() & 0xFFFFFDFF;
        if (cdoc.isEnum()) {
            mods &= 0xFFFFFFEF;
        }
        sb.append(Modifier.toString(mods));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        if (cdoc.isAnnotationType()) {
            sb.append("@interface ");
        } else if (cdoc.isEnum()) {
            sb.append("enum ");
        } else if (cdoc.isInterface()) {
            sb.append("interface ");
        } else {
            sb.append("class ");
        }
        sb.append("<b>").append(cdoc.name());
        TypeVariable[] tvars = cdoc.typeParameters();
        if (tvars.length > 0) {
            sb.append("&lt;");
            for (int i = 0; i < tvars.length; ++i) {
                this.appendType(eu, sb, (Type)tvars[i], false, true);
                if (i >= tvars.length - 1) continue;
                sb.append(",");
            }
            sb.append("&gt;");
        }
        sb.append("</b>");
        if (!cdoc.isAnnotationType()) {
            Type[] ifaces;
            Type supercls;
            if (cdoc.isClass() && (supercls = cdoc.superclassType()) != null) {
                sb.append("\nextends ");
                this.appendType(eu, sb, supercls, false, false);
            }
            if ((ifaces = cdoc.interfaceTypes()).length > 0) {
                sb.append(cdoc.isInterface() ? "\nextends " : "\nimplements ");
                for (int i = 0; i < ifaces.length; ++i) {
                    this.appendType(eu, sb, ifaces[i], false, false);
                    if (i >= ifaces.length - 1) continue;
                    sb.append(", ");
                }
            }
        }
        sb.append("</pre>");
        return sb;
    }

    private CharSequence getAnnotations(ElementUtilities eu, ProgramElementDoc peDoc) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationDesc annotationDesc : peDoc.annotations()) {
            AnnotationTypeDoc annotationType = annotationDesc.annotationType();
            if (annotationType == null) continue;
            this.appendType(eu, sb, (Type)annotationType, false, false);
            AnnotationDesc.ElementValuePair[] pairs = annotationDesc.elementValues();
            if (pairs.length > 0) {
                sb.append('(');
                for (int i = 0; i < pairs.length; ++i) {
                    AnnotationTypeElementDoc ated = pairs[i].element();
                    this.createLink(sb, eu.elementFor((Doc)ated), ated.name());
                    sb.append('=');
                    this.appendAnnotationValue(eu, sb, pairs[i].value());
                    if (i >= pairs.length - 1) continue;
                    sb.append(",");
                }
                sb.append(')');
            }
            sb.append('\n');
        }
        return sb;
    }

    private void appendAnnotationValue(ElementUtilities eu, StringBuilder sb, AnnotationValue av) {
        Object value = av.value();
        if (value instanceof AnnotationValue[]) {
            int length = ((AnnotationValue[])value).length;
            if (length > 1) {
                sb.append('{');
            }
            for (int i = 0; i < ((AnnotationValue[])value).length; ++i) {
                this.appendAnnotationValue(eu, sb, ((AnnotationValue[])value)[i]);
                if (i >= ((AnnotationValue[])value).length - 1) continue;
                sb.append(",");
            }
            if (length > 1) {
                sb.append('}');
            }
        } else if (value instanceof Doc) {
            this.createLink(sb, eu.elementFor((Doc)value), ((Doc)value).name());
        } else {
            sb.append(value.toString());
        }
    }

    private CharSequence getTags(ElementUtilities eu, Doc doc) {
        int length;
        StringBuilder see = new StringBuilder();
        StringBuilder par = new StringBuilder();
        StringBuilder thr = new StringBuilder();
        StringBuilder ret = new StringBuilder();
        String since = null;
        for (Tag tag : doc.tags()) {
            if (PARAM_TAG.equals(tag.kind())) {
                par.append("<code>").append(((ParamTag)tag).parameterName()).append("</code>");
                Tag[] its = tag.inlineTags();
                if (its.length > 0) {
                    par.append(" - ");
                    par.append(this.inlineTags(eu, doc, its));
                }
                par.append("<br>");
                continue;
            }
            if (THROWS_TAG.equals(tag.kind())) {
                thr.append("<code>");
                Type exType = ((ThrowsTag)tag).exceptionType();
                if (exType != null) {
                    this.createLink(thr, eu.elementFor((Doc)exType.asClassDoc()), exType.simpleTypeName());
                } else {
                    thr.append(((ThrowsTag)tag).exceptionName());
                }
                thr.append("</code>");
                Tag[] its = tag.inlineTags();
                if (its.length > 0) {
                    thr.append(" - ");
                    thr.append(this.inlineTags(eu, doc, its));
                }
                thr.append("<br>");
                continue;
            }
            if (RETURN_TAG.equals(tag.kind())) {
                ret.append(this.inlineTags(eu, doc, tag.inlineTags()));
                ret.append("<br>");
                continue;
            }
            if (SEE_TAG.equals(tag.kind())) {
                SeeTag stag = (SeeTag)tag;
                ClassDoc refClass = stag.referencedClass();
                String className = stag.referencedClassName();
                String memberName = stag.referencedMemberName();
                String label = stag.label();
                if (memberName != null) {
                    if (refClass != null) {
                        this.createLink(see, eu.elementFor((Doc)stag.referencedMember()), "<code>" + (label != null && label.length() > 0 ? label : refClass.simpleTypeName() + "." + memberName) + "</code>");
                    } else {
                        see.append(className);
                        see.append('.');
                        see.append(memberName);
                    }
                    see.append(", ");
                    continue;
                }
                if (className != null) {
                    if (refClass != null) {
                        this.createLink(see, eu.elementFor((Doc)refClass), "<code>" + (label != null && label.length() > 0 ? label : refClass.simpleTypeName()) + "</code>");
                    } else {
                        see.append(className);
                    }
                    see.append(", ");
                    continue;
                }
                see.append(stag.text()).append(", ");
                continue;
            }
            if (!SINCE_TAG.equals(tag.kind())) continue;
            since = tag.text();
        }
        StringBuilder sb = new StringBuilder();
        if (par.length() > 0) {
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-params")).append("</b><blockquote>").append((CharSequence)par).append("</blockquote>");
        }
        if (ret.length() > 0) {
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-returns")).append("</b><blockquote>").append((CharSequence)ret).append("</blockquote>");
        }
        if (thr.length() > 0) {
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-throws")).append("</b><blockquote>").append((CharSequence)thr).append("</blockquote>");
        }
        if (since != null) {
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-since")).append("</b><blockquote>").append(since).append("</blockquote>");
        }
        if ((length = see.length()) > 0) {
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-see")).append("</b><blockquote>").append((CharSequence)see.delete(length - 2, length)).append("</blockquote>");
        }
        return sb;
    }

    private CharSequence getDeprecatedTag(ElementUtilities eu, Doc doc) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : doc.tags()) {
            if (!DEPRECATED_TAG.equals(tag.kind())) continue;
            sb.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-deprecated")).append("</b> <i>").append(tag.text()).append("</i></p><p>");
        }
        return sb;
    }

    private CharSequence inlineTags(ElementUtilities eu, Doc doc, Tag[] tags) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            if (SEE_TAG.equals(tag.kind())) {
                SeeTag stag = (SeeTag)tag;
                ClassDoc refClass = stag.referencedClass();
                String memberName = stag.referencedMemberName();
                String label = stag.label();
                boolean plain = LINKPLAIN_TAG.equals(stag.name());
                if (memberName != null) {
                    if (refClass != null) {
                        this.createLink(sb, eu.elementFor((Doc)stag.referencedMember()), (plain ? "" : "<code>") + (label != null && label.length() > 0 ? label : refClass.simpleTypeName() + "." + memberName) + (plain ? "" : "</code>"));
                        continue;
                    }
                    sb.append(stag.referencedClassName());
                    sb.append('.');
                    sb.append(memberName);
                    continue;
                }
                if (refClass != null) {
                    this.createLink(sb, eu.elementFor((Doc)refClass), (plain ? "" : "<code>") + (label != null && label.length() > 0 ? label : refClass.simpleTypeName()) + (plain ? "" : "</code>"));
                    continue;
                }
                sb.append(stag.referencedClassName());
                continue;
            }
            if (INHERIT_DOC_TAG.equals(tag.kind())) {
                ClassDoc cdoc;
                if (doc.isMethod()) {
                    MethodDoc mdoc = ((MethodDoc)doc).overriddenMethod();
                    if (mdoc == null) continue;
                    sb.append(this.inlineTags(eu, (Doc)mdoc, mdoc.inlineTags()));
                    continue;
                }
                if (!doc.isClass() && !doc.isInterface() || (cdoc = ((ClassDoc)doc).superclass()) == null) continue;
                sb.append(this.inlineTags(eu, (Doc)cdoc, cdoc.inlineTags()));
                continue;
            }
            if (CODE_TAG.equals(tag.kind())) {
                sb.append("<code>");
                sb.append(tag.text());
                sb.append("</code>");
                continue;
            }
            sb.append(tag.text());
        }
        return sb;
    }

    private CharSequence getFragment(Element e) {
        StringBuilder sb = new StringBuilder();
        if (!e.getKind().isClass() && !e.getKind().isInterface()) {
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(e.getEnclosingElement().getSimpleName());
            } else {
                sb.append(e.getSimpleName());
            }
            if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)e;
                sb.append('(');
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    this.appendType(sb, param.asType(), ee.isVarArgs() && !it.hasNext());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(')');
            }
        }
        return sb;
    }

    private void appendType(StringBuilder sb, TypeMirror type, boolean varArg) {
        switch (type.getKind()) {
            case ARRAY: {
                this.appendType(sb, ((ArrayType)type).getComponentType(), false);
                sb.append(varArg ? "..." : "[]");
                break;
            }
            case DECLARED: {
                sb.append(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName());
                break;
            }
            default: {
                sb.append(type);
            }
        }
    }

    private void appendSpace(StringBuilder sb, int length) {
        while (length-- >= 0) {
            sb.append(' ');
        }
    }

    private int appendType(ElementUtilities eu, StringBuilder sb, Type type, boolean varArg, boolean typeVar) {
        int len = 0;
        WildcardType wt = type.asWildcardType();
        if (wt != null) {
            sb.append('?');
            ++len;
            Type[] bounds = wt.extendsBounds();
            if (bounds != null && bounds.length > 0) {
                sb.append(" extends ");
                len += 9;
                len += this.appendType(eu, sb, bounds[0], false, false);
            }
            if ((bounds = wt.superBounds()) != null && bounds.length > 0) {
                sb.append(" super ");
                len += 7;
                len += this.appendType(eu, sb, bounds[0], false, false);
            }
        } else {
            TypeVariable tv = type.asTypeVariable();
            if (tv != null) {
                len += this.createLink(sb, null, tv.simpleTypeName());
                Type[] bounds = tv.bounds();
                if (typeVar && bounds != null && bounds.length > 0) {
                    sb.append(" extends ");
                    len += 9;
                    for (int i = 0; i < bounds.length; ++i) {
                        len += this.appendType(eu, sb, bounds[i], false, false);
                        if (i >= bounds.length - 1) continue;
                        sb.append(" & ");
                        len += 3;
                    }
                }
            } else {
                Type[] targs;
                String tName = type.simpleTypeName();
                ClassDoc cd = type.asClassDoc();
                if (cd != null && cd.isAnnotationType()) {
                    tName = "@" + tName;
                }
                len += this.createLink(sb, eu.elementFor((Doc)type.asClassDoc()), tName);
                ParameterizedType pt = type.asParameterizedType();
                if (pt != null && (targs = pt.typeArguments()).length > 0) {
                    sb.append("&lt;");
                    for (int j = 0; j < targs.length; ++j) {
                        len += this.appendType(eu, sb, targs[j], false, false);
                        if (j >= targs.length - 1) continue;
                        sb.append(",");
                        ++len;
                    }
                    sb.append("&gt;");
                    len += 2;
                }
            }
        }
        String dim = type.dimension();
        if (dim.length() > 0) {
            if (varArg) {
                dim = dim.substring(2) + "...";
            }
            sb.append(dim);
            len += dim.length();
        }
        return len;
    }

    private int createLink(StringBuilder sb, Element e, String text) {
        if (e != null && e.asType().getKind() != TypeKind.ERROR) {
            String link = "*" + this.linkCounter++;
            this.links.put(link, (ElementHandle<? extends Element>)ElementHandle.create((Element)e));
            sb.append("<a href='").append(link).append("'>");
        }
        sb.append(text);
        if (e != null) {
            sb.append("</a>");
        }
        return text.length();
    }
}

