/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.BracketCompletion;
import org.netbeans.modules.editor.java.DeleteToNextCamelCasePosition;
import org.netbeans.modules.editor.java.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaDocument;
import org.netbeans.modules.editor.java.NextCamelCasePosition;
import org.netbeans.modules.editor.java.PreviousCamelCasePosition;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.editor.java.SelectNextCamelCasePosition;
import org.netbeans.modules.editor.java.SelectPreviousCamelCasePosition;
import org.netbeans.modules.java.editor.JavaEditorModule;
import org.netbeans.modules.java.editor.codegen.GenerateCodeAction;
import org.netbeans.modules.java.editor.imports.FastImportAction;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.editor.overridden.GoToSuperTypeAction;
import org.netbeans.modules.java.editor.rename.InstantRenameAction;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String javaDocShowAction = "javadoc-show-action";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";
    static final long serialVersionUID = -5445829962533684922L;

    public JavaKit() {
        JavaEditorModule.init();
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Syntax createSyntax(Document doc) {
        return new JavaSyntax(this.getSourceLevel((BaseDocument)doc));
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    public Document createDefaultDocument() {
        JavaDocument doc = new JavaDocument(((Object)((Object)this)).getClass());
        Object mimeType = doc.getProperty("mimeType");
        if (mimeType == null) {
            doc.putProperty("mimeType", this.getContentType());
        }
        return doc;
    }

    public String getSourceLevel(BaseDocument doc) {
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        return dob != null ? SourceLevelQuery.getSourceLevel((FileObject)dob.getPrimaryFile()) : null;
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void initDocument(BaseDocument doc) {
        doc.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        doc.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID id, TokenContextPath contextPath, int offset, int length) {
                if (JavaTokenContext.LINE_COMMENT == id) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, id, contextPath, offset, length));
                }
            }
        });
        CodeTemplateManager.get((Document)doc);
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new JavaGenerateGoToPopupAction(), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new ExpandAllJavadocFolds(), new CollapseAllJavadocFolds(), new ExpandAllCodeBlockFolds(), new CollapseAllCodeBlockFolds(), new JavaGenerateFoldPopupAction(), new JavaGoToDeclarationAction(), new JavaGoToSourceAction(), new InstantRenameAction(), new JavaFixImports(), new GenerateCodeAction(), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new NextCamelCasePosition(), new PreviousCamelCasePosition(), new SelectNextCamelCasePosition(), new SelectPreviousCamelCasePosition(), new DeleteToNextCamelCasePosition(), new DeleteToPreviousCamelCasePosition(), new FastImportAction(), new GoToSuperTypeAction()};
        return TextAction.augmentList(super.createActions(), javaActions);
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.out.println(\"");
                String title = (String)doc.getProperty((Object)"title");
                if (title != null) {
                    sb.append(title);
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset((BaseDocument)doc, (int)target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction((Action)a, (ActionEvent)new ActionEvent(target, 1001, sb.toString()), (JTextComponent)target);
                }
            }
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(JavaKit.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, types);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public CollapseAllJavadocFolds() {
            super(JavaKit.collapseAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.collapseAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-collapse-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(JavaKit.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)hierarchy, types);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public ExpandAllJavadocFolds() {
            super(JavaKit.expandAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.expandAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-expand-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            if (insertedChar == '\"' || insertedChar == '\'') {
                boolean inserted = BracketCompletion.completeQuote(doc, dotPos, caret, insertedChar);
                if (inserted) {
                    caret.setDot(dotPos + 1);
                } else {
                    super.insertString(doc, dotPos, caret, str, overwrite);
                }
            } else {
                super.insertString(doc, dotPos, caret, str, overwrite);
                BracketCompletion.charInserted(doc, dotPos, caret, insertedChar);
            }
        }

        protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            Document doc = target.getDocument();
            if (insertedChar == '\"' || insertedChar == '\'') {
                if (doc != null) {
                    try {
                        boolean inserted = false;
                        int p0 = Math.min(caret.getDot(), caret.getMark());
                        int p1 = Math.max(caret.getDot(), caret.getMark());
                        if (p0 != p1) {
                            doc.remove(p0, p1 - p0);
                        }
                        int caretPosition = caret.getDot();
                        if (doc instanceof BaseDocument) {
                            inserted = BracketCompletion.completeQuote((BaseDocument)doc, caretPosition, caret, insertedChar);
                        }
                        if (inserted) {
                            caret.setDot(caretPosition + 1);
                        } else if (str != null && str.length() > 0) {
                            doc.insertString(p0, str, null);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(target, dotPos, caret, str, overwrite);
                if (doc instanceof BaseDocument) {
                    BracketCompletion.charInserted((BaseDocument)doc, caret.getDot() - 1, caret, insertedChar);
                }
            }
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            BracketCompletion.charBackspaced(doc, dotPos, caret, ch);
        }
    }

    private static class JavaFixImports
    extends BaseAction {
        public JavaFixImports() {
            super(JavaKit.fixImportsAction, 14);
            this.putValue("trimmed-text", NbBundle.getBundle(JavaKit.class).getString("fix-imports-trimmed"));
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("desc-fix-imports"));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-fix-imports"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Document doc = target.getDocument();
                FileObject fo = ((DataObject)doc.getProperty("stream")).getPrimaryFile();
                JavaFixAllImports.getDefault().fixAllImports(fo);
            }
        }

        public static final class GlobalAction
        extends MainMenuAction {
            private final JMenuItem menuPresenter = new JMenuItem(this.getMenuItemText());

            public GlobalAction() {
                this.setMenu();
            }

            protected String getMenuItemText() {
                return NbBundle.getBundle(GlobalAction.class).getString("fix-imports-main-menu-source-item");
            }

            protected String getActionName() {
                return JavaKit.fixImportsAction;
            }

            public JMenuItem getMenuPresenter() {
                return this.menuPresenter;
            }
        }
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, JavaKit.collapseAllJavadocFolds);
            this.addAction(target, menu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(target, menu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            Keymap km = target.getKeymap();
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
        }

        private void addAction(JTextComponent target, JMenu menu, Action a) {
            if (a != null) {
                String actionName = (String)a.getValue("Name");
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null) {
                    String itemText = (String)a.getValue("trimmed-text");
                    if (itemText == null) {
                        itemText = this.getItemText(target, actionName, a);
                    }
                    if (itemText != null) {
                        item = new JMenuItem(itemText);
                        Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                        item.addActionListener(a);
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(a.isEnabled());
                        Object helpID = a.getValue("helpID");
                        if (helpID != null && helpID instanceof String) {
                            item.putClientProperty("HelpID", helpID);
                        }
                    } else if ("goto-source".equals(actionName)) {
                        item = new JMenuItem(NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(false);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            String menuText = NbBundle.getBundle(JavaKit.class).getString("generate-goto-popup");
            JMenu jm = new JMenu(menuText);
            this.addAction(target, jm, "goto-source");
            this.addAction(target, jm, "goto-declaration");
            this.addAction(target, jm, "goto-super-implementation");
            this.addAction(target, jm, "goto");
            return jm;
        }
    }

    private static class JavaGoToDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        private JavaGoToDeclarationAction() {
        }

        public boolean gotoDeclaration(JTextComponent target) {
            GoToSupport.goTo((Document)((BaseDocument)target.getDocument()), target.getCaretPosition(), false);
            return true;
        }
    }

    private static class JavaGoToSourceAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public JavaGoToSourceAction() {
            super("goto-source", 142);
            this.putValue("trimmed-text", LocaleSupport.getString((String)"goto-source-trimmed"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                GoToSupport.goTo((Document)((BaseDocument)target.getDocument()), target.getCaretPosition(), true);
            }
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            int dotPos = caret.getDot();
            if (BracketCompletion.posWithinString(doc, dotPos)) {
                try {
                    doc.insertString(dotPos, "\" + \"", null);
                    caret.setDot(dotPos += 3);
                    return new Integer(dotPos);
                }
                catch (BadLocationException ex) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(doc, dotPos)) {
                        int end = BracketCompletion.getRowOrBlockEnd(doc, dotPos);
                        doc.insertString(end, "}", null);
                        doc.getFormatter().indentNewLine((Document)doc, end);
                        caret.setDot(dotPos);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
            if (cookie != null && cookie instanceof Integer) {
                int nowDotPos = caret.getDot();
                caret.setDot(nowDotPos + 1);
            }
        }
    }
}

