/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTypeCompletionItem
extends JavaCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> handle;
    private EnumSet<ElementKind> kinds;
    private JavaSource javaSource;
    private String name;
    private String simpleName;
    private String pkgName;
    private JavaCompletionItem delegate = null;
    private LazyTypeCompletionItem nextItem = null;
    private CharSequence sortText;
    private int prefWidth = -1;

    public static final LazyTypeCompletionItem create(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, JavaSource javaSource) {
        return new LazyTypeCompletionItem(handle, kinds, substitutionOffset, javaSource);
    }

    private LazyTypeCompletionItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, JavaSource javaSource) {
        super(substitutionOffset);
        this.handle = handle;
        this.kinds = kinds;
        this.javaSource = javaSource;
        this.name = handle.getQualifiedName();
        int idx = this.name.lastIndexOf(46);
        this.simpleName = idx > -1 ? this.name.substring(idx + 1) : this.name;
        this.pkgName = idx > -1 ? this.name.substring(0, idx) : "";
        this.sortText = new JavaCompletionItem.ClassSortText(this.simpleName, this.pkgName);
    }

    public boolean accept() {
        if (this.handle != null) {
            if (this.simpleName.length() == 0 || Character.isDigit(this.simpleName.charAt(0))) {
                this.handle = null;
                return false;
            }
            try {
                this.javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Scope scope = controller.getTrees().getScope(controller.getTreeUtilities().pathFor(LazyTypeCompletionItem.this.substitutionOffset));
                        LazyTypeCompletionItem item = LazyTypeCompletionItem.this;
                        int i = 0;
                        while (i < 50 && item != null) {
                            if (item.init(controller, scope)) {
                                ++i;
                            }
                            item = item.nextItem;
                        }
                    }
                }, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    @Override
    public void defaultAction(JTextComponent component) {
        if (this.delegate != null) {
            this.delegate.defaultAction(component);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(evt);
        }
    }

    @Override
    public int getPreferredWidth(Graphics g, Font defaultFont) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)g, (Font)defaultFont);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (this.delegate != null) {
            this.delegate.render(g, defaultFont, defaultColor, backgroundColor, width, height, selected);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    public int getSortPriority() {
        return 700;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    void setNextItem(LazyTypeCompletionItem nextItem) {
        this.nextItem = nextItem;
    }

    boolean init(CompilationController controller, Scope scope) {
        TypeElement e;
        if (this.simpleName.length() >= 0 && !Character.isDigit(this.simpleName.charAt(0)) && (e = (TypeElement)this.handle.resolve((CompilationInfo)controller)) != null && controller.getTrees().isAccessible(scope, e) && this.isOfKind(e, this.kinds)) {
            this.delegate = JavaCompletionItem.createTypeItem(e, (DeclaredType)e.asType(), this.substitutionOffset, true, controller.getElements().isDeprecated(e), false);
        }
        this.handle = null;
        return this.delegate != null;
    }

    private boolean isOfKind(Element e, EnumSet<ElementKind> kinds) {
        if (kinds.contains((Object)e.getKind())) {
            return true;
        }
        for (Element element : e.getEnclosedElements()) {
            if (!this.isOfKind(element, kinds)) continue;
            return true;
        }
        return false;
    }
}

