/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class SelectCodeElementAction
extends BaseAction {
    private boolean selectNext;

    public SelectCodeElementAction(String name, boolean selectNext) {
        super(name);
        this.selectNext = selectNext;
        String desc = this.getShortDescription();
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        }
    }

    public String getShortDescription() {
        String shortDesc;
        String name = (String)this.getValue("Name");
        if (name == null) {
            return null;
        }
        try {
            shortDesc = NbBundle.getBundle(JavaKit.class).getString(name);
        }
        catch (MissingResourceException mre) {
            shortDesc = name;
        }
        return shortDesc;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            int selectionStartOffset = target.getSelectionStart();
            int selectionEndOffset = target.getSelectionEnd();
            if (selectionEndOffset > selectionStartOffset || this.selectNext) {
                SelectionHandler handler = (SelectionHandler)target.getClientProperty(SelectionHandler.class);
                if (handler == null) {
                    handler = new SelectionHandler(target);
                    target.addCaretListener(handler);
                    target.putClientProperty(SelectionHandler.class, handler);
                }
                if (this.selectNext) {
                    handler.selectNext();
                } else {
                    handler.selectPrevious();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectionHandler
    implements CaretListener,
    CancellableTask<CompilationController>,
    Runnable {
        private JTextComponent target;
        private SelectionInfo[] selectionInfos;
        private int selIndex = -1;
        private boolean ignoreNextCaretUpdate;

        SelectionHandler(JTextComponent target) {
            this.target = target;
        }

        public void selectNext() {
            if (this.selectionInfos == null) {
                JavaSource js = JavaSource.forDocument((Document)this.target.getDocument());
                try {
                    js.runUserActionTask((CancellableTask)this, true);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            this.run();
        }

        public synchronized void selectPrevious() {
            if (this.selIndex > 0) {
                this.select(this.selectionInfos[--this.selIndex]);
            }
        }

        private void select(SelectionInfo selectionInfo) {
            Caret caret = this.target.getCaret();
            this.markIgnoreNextCaretUpdate();
            caret.setDot(selectionInfo.getStartOffset());
            this.markIgnoreNextCaretUpdate();
            caret.moveDot(selectionInfo.getEndOffset());
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent e) {
            if (!this.ignoreNextCaretUpdate) {
                SelectionHandler selectionHandler = this;
                synchronized (selectionHandler) {
                    this.selectionInfos = null;
                    this.selIndex = -1;
                }
            }
            this.ignoreNextCaretUpdate = false;
        }

        public void cancel() {
        }

        public void run(CompilationController cc) {
            try {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                this.selectionInfos = this.initSelectionPath(this.target, cc);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        private SelectionInfo[] initSelectionPath(JTextComponent target, CompilationController ci) {
            ArrayList<SelectionInfo> positions = new ArrayList<SelectionInfo>();
            SourcePositions sp = ci.getTrees().getSourcePositions();
            TreePath tp = ci.getTreeUtilities().pathFor(target.getCaretPosition());
            for (Tree tree : tp) {
                int startPos = (int)sp.getStartPosition(tp.getCompilationUnit(), tree);
                int endPos = (int)sp.getEndPosition(tp.getCompilationUnit(), tree);
                positions.add(new SelectionInfo(startPos, endPos));
            }
            return positions.toArray(new SelectionInfo[positions.size()]);
        }

        @Override
        public void run() {
            if (this.selIndex < this.selectionInfos.length - 1) {
                this.select(this.selectionInfos[++this.selIndex]);
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;

        SelectionInfo(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

