/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorGenerator
implements CodeGenerator {
    private ElementHandle<? extends Element> constructorHandle;
    private ElementNode.Description constructorDescription;
    private ElementNode.Description fieldsDescription;

    private ConstructorGenerator(ElementHandle<? extends Element> constructorHandle, ElementNode.Description constructorDescription, ElementNode.Description fieldsDescription) {
        this.constructorHandle = constructorHandle;
        this.constructorDescription = constructorDescription;
        this.fieldsDescription = fieldsDescription;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_constructor");
    }

    @Override
    public void invoke(JTextComponent component) {
        List<ElementHandle<? extends Element>> fieldHandles;
        if (this.constructorDescription != null || this.fieldsDescription != null) {
            ConstructorPanel panel = new ConstructorPanel(this.constructorDescription, this.fieldsDescription);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_constructor"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            if (this.constructorHandle == null) {
                this.constructorHandle = panel.getInheritedConstructor();
            }
            fieldHandles = panel.getVariablesToInitialize();
        } else {
            fieldHandles = null;
        }
        JavaSource js = JavaSource.forDocument((Document)component.getDocument());
        if (js != null) {
            try {
                final int caretOffset = component.getCaretPosition();
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path);
                        int idx = 0;
                        SourcePositions sourcePositions = copy.getTrees().getSourcePositions();
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(path.getCompilationUnit(), tree) >= (long)caretOffset) break;
                            ++idx;
                        }
                        ArrayList<VariableElement> variableElements = new ArrayList<VariableElement>();
                        if (fieldHandles != null) {
                            for (ElementHandle elementHandle : fieldHandles) {
                                variableElements.add((VariableElement)elementHandle.resolve((CompilationInfo)copy));
                            }
                        }
                        GeneratorUtils.generateConstructor(copy, path, variableElements, ConstructorGenerator.this.constructorHandle != null ? (ExecutableElement)ConstructorGenerator.this.constructorHandle.resolve((CompilationInfo)copy) : null, idx);
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController controller, TreePath path) throws IOException {
            if ((path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path)) == null) {
                return Collections.emptySet();
            }
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (!typeElement.getKind().isClass()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VariableElement> initializedFields = new LinkedHashSet<VariableElement>();
            LinkedHashSet<VariableElement> uninitializedFields = new LinkedHashSet<VariableElement>();
            ArrayList<ExecutableElement> constructors = new ArrayList<ExecutableElement>();
            ArrayList<ExecutableElement> inheritedConstructors = new ArrayList<ExecutableElement>();
            TypeElement superClass = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(superClass.getEnclosedElements())) {
                inheritedConstructors.add(executableElement);
            }
            GeneratorUtils.scanForFieldsAndConstructors((CompilationInfo)controller, path, initializedFields, uninitializedFields, constructors);
            ElementHandle constructorHandle = null;
            ElementNode.Description constructorDescription = null;
            if (typeElement.getKind() != ElementKind.ENUM && inheritedConstructors.size() == 1) {
                constructorHandle = ElementHandle.create((Element)((Element)inheritedConstructors.get(0)));
            } else if (inheritedConstructors.size() > 1) {
                ArrayList<ElementNode.Description> constructorDescriptions = new ArrayList<ElementNode.Description>();
                for (ExecutableElement constructorElement : inheritedConstructors) {
                    constructorDescriptions.add(ElementNode.Description.create(constructorElement, null, true, false));
                }
                constructorDescription = ElementNode.Description.create(superClass, constructorDescriptions, false, false);
            }
            ElementNode.Description fieldsDescription = null;
            if (!uninitializedFields.isEmpty()) {
                ArrayList<ElementNode.Description> fieldDescriptions = new ArrayList<ElementNode.Description>();
                for (VariableElement variableElement : uninitializedFields) {
                    fieldDescriptions.add(ElementNode.Description.create(variableElement, null, true, false));
                }
                fieldsDescription = ElementNode.Description.create(typeElement, fieldDescriptions, false, false);
            }
            if (constructorHandle == null && constructorDescription == null && fieldsDescription == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(new ConstructorGenerator(constructorHandle, constructorDescription, fieldsDescription));
        }
    }
}

