/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.modules.java.editor.codegen.GetterSetterGenerator;
import org.netbeans.modules.java.editor.codegen.ImplementOverrideMethodGenerator;
import org.netbeans.modules.java.editor.codegen.ui.GenerateCodePanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GenerateCodeAction
extends BaseAction {
    public static final String generateCode = "generate-code";
    private CodeGenerator.Factory[] generators = new CodeGenerator.Factory[]{new ConstructorGenerator.Factory(), new GetterSetterGenerator.Factory(), new EqualsHashCodeGenerator.Factory(), new DelegateMethodGenerator.Factory(), new ImplementOverrideMethodGenerator.Factory()};

    public GenerateCodeAction() {
        super(generateCode);
        this.putValue("trimmed-text", NbBundle.getBundle(GenerateCodeAction.class).getString("generate-code-trimmed"));
        this.putValue("ShortDescription", NbBundle.getBundle(GenerateCodeAction.class).getString("desc-generate-code"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GenerateCodeAction.class).getString("popup-generate-code"));
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        try {
            JavaSource js = JavaSource.forDocument((Document)target.getDocument());
            if (js != null) {
                final int caretOffset = target.getCaretPosition();
                final ArrayList gens = new ArrayList();
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.PARSED);
                        TreePath path = controller.getTreeUtilities().pathFor(caretOffset);
                        for (CodeGenerator.Factory factory : GenerateCodeAction.this.getCodeGeneratorFactories()) {
                            for (CodeGenerator codeGenerator : factory.create(controller, path)) {
                                gens.add(codeGenerator);
                            }
                        }
                    }
                }, true);
                if (gens.size() > 0) {
                    Rectangle carretRectangle = target.modelToView(target.getCaretPosition());
                    Point where = new Point(carretRectangle.x, carretRectangle.y + carretRectangle.height);
                    SwingUtilities.convertPointToScreen(where, target);
                    GenerateCodePanel panel = new GenerateCodePanel(target, gens);
                    PopupUtil.showPopup(panel, null, where.x, where.y, true, carretRectangle.height);
                } else {
                    target.getToolkit().beep();
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
    }

    private CodeGenerator.Factory[] getCodeGeneratorFactories() {
        return this.generators;
    }

    public static final class GlobalAction
    extends MainMenuAction {
        private final JMenuItem menuPresenter = new JMenuItem(this.getMenuItemText());

        public GlobalAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(GlobalAction.class).getString("generate-code-main-menu-source-item");
        }

        protected String getActionName() {
            return GenerateCodeAction.generateCode;
        }

        public JMenuItem getMenuPresenter() {
            return this.menuPresenter;
        }
    }
}

