/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;
    private static final Set<String> SUPPORTS_OVERRIDE_SOURCE_LEVELS = new HashSet<String>();
    private static final Set<Modifier> NOT_OVERRIDABLE;

    private GeneratorUtils() {
    }

    public static ClassTree insertClassMember(WorkingCopy copy, ClassTree clazz, Tree member) {
        int idx = 0;
        for (Tree tree : clazz.getMembers()) {
            if (ClassMemberComparator.compare(member, tree) < 0) break;
            ++idx;
        }
        return copy.getTreeMaker().insertClassMember(clazz, idx, member);
    }

    public static List<? extends ExecutableElement> findUndefs(CompilationInfo info, TypeElement impl) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "findUndefs(" + info + ", " + impl + ")");
        }
        List<? extends ExecutableElement> undef = GeneratorUtils.findUndefs(info, impl, impl);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "undef=" + undef);
        }
        return undef;
    }

    public static List<? extends ExecutableElement> findOverridable(CompilationInfo info, TypeElement impl) {
        ArrayList<ExecutableElement> overridable = new ArrayList<ExecutableElement>();
        List<TypeElement> classes = GeneratorUtils.getAllClasses(impl);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "classes=" + classes);
        }
        for (TypeElement te : classes.subList(1, classes.size())) {
            for (ExecutableElement ee : ElementFilter.methodsIn(te.getEnclosedElements())) {
                EnumSet<Modifier> set = EnumSet.copyOf(NOT_OVERRIDABLE);
                set.removeAll(ee.getModifiers());
                if (set.size() != NOT_OVERRIDABLE.size()) continue;
                int thisElement = classes.indexOf(te);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "ee=" + ee);
                    ERR.log(1, "thisElement = " + thisElement);
                    ERR.log(1, "classes.subList(0, thisElement + 1)=" + classes.subList(0, thisElement + 1));
                    ERR.log(1, "isOverriden(info, ee, classes.subList(0, thisElement + 1))=" + GeneratorUtils.isOverriden(info, ee, classes.subList(0, thisElement + 1)));
                }
                if (GeneratorUtils.isOverriden(info, ee, classes.subList(0, thisElement + 1))) continue;
                overridable.add(ee);
            }
        }
        return overridable;
    }

    public static Map<? extends TypeElement, ? extends List<? extends VariableElement>> findAllAccessibleFields(CompilationInfo info, TypeElement clazz) {
        HashMap<TypeElement, List<? extends VariableElement>> result = new HashMap<TypeElement, List<? extends VariableElement>>();
        result.put(clazz, GeneratorUtils.findAllAccessibleFields(info, clazz, clazz));
        for (TypeElement te : GeneratorUtils.getAllParents(clazz)) {
            result.put(te, GeneratorUtils.findAllAccessibleFields(info, clazz, te));
        }
        return result;
    }

    public static void scanForFieldsAndConstructors(CompilationInfo info, TreePath clsPath, final Set<VariableElement> initializedFields, final Set<VariableElement> uninitializedFields, final List<ExecutableElement> constructors) {
        final Trees trees = info.getTrees();
        new TreePathScanner<Void, Boolean>(){

            @Override
            public Void visitVariable(VariableTree node, Boolean p) {
                Element el = trees.getElement(this.getCurrentPath());
                if (el != null && el.getKind() == ElementKind.FIELD && !el.getModifiers().contains((Object)Modifier.STATIC) && node.getInitializer() == null && !initializedFields.remove(el)) {
                    uninitializedFields.add((VariableElement)el);
                }
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Boolean p) {
                Element el = trees.getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (el != null && el.getKind() == ElementKind.FIELD && !uninitializedFields.remove(el)) {
                    initializedFields.add((VariableElement)el);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Boolean p) {
                return p != false ? (Void)super.visitClass(node, false) : null;
            }

            @Override
            public Void visitMethod(MethodTree node, Boolean p) {
                Element el = trees.getElement(this.getCurrentPath());
                if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                    constructors.add((ExecutableElement)el);
                }
                return null;
            }
        }.scan(clsPath, Boolean.TRUE);
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<? extends Tree> members = new ArrayList<Tree>(clazz.getMembers());
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs((CompilationInfo)wc, te, te)) {
                members.add(GeneratorUtils.createMethodImplementation(wc, executableElement, (DeclaredType)te.asType()));
            }
            ClassTree nue = make.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), members);
            wc.rewrite((Tree)clazz, (Tree)nue);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<? extends Tree> members = new ArrayList<Tree>(clazz.getMembers());
            ArrayList<MethodTree> methods = new ArrayList<MethodTree>();
            for (ExecutableElement executableElement : elements) {
                methods.add(GeneratorUtils.createMethodImplementation(wc, executableElement, (DeclaredType)te.asType()));
            }
            members.addAll(index, methods);
            ClassTree nue = make.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), members);
            wc.rewrite((Tree)clazz, (Tree)nue);
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy wc, TreePath path, ExecutableElement element, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree decl = wc.getTreeMaker().insertClassMember((ClassTree)path.getLeaf(), index, (Tree)GeneratorUtils.createMethodImplementation(wc, element, (DeclaredType)te.asType()));
            wc.rewrite(path.getLeaf(), (Tree)decl);
        }
    }

    public static void generateMethodOverrides(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<? extends Tree> members = new ArrayList<Tree>(clazz.getMembers());
            ArrayList<MethodTree> methods = new ArrayList<MethodTree>();
            for (ExecutableElement executableElement : elements) {
                methods.add(GeneratorUtils.createMethodImplementation(wc, executableElement, (DeclaredType)te.asType()));
            }
            members.addAll(index, methods);
            ClassTree nue = make.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), members);
            wc.rewrite((Tree)clazz, (Tree)nue);
        }
    }

    public static void generateMethodOverride(WorkingCopy wc, TreePath path, ExecutableElement element, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree decl = wc.getTreeMaker().insertClassMember((ClassTree)path.getLeaf(), index, (Tree)GeneratorUtils.createMethodImplementation(wc, element, (DeclaredType)te.asType()));
            wc.rewrite(path.getLeaf(), (Tree)decl);
        }
    }

    public static void generateConstructor(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, ExecutableElement inheritedConstructor, int index) {
        TreeMaker make = wc.getTreeMaker();
        ClassTree clazz = (ClassTree)path.getLeaf();
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        if (inheritedConstructor != null && !inheritedConstructor.getParameters().isEmpty()) {
            ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : inheritedConstructor.getParameters()) {
                parameters.add(make.Variable(parameterModifiers, (CharSequence)variableElement.getSimpleName(), make.Type(variableElement.asType()), null));
                arguments.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            statements.add(make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)"super"), arguments)));
        }
        for (VariableElement variableElement : initFields) {
            parameters.add(make.Variable(parameterModifiers, (CharSequence)variableElement.getSimpleName(), make.Type(variableElement.asType()), null));
            statements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Identifier((CharSequence)variableElement.getSimpleName()))));
        }
        BlockTree body = make.Block(statements, false);
        ClassTree classTree = make.insertClassMember(clazz, index, (Tree)make.Method(make.Modifiers(EnumSet.of(wc.getTreeUtilities().isEnum(clazz) ? Modifier.PRIVATE : Modifier.PUBLIC)), (CharSequence)"<init>", null, Collections.emptyList(), parameters, Collections.emptyList(), body, null));
        wc.rewrite(path.getLeaf(), (Tree)classTree);
    }

    public static void generateGettersAndSetters(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> fields, int type, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<? extends Tree> members = new ArrayList<Tree>(clazz.getMembers());
            ArrayList<MethodTree> methods = new ArrayList<MethodTree>();
            for (VariableElement variableElement : fields) {
                if (type != 2) {
                    methods.add(GeneratorUtils.createGetterMethod(wc, variableElement, (DeclaredType)te.asType()));
                }
                if (type == 1) continue;
                methods.add(GeneratorUtils.createSetterMethod(wc, variableElement, (DeclaredType)te.asType()));
            }
            members.addAll(index, methods);
            ClassTree nue = make.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), members);
            wc.rewrite((Tree)clazz, (Tree)nue);
        }
    }

    public static boolean hasGetter(CompilationInfo info, VariableElement field, Map<String, List<ExecutableElement>> methods) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        StringBuilder sb = new StringBuilder();
        sb.append(type.getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(sb.toString());
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (!candidate.getParameters().isEmpty() || !types.isSameType(candidate.getReturnType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSetter(CompilationInfo info, VariableElement field, Map<String, List<ExecutableElement>> methods) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        StringBuilder sb = new StringBuilder();
        sb.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(sb.toString());
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (candidate.getReturnType().getKind() != TypeKind.VOID || candidate.getParameters().size() != 1 || !types.isSameType(candidate.getParameters().get(0).asType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    private static MethodTree createMethodImplementation(WorkingCopy wc, ExecutableElement element, DeclaredType type) {
        BlockTree body;
        TreeMaker make = wc.getTreeMaker();
        Set<Modifier> mods = element.getModifiers();
        EnumSet<Modifier> flags = mods.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mods);
        boolean isAbstract = flags.remove((Object)Modifier.ABSTRACT);
        flags.remove((Object)Modifier.NATIVE);
        ExecutableType et = (ExecutableType)wc.getTypes().asMemberOf(type, element);
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (typeMirror.getKind() == TypeKind.NULL || typeMirror.getKind() == TypeKind.DECLARED && "java.lang.Object".contentEquals(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName())) continue;
                bounds.add((ExpressionTree)make.Type(typeMirror));
            }
            typeParams.add(make.TypeParameter((CharSequence)typeParameterElement.getSimpleName(), bounds));
        }
        Tree returnType = make.Type(et.getReturnType());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        boolean isVarArgs = element.isVarArgs();
        Iterator<? extends VariableElement> formArgNames = element.getParameters().iterator();
        Iterator<? extends TypeMirror> iterator = et.getParameterTypes().iterator();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        while (formArgNames.hasNext() && iterator.hasNext()) {
            VariableElement formArgName = formArgNames.next();
            TypeMirror formArgType = iterator.next();
            if (isVarArgs && !formArgNames.hasNext()) {
                parameterModifiers = make.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList.add(make.Variable(parameterModifiers, (CharSequence)formArgName.getSimpleName(), make.Type(formArgType), null));
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : et.getThrownTypes()) {
            throwsList.add((ExpressionTree)make.Type(typeMirror));
        }
        ArrayList<AnnotationTree> arrayList2 = new ArrayList<AnnotationTree>();
        if (isAbstract) {
            ArrayList<ThrowTree> blockStatements = new ArrayList<ThrowTree>();
            TypeElement uoe = wc.getElements().getTypeElement("java.lang.UnsupportedOperationException");
            if (uoe != null) {
                NewClassTree newClassTree = make.NewClass(null, Collections.emptyList(), make.QualIdent((Element)uoe), Collections.singletonList(make.Literal((Object)"Not supported yet.")), null);
                blockStatements.add(make.Throw((ExpressionTree)newClassTree));
            }
            body = make.Block(blockStatements, false);
        } else {
            ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : element.getParameters()) {
                arguments.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            MethodInvocationTree inv = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"super"), (CharSequence)element.getSimpleName()), arguments);
            StatementTree statementTree = wc.getTypes().getNoType(TypeKind.VOID) == element.getReturnType() ? make.ExpressionStatement((ExpressionTree)inv) : make.Return((ExpressionTree)inv);
            body = make.Block(Collections.singletonList(statementTree), false);
            if (GeneratorUtils.supportsOverride(wc.getFileObject())) {
                arrayList2.add(make.Annotation((Tree)make.Identifier((CharSequence)"Override"), Collections.emptyList()));
            }
        }
        return make.Method(make.Modifiers(flags, arrayList2), (CharSequence)element.getSimpleName(), returnType, typeParams, arrayList, throwsList, body, null);
    }

    private static MethodTree createGetterMethod(WorkingCopy wc, VariableElement element, DeclaredType type) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        Name name = element.getSimpleName();
        assert (name.length() > 0);
        StringBuilder sb = new StringBuilder();
        sb.append(element.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        BlockTree body = make.Block(Collections.singletonList(make.Return((ExpressionTree)make.Identifier((CharSequence)element.getSimpleName()))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(element.asType()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    private static MethodTree createSetterMethod(WorkingCopy wc, VariableElement element, DeclaredType type) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = element.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        Name name = element.getSimpleName();
        assert (name.length() > 0);
        StringBuilder sb = new StringBuilder();
        sb.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)element.getSimpleName(), make.Type(element.asType()), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier((CharSequence)element.getEnclosingElement().getSimpleName()) : make.Identifier((CharSequence)"this")), (CharSequence)element.getSimpleName()), (ExpressionTree)make.Identifier((CharSequence)element.getSimpleName())))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type((TypeMirror)wc.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    private static List<? extends ExecutableElement> findUndefs(CompilationInfo info, TypeElement impl, TypeElement element) {
        ArrayList<ExecutableElement> undef = new ArrayList<ExecutableElement>();
        ElementUtilities eu = info.getElementUtilities();
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element element2 : element.getEnclosedElements()) {
                ExecutableElement ee;
                Element element3;
                if (element2.getKind() != ElementKind.METHOD || !element2.getModifiers().contains((Object)Modifier.ABSTRACT) || (element3 = eu.getImplementationOf(ee = (ExecutableElement)element2, impl)) != null && element3 != ee) continue;
                undef.add(ee);
            }
        }
        Types types = info.getTypes();
        DeclaredType declaredType = (DeclaredType)impl.asType();
        for (TypeMirror typeMirror : types.directSupertypes(element.asType())) {
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs(info, impl, (TypeElement)((DeclaredType)typeMirror).asElement())) {
                boolean exists = false;
                TypeMirror eeType = types.asMemberOf(declaredType, executableElement);
                for (ExecutableElement existing : undef) {
                    TypeMirror existingType;
                    if (!existing.getSimpleName().contentEquals(executableElement.getSimpleName()) || !types.isSameType(eeType, existingType = types.asMemberOf(declaredType, existing))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                undef.add(executableElement);
            }
        }
        return undef;
    }

    private static List<? extends VariableElement> findAllAccessibleFields(CompilationInfo info, TypeElement accessibleFrom, TypeElement toScan) {
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        for (VariableElement ve : ElementFilter.fieldsIn(toScan.getEnclosedElements())) {
            if (ve.getModifiers().contains((Object)Modifier.PUBLIC)) {
                result.add(ve);
                continue;
            }
            if (ve.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (accessibleFrom != toScan) continue;
                result.add(ve);
                continue;
            }
            if (!ve.getModifiers().contains((Object)Modifier.PROTECTED) || !GeneratorUtils.getAllParents(accessibleFrom).contains(toScan)) continue;
            result.add(ve);
        }
        return result;
    }

    public static Collection<TypeElement> getAllParents(TypeElement of) {
        TypeElement typeElement;
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : of.getInterfaces()) {
            TypeElement te2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (te2 != null) {
                result.add(te2);
                result.addAll(GeneratorUtils.getAllParents(te2));
                continue;
            }
            if (!ERR.isLoggable(1)) continue;
            ERR.log(1, "te=null, t=" + typeMirror);
        }
        TypeMirror sup = of.getSuperclass();
        TypeElement typeElement2 = typeElement = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        if (typeElement != null) {
            result.add(typeElement);
            result.addAll(GeneratorUtils.getAllParents(typeElement));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    public static boolean supportsOverride(FileObject file) {
        return SUPPORTS_OVERRIDE_SOURCE_LEVELS.contains(SourceLevelQuery.getSourceLevel((FileObject)file));
    }

    private static List<TypeElement> getAllClasses(TypeElement of) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeMirror sup = of.getSuperclass();
        TypeElement te = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        result.add(of);
        if (te != null) {
            result.addAll(GeneratorUtils.getAllClasses(te));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    private static boolean isOverriden(CompilationInfo info, ExecutableElement methodBase, List<TypeElement> classes) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "isOverriden(" + info + ", " + methodBase + ", " + classes + ")");
        }
        for (TypeElement impl : classes) {
            for (ExecutableElement methodImpl : ElementFilter.methodsIn(impl.getEnclosedElements())) {
                if (ERR.isLoggable(1) && info.getElements().overrides(methodImpl, methodBase, impl)) {
                    ERR.log(1, "overrides:");
                    ERR.log(1, "impl=" + impl);
                    ERR.log(1, "methodImpl=" + methodImpl);
                }
                if (!info.getElements().overrides(methodImpl, methodBase, impl)) continue;
                return true;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "no overriding methods overrides:");
        }
        return false;
    }

    public static boolean isAccessible(TypeElement from, Element what) {
        TypeElement whatTopLevel;
        if (what.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        TypeElement fromTopLevel = SourceUtils.getOutermostEnclosingTypeElement((Element)from);
        if (fromTopLevel.equals(whatTopLevel = SourceUtils.getOutermostEnclosingTypeElement((Element)what))) {
            return true;
        }
        if (what.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (what.getModifiers().contains((Object)Modifier.PROTECTED) && GeneratorUtils.getAllClasses(fromTopLevel).contains(SourceUtils.getEnclosingTypeElement((Element)what))) {
            return true;
        }
        return ((PackageElement)fromTopLevel.getEnclosingElement()).getQualifiedName().toString().contentEquals(((PackageElement)whatTopLevel.getEnclosingElement()).getQualifiedName());
    }

    static {
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.5");
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.6");
        NOT_OVERRIDABLE = EnumSet.of(Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL);
    }

    private static class ClassMemberComparator {
        private ClassMemberComparator() {
        }

        public static int compare(Tree tree1, Tree tree2) {
            if (tree1 == tree2) {
                return 0;
            }
            int importanceDiff = ClassMemberComparator.getSortPriority(tree1) - ClassMemberComparator.getSortPriority(tree2);
            if (importanceDiff != 0) {
                return importanceDiff;
            }
            int alphabeticalDiff = ClassMemberComparator.getSortText(tree1).compareTo(ClassMemberComparator.getSortText(tree2));
            if (alphabeticalDiff != 0) {
                return alphabeticalDiff;
            }
            return -1;
        }

        private static int getSortPriority(Tree tree) {
            int ret = 0;
            ModifiersTree modifiers = null;
            switch (tree.getKind()) {
                case CLASS: {
                    ret = 400;
                    modifiers = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree mt = (MethodTree)tree;
                    ret = mt.getName().contentEquals("<init>") ? 200 : 300;
                    modifiers = mt.getModifiers();
                    break;
                }
                case VARIABLE: {
                    ret = 100;
                    modifiers = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiers != null) {
                if (!modifiers.getFlags().contains((Object)Modifier.STATIC)) {
                    ret += 1000;
                }
                ret = modifiers.getFlags().contains((Object)Modifier.PUBLIC) ? (ret += 10) : (modifiers.getFlags().contains((Object)Modifier.PROTECTED) ? (ret += 20) : (modifiers.getFlags().contains((Object)Modifier.PRIVATE) ? (ret += 40) : (ret += 30)));
            }
            return ret;
        }

        private static String getSortText(Tree tree) {
            switch (tree.getKind()) {
                case CLASS: {
                    return ((ClassTree)tree).getSimpleName().toString();
                }
                case METHOD: {
                    MethodTree mt = (MethodTree)tree;
                    StringBuilder sortParams = new StringBuilder();
                    sortParams.append('(');
                    int cnt = 0;
                    Iterator<? extends VariableTree> it = mt.getParameters().iterator();
                    while (it.hasNext()) {
                        VariableTree param = it.next();
                        if (param.getType().getKind() == Tree.Kind.IDENTIFIER) {
                            sortParams.append(((IdentifierTree)param.getType()).getName().toString());
                        } else if (param.getType().getKind() == Tree.Kind.MEMBER_SELECT) {
                            sortParams.append(((MemberSelectTree)param.getType()).getIdentifier().toString());
                        }
                        if (it.hasNext()) {
                            sortParams.append(',');
                        }
                        ++cnt;
                    }
                    sortParams.append(')');
                    return mt.getName().toString() + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
                }
                case VARIABLE: {
                    return ((VariableTree)tree).getName().toString();
                }
            }
            return "";
        }
    }
}

