/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.Icon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class ElementNode
extends AbstractNode {
    private Description description;
    private boolean singleSelection;

    public ElementNode(Description description) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs)), Lookups.singleton((Object)description));
        this.description = description;
        description.node = this;
        this.setDisplayName(description.name);
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }

    public Image getIcon(int type) {
        if (this.description.elementHandle == null) {
            return super.getIcon(type);
        }
        return Utilities.icon2Image((Icon)UiUtils.getElementIcon((ElementKind)this.description.elementHandle.getKind(), (Collection)this.description.modifiers));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public void assureSingleSelection() {
        Description d;
        Node pn = this.getParentNode();
        if (pn == null && this.singleSelection) {
            this.description.deepSetSelected(false);
        } else if (pn != null && (d = (Description)pn.getLookup().lookup(Description.class)) != null) {
            d.node.assureSingleSelection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Description {
        private ElementNode node;
        private String name;
        private ElementHandle<? extends Element> elementHandle;
        private Set<Modifier> modifiers;
        private List<Description> subs;
        private String htmlHeader;
        private boolean isSelected;
        private boolean isSelectable;

        public static Description create(List<Description> subs) {
            return new Description("<root>", null, null, subs, null, false, false);
        }

        public static Description create(Element element, List<Description> subs, boolean isSelectable, boolean isSelected) {
            String htmlHeader = null;
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    htmlHeader = Description.createHtmlHeader((TypeElement)element);
                    break;
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    htmlHeader = Description.createHtmlHeader((VariableElement)element);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    htmlHeader = Description.createHtmlHeader((ExecutableElement)element);
                }
            }
            return new Description(element.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)element), element.getModifiers(), subs, htmlHeader, isSelectable, isSelected);
        }

        private Description(String name, ElementHandle<? extends Element> elementHandle, Set<Modifier> modifiers, List<Description> subs, String htmlHeader, boolean isSelectable, boolean isSelected) {
            this.name = name;
            this.elementHandle = elementHandle;
            this.modifiers = modifiers;
            this.subs = subs;
            this.htmlHeader = htmlHeader;
            this.isSelectable = isSelectable;
            this.isSelected = isSelected;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public List<Description> getSubs() {
            return this.subs;
        }

        public void setSelected(boolean selected) {
            if (selected && this.node != null) {
                this.node.assureSingleSelection();
            }
            this.isSelected = selected;
            if (this.node != null) {
                this.node.fireDisplayNameChange(null, null);
            }
        }

        public void deepSetSelected(boolean value) {
            if (this.isSelectable() && value != this.isSelected()) {
                this.setSelected(value);
            }
            if (this.subs != null) {
                for (Description s : this.subs) {
                    s.deepSetSelected(value);
                }
            }
        }

        public ElementHandle<? extends Element> getElementHandle() {
            return this.elementHandle;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (!this.name.equals(d.name)) {
                return false;
            }
            if (this.elementHandle != d.elementHandle) {
                if (this.elementHandle == null || d.elementHandle == null) {
                    return false;
                }
                if (this.elementHandle.getKind() != d.elementHandle.getKind()) {
                    return false;
                }
                if (!this.elementHandle.signatureEquals(d.elementHandle)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.elementHandle != null ? this.elementHandle.getKind().hashCode() : 0);
            return hash;
        }

        public static Description deepCopy(Description d) {
            ArrayList<Description> subsCopy;
            if (d.subs == null) {
                subsCopy = null;
            } else {
                subsCopy = new ArrayList<Description>(d.subs.size());
                for (Description s : d.subs) {
                    subsCopy.add(Description.deepCopy(s));
                }
            }
            return new Description(d.name, d.elementHandle, d.modifiers, subsCopy, d.htmlHeader, d.isSelectable, d.isSelected);
        }

        private static String createHtmlHeader(ExecutableElement e) {
            TypeMirror rt;
            StringBuilder sb = new StringBuilder();
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(e.getEnclosingElement().getSimpleName());
            } else {
                sb.append(e.getSimpleName());
            }
            sb.append("(");
            Iterator<? extends VariableElement> it = e.getParameters().iterator();
            while (it.hasNext()) {
                VariableElement param = it.next();
                sb.append(Description.print(param.asType()));
                sb.append(" ");
                sb.append(param.getSimpleName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
                sb.append(" : ");
                sb.append(Description.print(e.getReturnType()));
            }
            return sb.toString();
        }

        private static String createHtmlHeader(VariableElement e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getSimpleName());
            if (e.getKind() != ElementKind.ENUM_CONSTANT) {
                sb.append(" : ");
                sb.append(Description.print(e.asType()));
            }
            return sb.toString();
        }

        private static String createHtmlHeader(TypeElement e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getSimpleName());
            List<? extends TypeParameterElement> typeParams = e.getTypeParameters();
            if (typeParams != null && !typeParams.isEmpty()) {
                sb.append("<");
                Iterator<? extends TypeParameterElement> it = typeParams.iterator();
                while (it.hasNext()) {
                    TypeParameterElement tp = it.next();
                    sb.append(tp.getSimpleName());
                    try {
                        List<? extends TypeMirror> bounds = tp.getBounds();
                        if (!bounds.isEmpty()) {
                            sb.append(Description.printBounds(bounds));
                        }
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(">");
            }
            return sb.toString();
        }

        private static String printBounds(List<? extends TypeMirror> bounds) {
            if (bounds.size() == 1 && "java.lang.Object".equals(((Object)bounds.get(0)).toString())) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" extends ");
            Iterator<? extends TypeMirror> it = bounds.iterator();
            while (it.hasNext()) {
                TypeMirror bound = it.next();
                sb.append(Description.print(bound));
                if (!it.hasNext()) continue;
                sb.append(" & ");
            }
            return sb.toString();
        }

        private static String print(TypeMirror tm) {
            switch (tm.getKind()) {
                case DECLARED: {
                    DeclaredType dt = (DeclaredType)tm;
                    StringBuilder sb = new StringBuilder(dt.asElement().getSimpleName().toString());
                    List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                    if (!typeArgs.isEmpty()) {
                        sb.append("<");
                        Iterator<? extends TypeMirror> it = typeArgs.iterator();
                        while (it.hasNext()) {
                            TypeMirror ta = it.next();
                            sb.append(Description.print(ta));
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        sb.append(">");
                    }
                    return sb.toString();
                }
                case TYPEVAR: {
                    TypeVariable tv = (TypeVariable)tm;
                    StringBuilder sb = new StringBuilder(tv.asElement().getSimpleName().toString());
                    return sb.toString();
                }
                case ARRAY: {
                    ArrayType at = (ArrayType)tm;
                    StringBuilder sb = new StringBuilder(Description.print(at.getComponentType()));
                    sb.append("[]");
                    return sb.toString();
                }
                case WILDCARD: {
                    WildcardType wt = (WildcardType)tm;
                    StringBuilder sb = new StringBuilder("?");
                    if (wt.getExtendsBound() != null) {
                        sb.append(" extends ");
                        sb.append(Description.print(wt.getExtendsBound()));
                    }
                    if (wt.getSuperBound() != null) {
                        sb.append(" super ");
                        sb.append(Description.print(wt.getSuperBound()));
                    }
                    return sb.toString();
                }
            }
            return ((Object)tm).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> descriptions) {
            this.setKeys(descriptions);
        }

        protected Node[] createNodes(Description key) {
            return new Node[]{new ElementNode(key)};
        }
    }
}

