/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateCodePanel
extends JPanel {
    private JTextComponent component;
    public JLabel jLabel1;
    public JList jList1;
    public JScrollPane jScrollPane1;

    public GenerateCodePanel(JTextComponent component, List<? extends CodeGenerator> generators) {
        this.component = component;
        this.initComponents();
        this.setFocusable(false);
        this.setNextFocusableComponent(this.jList1);
        this.setBackground(this.jList1.getBackground());
        this.jScrollPane1.setBackground(this.jList1.getBackground());
        this.jList1.setModel(this.createModel(generators));
        this.jList1.setSelectedIndex(0);
        this.jList1.setVisibleRowCount(generators.size() > 8 ? 8 : generators.size());
        this.jList1.setCellRenderer(new Renderer(this.jList1));
        this.jList1.grabFocus();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(64, 64, 64)));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                GenerateCodePanel.this.listKeyReleased(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                GenerateCodePanel.this.listMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText(NbBundle.getMessage(CodeGenerator.class, (String)"LBL_generate_code"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, "First");
    }

    private void listMouseReleased(MouseEvent evt) {
        this.invokeSelected();
    }

    private void listKeyReleased(KeyEvent evt) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(evt);
        if (ks.getKeyCode() == 10 || ks.getKeyCode() == 32) {
            this.invokeSelected();
        }
    }

    private DefaultListModel createModel(List<? extends CodeGenerator> generators) {
        DefaultListModel<CodeGenerator> model = new DefaultListModel<CodeGenerator>();
        for (CodeGenerator codeGenerator : generators) {
            model.addElement(codeGenerator);
        }
        return model;
    }

    private void invokeSelected() {
        PopupUtil.hidePopup();
        Object value = this.jList1.getSelectedValue();
        if (value instanceof CodeGenerator) {
            ((CodeGenerator)value).invoke(this.component);
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static int DARKER_COLOR_COMPONENT = 5;
        private Color fgColor;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        public Renderer(JList list) {
            this.setFont(list.getFont());
            this.fgColor = list.getForeground();
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (isSelected) {
                this.setForeground(this.fgSelectionColor);
                this.setBackground(this.bgSelectionColor);
            } else {
                this.setForeground(this.fgColor);
                this.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            this.setText(value instanceof CodeGenerator ? ((CodeGenerator)value).getDisplayName() : value.toString());
            return this;
        }
    }
}

