/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeImports {
    private static final String ERROR = "<error>";
    private boolean cancelled;
    private TreeVisitorImpl visitor;
    private static EnumSet<TypeKind> INVALID_TYPES = EnumSet.of(TypeKind.NULL, TypeKind.NONE, TypeKind.OTHER, TypeKind.ERROR);

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.visitor != null) {
            this.visitor.cancel();
        }
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> computeCandidates(CompilationInfo info) {
        return this.computeCandidates(info, Collections.<String>emptySet());
    }

    private synchronized void setVisitor(TreeVisitorImpl visitor) {
        this.visitor = visitor;
    }

    Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> computeCandidates(CompilationInfo info, Set<String> forcedUnresolved) {
        HashMap<String, List<TypeElement>> candidates = new HashMap<String, List<TypeElement>>();
        HashMap<String, List<TypeElement>> notFilteredCandidates = new HashMap<String, List<TypeElement>>();
        TreeVisitorImpl v = new TreeVisitorImpl(info);
        this.setVisitor(v);
        v.scan(info.getCompilationUnit(), new HashMap());
        this.setVisitor(null);
        HashSet<String> unresolvedNames = new HashSet<String>(v.unresolved);
        unresolvedNames.addAll(forcedUnresolved);
        for (String unresolved : unresolvedNames) {
            if (this.isCancelled()) {
                return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(Collections.emptyMap(), Collections.emptyMap());
            }
            ArrayList<TypeElement> classes = new ArrayList<TypeElement>();
            for (ElementHandle typeNames : info.getJavaSource().getClasspathInfo().getClassIndex().getDeclaredTypes(unresolved, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                TypeElement te = info.getElements().getTypeElement(typeNames.getQualifiedName());
                if (te == null) {
                    Logger.getLogger(ComputeImports.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + typeNames + "\".");
                    continue;
                }
                classes.add(te);
            }
            Collections.sort(classes, new Comparator<TypeElement>(){

                @Override
                public int compare(TypeElement te1, TypeElement te2) {
                    return te1 == te2 ? 0 : te1.getQualifiedName().toString().compareTo(te2.getQualifiedName().toString());
                }
            });
            candidates.put(unresolved, new ArrayList(classes));
            notFilteredCandidates.put(unresolved, classes);
        }
        boolean wasChanged = true;
        while (wasChanged) {
            if (this.isCancelled()) {
                return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(Collections.emptyMap(), Collections.emptyMap());
            }
            wasChanged = false;
            for (Hint hint : v.hints) {
                wasChanged |= hint.filter(info, notFilteredCandidates, candidates);
            }
        }
        return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(candidates, notFilteredCandidates);
    }

    private static boolean filter(Types types, List<TypeElement> left, List<TypeElement> right, boolean leftReadOnly, boolean rightReadOnly) {
        boolean changed = false;
        HashMap validPairs = new HashMap();
        for (TypeElement l : left) {
            ArrayList<TypeElement> valid = new ArrayList<TypeElement>();
            for (TypeElement r : right) {
                TypeMirror t1 = types.erasure(l.asType());
                TypeMirror t2 = types.erasure(r.asType());
                if (!types.isAssignable(t2, t1)) continue;
                valid.add(r);
            }
            validPairs.put(l, valid);
        }
        HashSet validRights = new HashSet();
        for (TypeElement l : validPairs.keySet()) {
            List valid = (List)validPairs.get(l);
            if (valid.isEmpty() && !leftReadOnly) {
                left.remove(l);
                changed = true;
            }
            validRights.addAll(valid);
        }
        if (!rightReadOnly) {
            changed = right.retainAll(validRights) | changed;
        }
        return changed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AccessibleHint
    implements Hint {
        private String simpleName;
        private Scope scope;

        public AccessibleHint(String simpleName, Scope scope) {
            this.simpleName = simpleName;
            this.scope = scope;
        }

        @Override
        public boolean filter(CompilationInfo info, Map<String, List<TypeElement>> rawCandidates, Map<String, List<TypeElement>> candidates) {
            List<TypeElement> cands = candidates.get(this.simpleName);
            if (cands == null || cands.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> toRemove = new ArrayList<TypeElement>();
            for (TypeElement te : cands) {
                if (info.getTrees().isAccessible(this.scope, te)) continue;
                toRemove.add(te);
            }
            rawCandidates.get(this.simpleName).removeAll(toRemove);
            return cands.removeAll(toRemove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnclosedHint
    implements Hint {
        private String simpleName;
        private String methodName;
        private boolean allowPrefix;

        public EnclosedHint(String simpleName, String methodName, boolean allowPrefix) {
            this.simpleName = simpleName;
            this.methodName = methodName;
            this.allowPrefix = allowPrefix;
        }

        @Override
        public boolean filter(CompilationInfo info, Map<String, List<TypeElement>> rawCandidates, Map<String, List<TypeElement>> candidates) {
            List<TypeElement> cands = candidates.get(this.simpleName);
            if (cands == null || cands.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> toRemove = new ArrayList<TypeElement>();
            for (TypeElement te : cands) {
                boolean found = false;
                for (Element element : te.getEnclosedElements()) {
                    String simpleName = element.getSimpleName().toString();
                    if (this.methodName.contentEquals(simpleName)) {
                        found = true;
                        break;
                    }
                    if (!this.allowPrefix || !simpleName.startsWith(this.methodName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(te);
            }
            return cands.removeAll(toRemove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Hint {
        public boolean filter(CompilationInfo var1, Map<String, List<TypeElement>> var2, Map<String, List<TypeElement>> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeVisitorImpl
    extends CancellableTreePathScanner<Void, Map<String, Object>> {
        private CompilationInfo info;
        private Set<String> unresolved;
        private List<Hint> hints;

        public TreeVisitorImpl(CompilationInfo info) {
            this.info = info;
            this.unresolved = new HashSet<String>();
            this.hints = new ArrayList<Hint>();
        }

        public Void visitMemberSelect(MemberSelectTree tree, Map<String, Object> p) {
            if (tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                p.put("request", null);
            }
            this.scan(tree.getExpression(), p);
            Union2 leftSide = (Union2)p.remove("result");
            p.remove("request");
            if (leftSide != null && leftSide.hasFirst()) {
                boolean isMethodInvocation;
                String rightSide = tree.getIdentifier().toString();
                if (ComputeImports.ERROR.equals(rightSide)) {
                    rightSide = "";
                }
                boolean bl = isMethodInvocation = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION;
                if (!"class".equals(rightSide)) {
                    this.hints.add(new EnclosedHint((String)leftSide.first(), rightSide, !isMethodInvocation));
                }
            }
            return null;
        }

        public Void visitVariable(VariableTree tree, Map<String, Object> p) {
            this.scan(tree.getModifiers(), p);
            if (tree.getType().getKind() == Tree.Kind.IDENTIFIER) {
                p.put("request", null);
            }
            this.scan(tree.getType(), p);
            Union2 leftSide = (Union2)p.remove("result");
            p.remove("request");
            Union2 rightSide = null;
            if (leftSide != null && tree.getInitializer() != null) {
                TypeMirror rightType;
                Element el = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree.getInitializer()));
                TypeMirror typeMirror = rightType = el != null ? el.asType() : null;
                if (rightType != null && rightType.getKind() == TypeKind.DECLARED) {
                    rightSide = Union2.createSecond((Object)((DeclaredType)rightType));
                } else if (tree.getInitializer().getKind() == Tree.Kind.NEW_CLASS || tree.getInitializer().getKind() == Tree.Kind.NEW_ARRAY) {
                    p.put("request", null);
                }
            }
            this.scan(tree.getInitializer(), p);
            rightSide = rightSide == null ? (Union2)p.remove("result") : rightSide;
            p.remove("result");
            p.remove("request");
            if (!(leftSide == null || rightSide == null || leftSide instanceof TypeMirror && rightSide instanceof TypeMirror)) {
                this.hints.add(new TypeHint((Union2<String, DeclaredType>)leftSide, (Union2<String, DeclaredType>)rightSide));
            }
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, Map<String, Object> p) {
            super.visitIdentifier(tree, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && (el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.PACKAGE)) {
                TypeMirror type = el.asType();
                String simpleName = null;
                if (type.getKind() == TypeKind.ERROR) {
                    simpleName = el.getSimpleName().toString();
                }
                if (type.getKind() == TypeKind.PACKAGE) {
                    String s = ((PackageElement)el).getQualifiedName().toString();
                    if (this.info.getElements().getPackageElement(s) == null) {
                        simpleName = el.getSimpleName().toString();
                    }
                }
                if (ComputeImports.ERROR.equals(simpleName)) {
                    simpleName = null;
                }
                if (simpleName != null) {
                    this.unresolved.add(simpleName);
                    Scope currentScope = this.info.getTrees().getScope(this.getCurrentPath());
                    this.hints.add(new AccessibleHint(simpleName, currentScope));
                    if (p.containsKey("request")) {
                        p.put("result", Union2.createFirst((Object)simpleName));
                    }
                } else if (p.containsKey("request") && type.getKind() == TypeKind.DECLARED) {
                    p.put("result", Union2.createSecond((Object)((DeclaredType)type)));
                }
            }
            p.remove("request");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TypeHint
    implements Hint {
        private Union2<String, DeclaredType> left;
        private Union2<String, DeclaredType> right;

        public TypeHint(Union2<String, DeclaredType> left, Union2<String, DeclaredType> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean filter(CompilationInfo info, Map<String, List<TypeElement>> rawCandidates, Map<String, List<TypeElement>> candidates) {
            Element el;
            List<TypeElement> left = null;
            List<TypeElement> right = null;
            boolean leftReadOnly = false;
            boolean rightReadOnly = false;
            if (this.left.hasSecond()) {
                el = ((DeclaredType)this.left.second()).asElement();
                if (el instanceof TypeElement) {
                    left = Collections.singletonList((TypeElement)el);
                    leftReadOnly = true;
                }
            } else {
                left = candidates.get(this.left.first());
            }
            if (this.right.hasSecond()) {
                el = ((DeclaredType)this.right.second()).asElement();
                if (el instanceof TypeElement) {
                    right = Collections.singletonList((TypeElement)el);
                    rightReadOnly = true;
                }
            } else {
                right = candidates.get(this.right.first());
            }
            if (left != null && right != null && !left.isEmpty() && !right.isEmpty()) {
                return ComputeImports.filter(info.getTypes(), left, right, leftReadOnly, rightReadOnly);
            }
            return false;
        }
    }
}

