/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openide.awt.HtmlRenderer;
import org.openide.util.NbBundle;

public class FixDuplicateImportStmts
extends JPanel {
    private PackagesTblModel tblModel = null;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable packagesTbl;

    public FixDuplicateImportStmts() {
        this.initComponents();
    }

    public void initPanel(String[] simpleNames, String[][] choices, String[] defaults) {
        this.initComponentsMore(simpleNames, choices, defaults);
        this.setAccessible();
    }

    private void initComponentsMore(String[] simpleNames, String[][] choices, String[] defaults) {
        int i;
        this.tblModel = new PackagesTblModel(simpleNames.length);
        this.packagesTbl.setModel(this.tblModel);
        this.packagesTbl.setColumnSelectionInterval(1, 1);
        this.packagesTbl.getSelectionModel().setSelectionMode(0);
        this.packagesTbl.setSurrendersFocusOnKeystroke(true);
        for (i = 0; i < simpleNames.length; ++i) {
            this.packagesTbl.setValueAt(simpleNames[i], i, 0);
        }
        for (i = 0; i < choices.length; ++i) {
            JComboBox<String> combo = new JComboBox<String>(choices[i]);
            combo.setSelectedItem(defaults[i]);
            combo.setRenderer((ListCellRenderer<String>)HtmlRenderer.createRenderer());
            combo.getAccessibleContext().setAccessibleDescription(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_Combo_ACSD"));
            combo.getAccessibleContext().setAccessibleName(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_Combo_Name_ACSD"));
            this.packagesTbl.setValueAt(combo, i, 1);
        }
        this.packagesTbl.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.packagesTbl.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.adjustTableSize(this.packagesTbl, 5, 560);
        this.jLabel1.setText(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_IntroLbl"));
        this.jLabel1.setLabelFor(this.packagesTbl);
        this.jLabel1.setDisplayedMnemonic(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_IntroLbl_Mnemonic").charAt(0));
    }

    private static String getBundleString(String s) {
        return NbBundle.getMessage(FixDuplicateImportStmts.class, (String)s);
    }

    private void setAccessible() {
        this.packagesTbl.requestFocusInWindow();
        FixDuplicateImportStmts.enableEnterToClose(this.packagesTbl);
        this.getAccessibleContext().setAccessibleDescription(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_IntroLbl"));
    }

    public String[] getSelections() {
        return this.tblModel.getSelections();
    }

    private void adjustTableSize(JTable table, int rows, int width) {
        int margin = table.getIntercellSpacing().height;
        int unit = table.getRowHeight() + margin;
        int height = rows * unit - margin;
        Dimension dim = new Dimension(width, height);
        table.setPreferredScrollableViewportSize(dim);
    }

    private static void enableEnterToClose(JTable table) {
        InputMap inputMap = table.getInputMap(1);
        KeyStroke esc = KeyStroke.getKeyStroke("ENTER");
        InputMap parentMap = inputMap.getParent();
        parentMap.remove(esc);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.packagesTbl = new JTableX();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.setPreferredSize(new Dimension(560, 200));
        this.jLabel1.setText("<html>~More than one class found in classpath for some Type Name in source.  Select class to use in import statement for each Type Name below:</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.packagesTbl.setModel(new DefaultTableModel(new Object[][]{{"MyType", "com.foo.AllTypes"}, {"OtherType", "com.foo.AllTypes"}, {null, null}, {null, null}, {null, null}}, new String[]{"~Type Name", "~Class to Import"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.packagesTbl);
        this.packagesTbl.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/editor/java/Bundle").getString("FixDupImportStmts_Table_ACSD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    static /* synthetic */ String access$000(String x0) {
        return FixDuplicateImportStmts.getBundleString(x0);
    }

    private class JComponentCellEditor
    implements TableCellEditor {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;

        public Component getComponent() {
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorComponent = (JComponent)value;
            return this.editorComponent;
        }
    }

    private class JComponentCellRenderer
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    private static class JTableX
    extends JTable {
        private boolean needCalcRowHeight = true;

        public void updateUI() {
            super.updateUI();
            this.needCalcRowHeight = true;
        }

        public void paint(Graphics g) {
            if (this.needCalcRowHeight) {
                this.calcRowHeight(g);
            }
            super.paint(g);
        }

        private void calcRowHeight(Graphics g) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = (int)((double)fm.getHeight() * 1.4);
            this.needCalcRowHeight = false;
            this.setRowHeight(rowHeight);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            if (renderer == null) {
                Object o;
                Class<?> c = this.getColumnClass(column);
                if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                    c = this.getValueAt(row, column).getClass();
                }
                renderer = this.getDefaultRenderer(c);
            }
            return renderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellEditor editor = tableColumn.getCellEditor();
            if (editor == null) {
                Object o;
                Class<?> c = this.getColumnClass(column);
                if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                    c = this.getValueAt(row, column).getClass();
                }
                editor = this.getDefaultEditor(c);
            }
            return editor;
        }
    }

    private static class PackagesTblModel
    extends DefaultTableModel {
        String[] columnNames = new String[]{FixDuplicateImportStmts.access$000("FixDupImportStmts_TblCol1Hdr"), FixDuplicateImportStmts.access$000("FixDupImportStmts_TblCol2Hdr")};

        public PackagesTblModel(int rowCount) {
            super(rowCount, 2);
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public String[] getSelections() {
            int rowCount = this.getRowCount();
            String[] ret = new String[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                ret[i] = (String)((JComboBox)this.getValueAt(i, 1)).getSelectedItem();
            }
            return ret;
        }
    }
}

