/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.FixDuplicateImportStmts;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class JavaFixAllImports {
    private static final JavaFixAllImports INSTANCE = new JavaFixAllImports();

    public static JavaFixAllImports getDefault() {
        return INSTANCE;
    }

    private JavaFixAllImports() {
    }

    public void fixAllImports(FileObject fo) {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy wc) {
                try {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    ComputeImports.Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> candidates = new ComputeImports().computeCandidates((CompilationInfo)wc);
                    Map filteredCandidates = (Map)candidates.a;
                    Map notFilteredCandidates = (Map)candidates.b;
                    int size = notFilteredCandidates.size();
                    String[] names = new String[size];
                    String[][] variants = new String[size][];
                    String[] defaults = new String[size];
                    HashMap<String, TypeElement> fqn2TE = new HashMap<String, TypeElement>();
                    HashMap<String, String> displayName2FQN = new HashMap<String, String>();
                    int index = 0;
                    Iterator i$ = notFilteredCandidates.keySet().iterator();
                    while (i$.hasNext()) {
                        String key;
                        names[index] = key = (String)i$.next();
                        List unfilteredVars = (List)notFilteredCandidates.get(key);
                        List filteredVars = (List)filteredCandidates.get(key);
                        if (!unfilteredVars.isEmpty()) {
                            variants[index] = new String[unfilteredVars.size()];
                            int i = -1;
                            int minImportanceLevel = Integer.MAX_VALUE;
                            for (TypeElement e : filteredVars) {
                                variants[index][++i] = e.getQualifiedName().toString();
                                int level = Utilities.getImportanceLevel(variants[index][i]);
                                if (level < minImportanceLevel) {
                                    defaults[index] = variants[index][i];
                                    minImportanceLevel = level;
                                }
                                fqn2TE.put(e.getQualifiedName().toString(), e);
                            }
                            for (TypeElement e : unfilteredVars) {
                                if (filteredVars.contains(e)) continue;
                                String fqn = e.getQualifiedName().toString();
                                String dn = "<html><font color='#808080'><s>" + fqn;
                                variants[index][++i] = dn;
                                int level = Utilities.getImportanceLevel(fqn);
                                if (level < minImportanceLevel) {
                                    defaults[index] = variants[index][i];
                                    minImportanceLevel = level;
                                }
                                fqn2TE.put(fqn, e);
                                displayName2FQN.put(dn, fqn);
                            }
                        } else {
                            variants[index] = new String[1];
                            variants[index][0] = "<html><font color='#FF0000'>&lt;cannot be resolved&gt;";
                            defaults[index] = variants[index][0];
                        }
                        ++index;
                    }
                    FixDuplicateImportStmts panel = new FixDuplicateImportStmts();
                    panel.initPanel(names, variants, defaults);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, "Fix All Imports");
                    Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                    d.setVisible(true);
                    d.setVisible(false);
                    d.dispose();
                    if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                        ArrayList<String> toImport = new ArrayList<String>();
                        for (String dn : panel.getSelections()) {
                            String fqn = (String)displayName2FQN.get(dn);
                            TypeElement el = (TypeElement)fqn2TE.get(fqn != null ? fqn : dn);
                            if (el == null) continue;
                            toImport.add(el.getQualifiedName().toString());
                        }
                        try {
                            CompilationUnitTree cut = SourceUtils.addImports((CompilationUnitTree)wc.getCompilationUnit(), toImport, (TreeMaker)wc.getTreeMaker());
                            wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)cut);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            javaSource.runModificationTask((CancellableTask)task).commit();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }
}

