/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsHolder
implements PropertyChangeListener {
    private static final Map<FileObject, AnnotationsHolder> file2Annotations = new HashMap<FileObject, AnnotationsHolder>();
    private final FileObject file;
    private final EditorCookie.Observable ec;
    private final List<IsOverriddenAnnotation> annotations;

    public static synchronized AnnotationsHolder get(FileObject file) {
        AnnotationsHolder a = file2Annotations.get(file);
        if (a != null) {
            return a;
        }
        try {
            DataObject od = DataObject.find((FileObject)file);
            EditorCookie.Observable ec = (EditorCookie.Observable)od.getCookie(EditorCookie.Observable.class);
            if (ec == null) {
                return null;
            }
            a = new AnnotationsHolder(file, ec);
            file2Annotations.put(file, a);
            return a;
        }
        catch (IOException ex) {
            IsOverriddenAnnotationHandler.LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    private AnnotationsHolder(FileObject file, EditorCookie.Observable ec) {
        this.file = file;
        this.ec = ec;
        this.annotations = new ArrayList<IsOverriddenAnnotation>();
        ec.addPropertyChangeListener((PropertyChangeListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationsHolder.this.checkForReset();
            }
        });
        TimesCollector.getDefault().reportReference(file, AnnotationsHolder.class.getName(), "[M] Overridden AnnotationsHolder", (Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openedPanes".endsWith(evt.getPropertyName()) || evt.getPropertyName() == null) {
            this.checkForReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForReset() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.ec.getOpenedPanes() != null) return;
        Class<AnnotationsHolder> clazz = AnnotationsHolder.class;
        synchronized (AnnotationsHolder.class) {
            file2Annotations.remove(this.file);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setNewAnnotations(Collections.<IsOverriddenAnnotation>emptyList());
            this.ec.removePropertyChangeListener((PropertyChangeListener)this);
            return;
        }
    }

    public synchronized void setNewAnnotations(List<IsOverriddenAnnotation> as) {
        final ArrayList<IsOverriddenAnnotation> toRemove = new ArrayList<IsOverriddenAnnotation>(this.annotations);
        final ArrayList<IsOverriddenAnnotation> toAdd = new ArrayList<IsOverriddenAnnotation>(as);
        this.annotations.clear();
        this.annotations.addAll(as);
        Runnable doAttachDetach = new Runnable(){

            public void run() {
                for (IsOverriddenAnnotation a : toRemove) {
                    a.detachImpl();
                }
                for (IsOverriddenAnnotation a : toAdd) {
                    a.attach();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doAttachDetach.run();
        } else {
            SwingUtilities.invokeLater(doAttachDetach);
        }
    }

    public synchronized List<IsOverriddenAnnotation> getAnnotations() {
        return new ArrayList<IsOverriddenAnnotation>(this.annotations);
    }
}

