/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescription {
    private ClasspathInfo originalCPInfo;
    private ElementHandle<Element> handle;
    private ElementHandle<TypeElement> outtermostElement;
    private Collection<Modifier> modifiers;
    private String displayName;

    public ElementDescription(CompilationInfo info, Element element) {
        this.originalCPInfo = info.getClasspathInfo();
        this.handle = ElementHandle.create((Element)element);
        this.outtermostElement = ElementHandle.create((Element)SourceUtils.getOutermostEnclosingTypeElement((Element)element));
        this.modifiers = element.getModifiers();
        this.displayName = element.accept(new ElementNameVisitor(), true);
    }

    public FileObject getSourceFile() {
        FileObject file = SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)this.originalCPInfo);
        if (file != null) {
            return SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)ClasspathInfo.create((FileObject)file));
        }
        return null;
    }

    public ElementHandle<Element> getHandle() {
        return this.handle;
    }

    public Icon getIcon() {
        return UiUtils.getElementIcon((ElementKind)this.handle.getKind(), this.modifiers);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<Modifier> getModifiers() {
        return this.modifiers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<String, Boolean> {
        private ElementNameVisitor() {
        }

        @Override
        public String visitPackage(PackageElement e, Boolean p) {
            return p != false ? e.getQualifiedName().toString() : e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Boolean p) {
            if (e.getQualifiedName() == null || e.getSimpleName() == null) {
                return "annonymous inner";
            }
            return p != false ? e.getQualifiedName().toString() : e.getSimpleName().toString();
        }

        @Override
        public String visitExecutable(ExecutableElement e, Boolean p) {
            StringBuffer sb = new StringBuffer();
            sb.append(e.getEnclosingElement().accept(this, p));
            sb.append(".");
            sb.append(e.getSimpleName());
            sb.append("(");
            boolean addComma = false;
            for (VariableElement variableElement : e.getParameters()) {
                if (addComma) {
                    sb.append(", ");
                }
                addComma = true;
                sb.append(variableElement.accept(this, p));
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public String visitVariable(VariableElement ve, Boolean p) {
            return Utilities.getTypeName(ve.asType(), false) + " " + ve.getSimpleName();
        }

        @Override
        public String visitTypeParameter(TypeParameterElement tpe, Boolean p) {
            return tpe.getSimpleName().toString();
        }
    }
}

