/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSuperTypeAction
extends BaseAction {
    public GoToSuperTypeAction() {
        super("goto-super-implementation", 132);
        this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation"));
        String name = NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation-trimmed");
        this.putValue("trimmed-text", name);
        this.putValue("PopupMenuText", name);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        JavaSource js = JavaSource.forDocument((Document)target.getDocument());
        if (js == null) {
            Toolkit.getDefaultToolkit().beep();
        }
        final ArrayList<ElementDescription> result = new ArrayList<ElementDescription>();
        final AnnotationType[] type = new AnnotationType[1];
        try {
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController parameter) throws Exception {
                    TreePath path;
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    for (path = parameter.getTreeUtilities().pathFor(target.getCaretPosition()); path != null && path.getLeaf().getKind() != Tree.Kind.METHOD; path = path.getParentPath()) {
                    }
                    if (path == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    Element resolved = parameter.getTrees().getElement(path);
                    if (resolved == null || resolved.getKind() != ElementKind.METHOD) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    ExecutableElement ee = (ExecutableElement)resolved;
                    type[0] = IsOverriddenAnnotationHandler.detectOverrides((CompilationInfo)parameter, (TypeElement)ee.getEnclosingElement(), ee, result);
                }
            }, true);
            if (type[0] == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Point p = new Point(target.modelToView(target.getCaretPosition()).getLocation());
            SwingUtilities.convertPointToScreen(p, target);
            IsOverriddenAnnotation.performGoToAction(type[0], result, p, "");
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

