/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenPopup;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsOverriddenAnnotation
extends Annotation {
    private StyledDocument document;
    private Position pos;
    private String shortDescription;
    private AnnotationType type;
    private List<ElementDescription> declarations;

    public IsOverriddenAnnotation(StyledDocument document, Position pos, AnnotationType type, String shortDescription, List<ElementDescription> declarations) {
        this.document = document;
        this.pos = pos;
        this.type = type;
        this.shortDescription = shortDescription;
        this.declarations = declarations;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getAnnotationType() {
        switch (this.type) {
            case IS_OVERRIDDEN: {
                return "org-netbeans-modules-editor-java-is_overridden";
            }
            case HAS_IMPLEMENTATION: {
                return "org-netbeans-modules-editor-java-has_implementations";
            }
            case IMPLEMENTS: {
                return "org-netbeans-modules-editor-java-implements";
            }
            case OVERRIDES: {
                return "org-netbeans-modules-editor-java-overrides";
            }
        }
        throw new IllegalStateException("Currently not implemented: " + (Object)((Object)this.type));
    }

    public void attach() {
        NbDocument.addAnnotation((StyledDocument)this.document, (Position)this.pos, (int)-1, (Annotation)this);
    }

    public void detachImpl() {
        NbDocument.removeAnnotation((StyledDocument)this.document, (Annotation)this);
    }

    public String toString() {
        return "[IsOverriddenAnnotation: " + this.shortDescription + "]";
    }

    public Position getPosition() {
        return this.pos;
    }

    public String debugDump() {
        ArrayList<String> elementNames = new ArrayList<String>();
        for (ElementDescription desc : this.declarations) {
            elementNames.add(desc.getDisplayName());
        }
        Collections.sort(elementNames);
        return "IsOverriddenAnnotation: type=" + this.type.name() + ", elements:" + ((Object)elementNames).toString();
    }

    void mouseClicked(JTextComponent c, Point p) {
        Point position = new Point(p);
        SwingUtilities.convertPointToScreen(position, c);
        IsOverriddenAnnotation.performGoToAction(this.type, this.declarations, position, this.shortDescription);
    }

    static void performGoToAction(AnnotationType type, List<ElementDescription> declarations, Point position, String shortDescription) {
        String caption;
        if ((type == AnnotationType.IMPLEMENTS || type == AnnotationType.OVERRIDES) && declarations.size() == 1) {
            ElementDescription desc = declarations.get(0);
            FileObject file = desc.getSourceFile();
            if (file != null) {
                UiUtils.open((FileObject)file, desc.getHandle());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        switch (type) {
            case IMPLEMENTS: {
                caption = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Implements");
                break;
            }
            case OVERRIDES: {
                caption = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Overrides");
                break;
            }
            case IS_OVERRIDDEN: 
            case HAS_IMPLEMENTATION: {
                caption = shortDescription;
                break;
            }
            default: {
                throw new IllegalStateException("Currently not implemented: " + (Object)((Object)type));
            }
        }
        PopupUtil.showPopup(new IsOverriddenPopup(caption, declarations), caption, position.x, position.y, true, 0);
    }
}

