/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private MutablePositionRegion mainRegion;
    private boolean inSync;

    private InstantRenamePerformer(JTextComponent target, Set<Highlight> highlights, int caretOffset) throws BadLocationException {
        this.target = target;
        this.doc = target.getDocument();
        MutablePositionRegion mainRegion = null;
        ArrayList<MutablePositionRegion> regions = new ArrayList<MutablePositionRegion>();
        ArrayList<RenameHighlight> newHighlights = new ArrayList<RenameHighlight>();
        for (Highlight h : highlights) {
            Position end;
            Position start = NbDocument.createPosition((Document)this.doc, (int)h.getStart(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion current = new MutablePositionRegion(start, end = NbDocument.createPosition((Document)this.doc, (int)h.getEnd(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(current, caretOffset)) {
                mainRegion = current;
            } else {
                regions.add(current);
            }
            newHighlights.add(new RenameHighlight((PositionRegion)current));
        }
        if (mainRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        regions.add(0, mainRegion);
        this.region = new SyncDocumentRegion(this.doc, regions);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
        }
        target.addKeyListener(this);
        target.putClientProperty(InstantRenamePerformer.class, this);
        Highlighter.getDefault().setHighlights(this.getFileObject(), "instant-rename", newHighlights);
        target.select(mainRegion.getStartOffset(), mainRegion.getEndOffset());
    }

    private FileObject getFileObject() {
        DataObject od = (DataObject)this.doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        return od.getPrimaryFile();
    }

    public static void performInstantRename(JTextComponent target, Set<Highlight> highlights, int caretOffset) throws BadLocationException {
        new InstantRenamePerformer(target, highlights, caretOffset);
    }

    private boolean isIn(MutablePositionRegion region, int caretOffset) {
        return region.getStartOffset() <= caretOffset && caretOffset <= region.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getModifiers() == 0 || e.getKeyCode() == 10 && e.getModifiers() == 0) {
            this.release();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void release() {
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
        }
        this.target.removeKeyListener(this);
        Highlighter.getDefault().setHighlights(this.getFileObject(), "instant-rename", Collections.emptyList());
        this.region = null;
        this.doc = null;
        this.target = null;
        this.mainRegion = null;
    }

    private static final class RenameHighlight
    implements Highlight {
        private PositionRegion region;
        private static final Coloring COLORING = new Coloring(null, null, new Color(138, 191, 236));

        public RenameHighlight(PositionRegion region) {
            this.region = region;
        }

        public int getStart() {
            return this.region.getStartOffset();
        }

        public int getEnd() {
            return this.region.getEndOffset();
        }

        public Coloring getColoring() {
            return COLORING;
        }
    }
}

