/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUnusedImportFix
implements Fix {
    private FileObject file;
    private List<TreePathHandle> importsToRemove;
    private String bundleKey;

    public static RemoveUnusedImportFix create(FileObject file, TreePathHandle importToRemove) {
        return new RemoveUnusedImportFix(file, Collections.singletonList(importToRemove), "FIX_Remove_Unused_Import");
    }

    public static RemoveUnusedImportFix create(FileObject file, List<TreePathHandle> importsToRemove) {
        return new RemoveUnusedImportFix(file, importsToRemove, "FIX_All_Remove_Unused_Import");
    }

    private RemoveUnusedImportFix(FileObject file, List<TreePathHandle> importsToRemove, String bundleKey) {
        this.file = file;
        this.importsToRemove = importsToRemove;
        this.bundleKey = bundleKey;
    }

    public String getText() {
        return NbBundle.getMessage(RemoveUnusedImportFix.class, (String)this.bundleKey);
    }

    public ChangeInfo implement() {
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        try {
            js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.PARSED);
                    CompilationUnitTree nueCUT = copy.getCompilationUnit();
                    for (TreePathHandle handle : RemoveUnusedImportFix.this.importsToRemove) {
                        TreePath tp = handle.resolve((CompilationInfo)copy);
                        if (tp == null) {
                            Logger.getLogger(RemoveUnusedImportFix.class.getName()).info("Cannot resolve import to remove.");
                            return;
                        }
                        nueCUT = copy.getTreeMaker().removeCompUnitImport(nueCUT, (ImportTree)tp.getLeaf());
                    }
                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)nueCUT);
                }
            }).commit();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

