/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.HighlightImpl;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    @Deprecated
    private static final boolean DEBUG = false;
    private static final int[] NO_SPAN = new int[]{-1, -1};
    private static final Map<Class, List<Tree.Kind>> class2Kind = new HashMap<Class, List<Tree.Kind>>();
    private static final Set<String> keywords;

    private static int[] findIdentifierSpanImpl(Tree decl, Tree lastLeft, String name, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        return Utilities.findIdentifierSpanImpl(decl, lastLeft, Collections.emptyList(), name, cu, positions, doc);
    }

    private static int[] findIdentifierSpanImpl(Tree decl, Tree lastLeft, List<? extends Tree> firstRight, String name, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start;
        int declStart = (int)positions.getStartPosition(cu, decl);
        int n = start = lastLeft != null ? (int)positions.getEndPosition(cu, lastLeft) : declStart;
        if (start == -1 && (start = declStart) == -1) {
            return NO_SPAN;
        }
        try {
            int end = (int)positions.getEndPosition(cu, decl);
            for (Tree tree : firstRight) {
                int proposedEnd;
                if (tree == null || (proposedEnd = (int)positions.getStartPosition(cu, tree)) == -1 || proposedEnd >= end) continue;
                end = proposedEnd;
            }
            if (end == -1) {
                return NO_SPAN;
            }
            if (start > end) {
                start = (int)positions.getStartPosition(cu, decl);
            }
            if (start > doc.getLength() || end > doc.getLength()) {
                return NO_SPAN;
            }
            String text = doc.getText(start, end - start);
            int n2 = text.lastIndexOf(name.toString());
            if (n2 != -1) {
                return new int[]{start + n2, start + n2 + name.length()};
            }
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
        }
        return NO_SPAN;
    }

    private static int[] findIdentifierSpanImpl(MemberSelectTree tree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return NO_SPAN;
        }
        try {
            String member = tree.getIdentifier().toString();
            int end = endPosition - start;
            if (start > doc.getLength() || end > doc.getLength()) {
                return NO_SPAN;
            }
            String text = doc.getText(start, end);
            int index = text.lastIndexOf(member);
            if (index != -1) {
                return new int[]{start + index, start + index + member.length()};
            }
        }
        catch (BadLocationException e) {
            BadLocationException ex = (BadLocationException)Exceptions.attachMessage((Throwable)e, (String)("start=" + start + ", endPosition=" + endPosition));
            LOG.log(Level.INFO, null, ex);
        }
        return NO_SPAN;
    }

    private static int[] findIdentifierSpanImpl(TreePath decl, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        Tree leaf = decl.getLeaf();
        if (class2Kind.get(MethodTree.class).contains((Object)leaf.getKind())) {
            if (positions.getStartPosition(cu, leaf) == -1L || positions.getEndPosition(cu, leaf) == -1L) {
                return NO_SPAN;
            }
            MethodTree method = (MethodTree)leaf;
            ArrayList<Tree> rightTrees = new ArrayList<Tree>();
            rightTrees.addAll(method.getParameters());
            rightTrees.addAll(method.getThrows());
            rightTrees.add(method.getBody());
            Name name = method.getName();
            if (method.getReturnType() == null) {
                name = ((ClassTree)decl.getParentPath().getLeaf()).getSimpleName();
            }
            return Utilities.findIdentifierSpanImpl(leaf, method.getReturnType(), rightTrees, name.toString(), cu, positions, doc);
        }
        if (class2Kind.get(VariableTree.class).contains((Object)leaf.getKind())) {
            VariableTree var = (VariableTree)leaf;
            return Utilities.findIdentifierSpanImpl(leaf, var.getType(), Collections.singletonList(var.getInitializer()), var.getName().toString(), cu, positions, doc);
        }
        if (class2Kind.get(MemberSelectTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl((MemberSelectTree)leaf, cu, positions, doc);
        }
        if (class2Kind.get(ClassTree.class).contains((Object)leaf.getKind())) {
            int start = (int)positions.getStartPosition(cu, leaf);
            int end = (int)positions.getEndPosition(cu, leaf);
            if (start == -1 || end == -1) {
                return NO_SPAN;
            }
            if (start > doc.getLength() || end > doc.getLength()) {
                return NO_SPAN;
            }
            String name = ((ClassTree)leaf).getSimpleName().toString();
            if (name.length() == 0) {
                return NO_SPAN;
            }
            try {
                String text = doc.getText(start, end - start);
                int index = text.indexOf(name);
                if (index == -1) {
                    return NO_SPAN;
                }
                start += index;
            }
            catch (BadLocationException e) {
                LOG.log(Level.INFO, null, e);
            }
            int exactEnd = start + name.length();
            return new int[]{start, exactEnd};
        }
        throw new IllegalArgumentException("Only MethodDecl, VariableDecl and ClassDecl are accepted by this method.");
    }

    public static int[] findIdentifierSpan(final TreePath decl, final CompilationUnitTree cu, final SourcePositions positions, final Document doc) {
        final int[][] result = new int[1][];
        doc.render(new Runnable(){

            public void run() {
                result[0] = Utilities.findIdentifierSpanImpl(decl, cu, positions, doc);
            }
        });
        return result[0];
    }

    private static int findBodyStartImpl(Tree cltree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, cltree);
        int end = (int)positions.getEndPosition(cu, cltree);
        if (start == -1 || end == -1) {
            return -1;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        try {
            String text = doc.getText(start, end - start);
            int index = text.indexOf(123);
            if (index == -1) {
                return -1;
            }
            return start + index;
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
            return -1;
        }
    }

    public static int findBodyStart(final Tree cltree, final CompilationUnitTree cu, final SourcePositions positions, final Document doc) {
        Tree.Kind kind = cltree.getKind();
        if (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD) {
            throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)kind));
        }
        final int[] result = new int[1];
        doc.render(new Runnable(){

            public void run() {
                result[0] = Utilities.findBodyStartImpl(cltree, cu, positions, doc);
            }
        });
        return result[0];
    }

    private static int findLastBracketImpl(MethodTree tree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, tree);
        int end = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || end == -1) {
            return -1;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        try {
            String text = doc.getText(end - 1, 1);
            if (text.charAt(0) == '}') {
                return end - 1;
            }
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
        }
        return -1;
    }

    public static int findLastBracket(final MethodTree tree, final CompilationUnitTree cu, final SourcePositions positions, final Document doc) {
        final int[] result = new int[1];
        doc.render(new Runnable(){

            public void run() {
                result[0] = Utilities.findLastBracketImpl(tree, cu, positions, doc);
            }
        });
        return result[0];
    }

    private static Highlight createHighlightImpl(CompilationUnitTree cu, SourcePositions positions, Document doc, int startOffset, int endOffset, Collection<ColoringAttributes> c, Color es) {
        try {
            if (startOffset > doc.getLength() || endOffset > doc.getLength()) {
                return null;
            }
            return new HighlightImpl(doc, startOffset, endOffset, c, es);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Highlight createHighlightImpl(CompilationUnitTree cu, SourcePositions positions, Document doc, TreePath tree, Collection<ColoringAttributes> c, Color es) {
        Tree leaf = tree.getLeaf();
        int startOffset = (int)positions.getStartPosition(cu, leaf);
        int endOffset = (int)positions.getEndPosition(cu, leaf);
        if (leaf instanceof MethodTree || leaf instanceof VariableTree || leaf instanceof ClassTree || leaf instanceof MemberSelectTree) {
            int[] span = Utilities.findIdentifierSpan(tree, cu, positions, doc);
            startOffset = span[0];
            endOffset = span[1];
        }
        if (startOffset == -1 || endOffset == -1) {
            return null;
        }
        return Utilities.createHighlightImpl(cu, positions, doc, startOffset, endOffset, c, es);
    }

    public static Highlight createHighlight(final CompilationUnitTree cu, final SourcePositions positions, final Document doc, final TreePath tree, final Collection<ColoringAttributes> c, final Color es) {
        final Highlight[] result = new Highlight[1];
        doc.render(new Runnable(){

            public void run() {
                result[0] = Utilities.createHighlightImpl(cu, positions, doc, tree, c, es);
            }
        });
        return result[0];
    }

    public static Highlight createHighlight(final CompilationUnitTree cu, final SourcePositions positions, final Document doc, final int startOffset, final int endOffset, final Collection<ColoringAttributes> c, final Color es) {
        final Highlight[] result = new Highlight[1];
        doc.render(new Runnable(){

            public void run() {
                result[0] = Utilities.createHighlightImpl(cu, positions, doc, startOffset, endOffset, c, es);
            }
        });
        return result[0];
    }

    public static boolean isKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return keywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return keywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isPrivateElement(Element el) {
        if (el.getKind() == ElementKind.PARAMETER) {
            return true;
        }
        if (el.getKind() == ElementKind.LOCAL_VARIABLE) {
            return true;
        }
        if (el.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        return el.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    static {
        for (Tree.Kind k : Tree.Kind.values()) {
            Class<? extends Tree> c = k.asInterface();
            List<Tree.Kind> kinds = class2Kind.get(c);
            if (kinds == null) {
                kinds = new ArrayList<Tree.Kind>();
                class2Kind.put(c, kinds);
            }
            kinds.add(k);
        }
        keywords = new HashSet<String>();
        keywords.add("true");
        keywords.add("false");
        keywords.add("null");
        keywords.add("this");
        keywords.add("super");
        keywords.add("class");
    }
}

