/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.core.ActionsPoolNode;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class LoaderActionsPanel
extends JPanel
implements PropertyChangeListener,
ListCellRenderer {
    private DefaultListModel model;
    private ExplorerManager mgr;
    private PropertyEditor editor;
    private JButton addButton;
    private BeanTreeView beanTreeView2;
    private JButton downButton;
    private ExplorerPanel explorerPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JList list;
    private JButton removeButton;
    private JButton separatorButton;
    private JSplitPane splitPane;
    private JButton upButton;

    public LoaderActionsPanel(PropertyEditor pe, PropertyEnv env) {
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.editor = pe;
        this.initComponents();
        this.model = new DefaultListModel();
        SystemAction[] actions = (SystemAction[])pe.getValue();
        if (actions == null) {
            actions = new SystemAction[]{};
        }
        for (int i = 0; i < actions.length; ++i) {
            this.model.addElement(actions[i]);
        }
        this.list.setModel(this.model);
        this.mgr = this.explorerPanel.getExplorerManager();
        this.mgr.setRootContext((Node)new ActionsPoolNode());
        this.mgr.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("selectedNodes".equals(ev.getPropertyName())) {
                    SystemAction action = LoaderActionsPanel.findAction(LoaderActionsPanel.this.mgr.getSelectedNodes());
                    LoaderActionsPanel.this.addButton.setEnabled(action != null);
                }
            }
        });
        this.splitPane.setDividerLocation(300);
        ResourceBundle bundle = NbBundle.getBundle(LoaderActionsPanel.class);
        AccessibleContext ac = this.beanTreeView2.getAccessibleContext();
        ac.setAccessibleName(bundle.getString("ACS_LoaderActionsPanel.beanTreeView"));
        ac.setAccessibleDescription(bundle.getString("ACSD_LoaderActionsPanel.beanTreeView"));
        ac = this.list.getAccessibleContext();
        ac.setAccessibleName(bundle.getString("ACS_LoaderActionsPanel.list"));
        ac.setAccessibleDescription(bundle.getString("ACSD_LoaderActionsPanel.list"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_LoaderActionsPanel"));
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.explorerPanel = new ExplorerPanel();
        this.beanTreeView2 = new BeanTreeView();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.separatorButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setPreferredSize(new Dimension(600, 500));
        this.setLayout(new BorderLayout(11, 0));
        this.splitPane.setLastDividerLocation(300);
        this.explorerPanel.setLayout(new BorderLayout());
        this.beanTreeView2.setDefaultActionAllowed(false);
        this.beanTreeView2.setPopupAllowed(false);
        this.explorerPanel.add((Component)this.beanTreeView2, "Center");
        this.splitPane.setLeftComponent((Component)((Object)this.explorerPanel));
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this);
        this.list.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LoaderActionsPanel.this.listFocusGained(evt);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LoaderActionsPanel.this.listValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.splitPane.setRightComponent(this.jScrollPane1);
        this.add((Component)this.splitPane, "Center");
        this.jPanel2.setLayout(new FlowLayout(1, 0, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("LoaderActionsPanel.jButton1.text"));
        this.addButton.setToolTipText(bundle.getString("LoaderActionsPanel.jButton1.toolTipText"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoaderActionsPanel.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.separatorButton, (String)bundle.getString("LoaderActionsPanel.jButton2.text"));
        this.separatorButton.setToolTipText(bundle.getString("LoaderActionsPanel.jButton2.toolTipText"));
        this.separatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoaderActionsPanel.this.separatorButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.separatorButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("LoaderActionsPanel.jButton3.text"));
        this.removeButton.setToolTipText(bundle.getString("LoaderActionsPanel.jButton3.toolTipText"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoaderActionsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)bundle.getString("LoaderActionsPanel.jButton4.text"));
        this.upButton.setToolTipText(bundle.getString("LoaderActionsPanel.jButton4.toolTipText"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoaderActionsPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.upButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)bundle.getString("LoaderActionsPanel.jButton5.text"));
        this.downButton.setToolTipText(bundle.getString("LoaderActionsPanel.jButton5.toolTipText"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoaderActionsPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.downButton, gridBagConstraints);
        this.jPanel2.add(this.jPanel1);
        this.add((Component)this.jPanel2, "East");
    }

    private void listFocusGained(FocusEvent evt) {
        if (this.list.getSelectedIndex() == -1 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private void listValueChanged(ListSelectionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.downButton.setEnabled(index != this.model.getSize() - 1);
            this.upButton.setEnabled(index != 0);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index == -1 || index == this.model.getSize() - 1) {
            return;
        }
        Object temp = this.model.elementAt(index);
        this.model.setElementAt(this.model.elementAt(index + 1), index);
        this.model.setElementAt(temp, index + 1);
        this.list.setSelectedIndex(index + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index == -1 || index == 0) {
            return;
        }
        Object temp = this.model.elementAt(index);
        this.model.setElementAt(this.model.elementAt(index - 1), index);
        this.model.setElementAt(temp, index - 1);
        this.list.setSelectedIndex(index - 1);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.model.remove(index);
        if (this.model.getSize() == 0) {
            this.list.setSelectedIndices(new int[0]);
        } else {
            this.list.setSelectedIndex(Math.min(index, this.model.getSize() - 1));
        }
    }

    private void separatorButtonActionPerformed(ActionEvent evt) {
        this.model.addElement(null);
        this.list.setSelectedIndex(this.model.getSize() - 1);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.mgr.getSelectedNodes();
        SystemAction action = LoaderActionsPanel.findAction(nodes);
        if (action != null) {
            this.model.addElement(action);
        }
        this.list.setSelectedIndex(this.model.getSize() - 1);
    }

    static SystemAction findAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0 || nodes.length > 1) {
            return null;
        }
        InstanceCookie inst = (InstanceCookie)nodes[0].getCookie(InstanceCookie.class);
        if (inst == null) {
            return null;
        }
        try {
            Class clazz = inst.instanceClass();
            if (!SystemAction.class.isAssignableFrom(clazz)) {
                return null;
            }
            return (SystemAction)inst.instanceCreate();
        }
        catch (Exception e) {
            Logger.getLogger(LoaderActionsPanel.class.getName()).log(Level.WARNING, null, e);
            return null;
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        Object[] actions = new SystemAction[this.model.getSize()];
        this.model.copyInto(actions);
        return actions;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label;
        block10: {
            label = new JLabel();
            if (value != null) {
                SystemAction action = (SystemAction)value;
                try {
                    String name = action.getName();
                    if (name == null) {
                        name = NbBundle.getBundle(LoaderActionsPanel.class).getString("LBL_no_system_action_name");
                    }
                    label.setText(Actions.cutAmpersand((String)name));
                    Icon icon = action.getIcon();
                    if (icon != null) {
                        label.setIcon(icon);
                    }
                }
                catch (RuntimeException re) {
                    Logger.getLogger(LoaderActionsPanel.class.getName()).log(Level.WARNING, null, re);
                }
            } else {
                label.setText(NbBundle.getBundle(LoaderActionsPanel.class).getString("LBL_separator_rather_than_action"));
                try {
                    label.setIcon(new ImageIcon(new URL("nbresloc:/org/openide/resources/actions/empty.gif")));
                }
                catch (MalformedURLException ex) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)ex);
                }
            }
        }
        if (isSelected) {
            label.setBackground(list.getSelectionBackground());
            label.setForeground(list.getSelectionForeground());
        } else {
            label.setBackground(list.getBackground());
            label.setForeground(list.getForeground());
        }
        label.setEnabled(list.isEnabled());
        label.setFont(list.getFont());
        label.setOpaque(true);
        return label;
    }
}

