/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.beaninfo.editors.DataObjectListView;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.netbeans.beaninfo.editors.DataObjectTreeView;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String PROPERTY_CURRENT_FOLDER = "currentFolder";
    private static final String PROPERTY_ROOT_FOLDER = "rootFolder";
    private static final String PROPERTY_ROOT_NODE = "rootNode";
    private static final String PROPERTY_COOKIES = "cookies";
    private static final String PROPERTY_DATA_FILTER = "dataFilter";
    private static final String PROPERTY_FOLDER_FILTER = "folderFilter";
    private static final String PROPERTY_NODE_ACCEPTOR = "nodeAcceptor";
    private static final String PROPERTY_LABEL = "label";
    private static final String PROPERTY_TITLE = "title";
    private static final String PROPERTY_INSET = "inset";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_GUI_TYPE = "guitype";
    private static final String PROPERTY_SELECTION_MODE = "selectionMode";
    private DataObjectPanel customEditor;
    private DataFolder rootFolder;
    private Node rootNode;
    private DataObject currentFolder;
    private Class[] cookies;
    private DataFilter dataFilter;
    private DataFilter folderFilter;
    private NodeAcceptor nodeAcceptor;
    private String label;
    private String title;
    private Integer insets;
    private String description;
    private String guiType;
    private Integer selectionMode;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private PropertyEnv env;

    public void attachEnv(PropertyEnv env) {
        Object newObj = env.getFeatureDescriptor().getValue(PROPERTY_CURRENT_FOLDER);
        if (newObj instanceof DataObject) {
            this.currentFolder = (DataObject)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_ROOT_FOLDER)) instanceof DataFolder) {
            this.rootFolder = (DataFolder)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_ROOT_NODE)) instanceof Node) {
            this.rootNode = (Node)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_COOKIES)) instanceof Class[]) {
            this.cookies = (Class[])newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_DATA_FILTER)) instanceof DataFilter) {
            this.dataFilter = (DataFilter)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_FOLDER_FILTER)) instanceof DataFilter) {
            this.folderFilter = (DataFilter)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_NODE_ACCEPTOR)) instanceof NodeAcceptor) {
            this.nodeAcceptor = (NodeAcceptor)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_LABEL)) instanceof String) {
            this.label = (String)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_TITLE)) instanceof String) {
            this.title = (String)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_INSET)) instanceof Integer) {
            this.insets = (Integer)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_DESCRIPTION)) instanceof String) {
            this.description = (String)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_GUI_TYPE)) instanceof String) {
            this.guiType = (String)newObj;
        }
        if ((newObj = env.getFeatureDescriptor().getValue(PROPERTY_SELECTION_MODE)) instanceof Integer) {
            this.selectionMode = (Integer)newObj;
        }
        env.getFeatureDescriptor().setValue("canEditAsText", Boolean.FALSE);
        if (env.getClass().equals(PropertyEnv.class) && (this.customEditor != null && this.customEditor.isVisible() || this.customEditor == null)) {
            this.env = env;
        }
    }

    public Component getCustomEditor() {
        return this.getDataObjectPanel();
    }

    void setOkButtonEnabled(boolean state) {
        if (this.env != null) {
            this.env.setState(state ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
    }

    private DataObjectPanel getDataObjectPanel() {
        if (this.customEditor == null) {
            this.customEditor = this.guiType != null ? ("TreeView".equals(this.guiType) ? new DataObjectTreeView(this, this.env) : ("ListView".equals(this.guiType) ? new DataObjectListView(this, this.env) : new DataObjectListView(this, this.env))) : new DataObjectListView(this, this.env);
        } else if (this.env.getClass().equals(PropertyEnv.class)) {
            this.customEditor.setEnv(this.env);
        }
        if (this.cookies != null) {
            this.customEditor.setDataFilter(new CookieFilter(this.cookies, this.dataFilter));
        } else {
            this.customEditor.setDataFilter(this.dataFilter);
        }
        Object value = this.getValue();
        if (value != null && value instanceof DataObject) {
            this.customEditor.setDataObject((DataObject)value);
        } else if (this.currentFolder != null) {
            this.customEditor.setDataObject(this.currentFolder);
        }
        if (this.label != null) {
            this.customEditor.setText(this.label);
        }
        if (this.title != null) {
            this.customEditor.putClientProperty(PROPERTY_TITLE, this.title);
        }
        if (this.nodeAcceptor != null) {
            this.customEditor.setNodeFilter(this.nodeAcceptor);
        }
        if (this.folderFilter != null) {
            this.customEditor.setFolderFilter(this.folderFilter);
        }
        if (this.rootFolder != null) {
            this.customEditor.setRootObject((DataObject)this.rootFolder);
        }
        if (this.rootNode != null) {
            this.customEditor.setRootNode(this.rootNode);
        }
        if (this.insets != null) {
            this.customEditor.setInsetValue(this.insets);
        }
        if (this.description != null) {
            this.customEditor.setDescription(this.description);
        }
        if (this.selectionMode != null) {
            this.customEditor.setSelectionMode(this.selectionMode);
        }
        this.customEditor.setMultiSelection(true);
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        this.supp.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.supp.removePropertyChangeListener(l);
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof DataObject) {
            return ((DataObject)value).getNodeDelegate().getDisplayName();
        }
        return "";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            if (text == null || "".equals(text)) {
                this.setValue(null);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = MessageFormat.format(NbBundle.getMessage(DataObjectArrayEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), text);
            }
            UIExceptions.annotateUser(iae, iae.getMessage(), msg, e, new Date());
            throw iae;
        }
    }

    private static class CookieFilter
    implements DataFilter {
        private Class[] cookieArray;
        private DataFilter originalFilter;

        public CookieFilter(Class[] cookieArray, DataFilter originalFilter) {
            this.cookieArray = cookieArray;
            this.originalFilter = originalFilter;
        }

        public boolean acceptDataObject(DataObject obj) {
            if (this.cookieArray == null) {
                if (this.originalFilter != null) {
                    return this.originalFilter.acceptDataObject(obj);
                }
                return true;
            }
            for (int i = 0; i < this.cookieArray.length; ++i) {
                if (obj.getCookie(this.cookieArray[i]) != null) continue;
                return false;
            }
            if (this.originalFilter != null) {
                return this.originalFilter.acceptDataObject(obj);
            }
            return true;
        }
    }
}

