/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.beaninfo.editors.ServiceTypePanel;
import org.openide.ServiceType;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTypeEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String PROPERTY_NEW_TYPE = "createNew";
    private static final String PROPERTY_SUPERCLASS = "superClass";
    private String[] tags;
    private Class<? extends ServiceType> clazz;
    private String message;
    private PropertyEnv env;
    private boolean createNewInstance = false;

    public ServiceTypeEditor() {
        this(ServiceType.class, "LAB_ChooseServiceType");
    }

    public ServiceTypeEditor(Class<?> clazz, String message) {
        this.clazz = clazz.asSubclass(ServiceType.class);
        this.message = message;
    }

    public void attachEnv(PropertyEnv env) {
        Object sup;
        this.env = env;
        Object newObj = env.getFeatureDescriptor().getValue(PROPERTY_NEW_TYPE);
        if (newObj instanceof Boolean) {
            this.createNewInstance = (Boolean)newObj;
        }
        if ((sup = env.getFeatureDescriptor().getValue(PROPERTY_SUPERCLASS)) instanceof Class) {
            Class c;
            this.clazz = c = (Class)sup;
        }
    }

    private void updateTags() {
        LinkedList<String> names = new LinkedList<String>();
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration ee = registry.services(this.clazz);
        while (ee.hasMoreElements()) {
            ServiceType e = (ServiceType)ee.nextElement();
            names.add(e.getName());
        }
        this.tags = new String[names.size()];
        names.toArray(this.tags);
    }

    @Override
    public String getAsText() {
        if (this.createNewInstance) {
            return null;
        }
        ServiceType s = (ServiceType)this.getValue();
        if (s == null) {
            return ServiceTypeEditor.getString("LAB_DefaultServiceType");
        }
        return s.getName();
    }

    @Override
    public void setAsText(String text) {
        if (this.createNewInstance) {
            throw new IllegalArgumentException();
        }
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration en = registry.services(this.clazz);
        while (en.hasMoreElements()) {
            ServiceType t = (ServiceType)en.nextElement();
            if (!text.equals(t.getName())) continue;
            this.setValue(t);
            return;
        }
        this.setValue(null);
    }

    @Override
    public String[] getTags() {
        if (!this.createNewInstance) {
            this.updateTags();
            return this.tags;
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final ServiceTypePanel s = new ServiceTypePanel(this.clazz, ServiceTypeEditor.getString(this.message), null, this.createNewInstance);
        s.setServiceType((ServiceType)this.getValue());
        s.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("serviceType".equals(ev.getPropertyName())) {
                    ServiceTypeEditor.this.setValue(s.getServiceType());
                }
            }
        });
        return s;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ServiceTypeEditor.class).getString(s);
    }
}

