/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.ExplorerPanel;
import org.openide.ServiceType;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTypePanel
extends ExplorerPanel {
    private int width_components = 0;
    private int width_leftcomponent = 0;
    private Class<? extends ServiceType> clazz;
    private List<ServiceType> services;
    private ServiceType none;
    private boolean createNew = false;
    static final long serialVersionUID = 861345226525021334L;
    private JSplitPane jSplitPane1;
    private JLabel label;
    private ListView listView1;
    private PropertySheetView propertySheetView1;

    public ServiceTypePanel(Class<? extends ServiceType> clazz, String name, ServiceType none, boolean createNew) {
        this.clazz = clazz;
        this.none = none;
        this.createNew = createNew;
        this.update();
        this.initComponents();
        this.handleDividerLocation();
        this.label.setText(name);
        this.listView1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServiceTypePanel.class).getString("ACSD_ServiceTypeList"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ServiceTypePanel.class).getString("ACSD_ServiceTypePanel"));
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if ("selectedNodes".equals(ev.getPropertyName())) {
                    ServiceTypePanel.this.firePropertyChange("helpCtx", null, null);
                }
                ServiceTypePanel.this.firePropertyChange();
            }
        });
        if (name.length() > 0) {
            this.label.setDisplayedMnemonic(name.charAt(0));
        }
    }

    private void handleDividerLocation() {
        int listWidth = this.listView1.getPreferredSize().width;
        int propWidth = this.propertySheetView1.getPreferredSize().width;
        int splitWidth = this.jSplitPane1.getPreferredSize().width;
        int location = (int)((float)listWidth / (float)(listWidth + propWidth) * (float)splitWidth);
        if (location > 0) {
            this.jSplitPane1.setDividerLocation(location);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void setServiceType(ServiceType s) {
        Node[] nodes;
        if (s == null) {
            return;
        }
        int i = -1;
        for (int n = 0; n < this.services.size(); ++n) {
            if (!this.services.get(n).getName().equals(s.getName())) continue;
            i = n;
        }
        if (i < 0) {
            ServiceType oldNone = this.none;
            this.none = s;
            this.update();
            this.none = oldNone;
            i = this.services.indexOf(s);
        }
        if (i < 0) {
            Logger.getAnonymousLogger().warning("ServiceTypePanel: Unable to add service " + s.getName());
            i = 0;
        }
        if (i >= (nodes = this.getExplorerManager().getRootContext().getChildren().getNodes()).length) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{nodes[i]});
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(ServiceTypePanel.class.getName()).log(Level.WARNING, null, ex);
        }
        this.firePropertyChange();
    }

    public ServiceType getServiceType() {
        Node[] arr = this.getExplorerManager().getSelectedNodes();
        if (arr.length > 0) {
            return ((MN)arr[0]).getServiceType();
        }
        return null;
    }

    void firePropertyChange() {
        this.firePropertyChange("serviceType", null, null);
    }

    private void update() {
        Children.Array ch = new Children.Array();
        AbstractNode n = new AbstractNode((Children)ch);
        ch.add(this.nodes().toArray(new Node[this.nodes().size()]));
        this.getExplorerManager().setRootContext((Node)n);
        this.setActivatedNodes(new Node[0]);
    }

    private List<Node> nodes() {
        this.services = new ArrayList<ServiceType>(20);
        LinkedList<Node> l = new LinkedList<Node>();
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration en = registry.services(this.clazz);
        while (en.hasMoreElements()) {
            try {
                ServiceType service = (ServiceType)en.nextElement();
                if (this.createNew) {
                    ServiceType newObject = (ServiceType)service.getClass().newInstance();
                    l.add((Node)new MN(newObject));
                    this.services.add(newObject);
                    continue;
                }
                l.add((Node)new MN(service));
                this.services.add(service);
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(ServiceTypePanel.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(ServiceTypePanel.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ServiceTypePanel.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        try {
            if (this.none != null) {
                l.add((Node)new MN(this.none));
                this.services.add(this.none);
            }
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(ServiceTypePanel.class.getName()).log(Level.WARNING, null, ex);
        }
        return l;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.listView1 = new ListView();
        this.propertySheetView1 = new PropertySheetView();
        this.label = new JLabel();
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ServiceTypePanel.this.jSplitPane1ComponentResized(evt);
            }
        });
        this.listView1.setDefaultProcessor(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.listView1.setPopupAllowed(false);
        this.listView1.setSelectionMode(1);
        this.listView1.setTraversalAllowed(false);
        this.listView1.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ServiceTypePanel.this.listView1ComponentResized(evt);
            }
        });
        this.jSplitPane1.setLeftComponent((Component)this.listView1);
        this.jSplitPane1.setRightComponent((Component)this.propertySheetView1);
        this.add(this.jSplitPane1, "Center");
        this.label.setLabelFor((Component)this.listView1);
        this.add(this.label, "North");
    }

    private void listView1ComponentResized(ComponentEvent evt) {
        this.width_leftcomponent = this.listView1.getWidth();
    }

    private void jSplitPane1ComponentResized(ComponentEvent evt) {
        if (this.width_components > 0 && this.width_leftcomponent > 0) {
            int width = this.listView1.getWidth() + this.propertySheetView1.getWidth();
            int locator = width * this.width_leftcomponent / this.width_components;
            this.jSplitPane1.setDividerLocation(locator);
            this.width_leftcomponent = locator;
            this.width_components = width;
        } else {
            this.width_leftcomponent = this.listView1.getWidth();
            this.width_components = this.width_leftcomponent + this.propertySheetView1.getWidth();
        }
    }

    private void removeButtonPressed(ActionEvent evt) {
    }

    private void addButtonPressed(ActionEvent evt) {
    }

    private final class MN
    extends BeanNode {
        public MN(ServiceType t) throws IntrospectionException {
            super((Object)t);
        }

        public ServiceType getServiceType() {
            return (ServiceType)this.getBean();
        }

        public Node.PropertySet[] getPropertySets() {
            final Node.PropertySet[] sets = super.getPropertySets();
            if (ServiceTypePanel.this.createNew) {
                return sets;
            }
            Node.PropertySet[] nue = new Node.PropertySet[sets.length];
            for (int i = 0; i < sets.length; ++i) {
                final int ii = i;
                nue[i] = new Node.PropertySet(){
                    {
                        this.setName(sets[ii].getName());
                        this.setDisplayName(sets[ii].getDisplayName());
                        this.setShortDescription(sets[ii].getShortDescription());
                    }

                    public Node.Property[] getProperties() {
                        Node.Property[] props = sets[ii].getProperties();
                        ArrayList<Node.Property> nueprops = new ArrayList<Node.Property>();
                        for (int j = 0; j < props.length; ++j) {
                            if ("name".equals(props[j].getName())) continue;
                            nueprops.add(props[j]);
                        }
                        return nueprops.toArray(new Node.Property[nueprops.size()]);
                    }
                };
            }
            return nue;
        }
    }
}

