/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.ui.LookupNode;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

final class EnvironmentNode
extends AbstractNode {
    static final long serialVersionUID = 4782447107972624693L;
    private String filter;
    private static final String EN_ICON_BASE = "org/netbeans/core/resources/";
    private static HashMap<String, Node> types = new HashMap(11);
    private static final Object lock = new Object();
    public static final String TYPE_ROOTS = "roots";
    public static final String TYPE_ENVIRONMENT = "environment";
    public static final String TYPE_SESSION = "session";

    private EnvironmentNode(String filter, Children children) {
        super(children);
        this.filter = filter;
        EnvironmentNode.decorateNode(filter, this);
    }

    public static Node find(final String name) {
        Node retValue = (Node)Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<Node>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Node run() {
                Object object = lock;
                synchronized (object) {
                    Object n = (Node)types.get(name);
                    if (n == null) {
                        DataFolder folder = null;
                        if (EnvironmentNode.TYPE_ENVIRONMENT.equals(name)) {
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Runtime");
                        } else if (EnvironmentNode.TYPE_ROOTS.equals(name)) {
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Roots");
                        } else {
                            assert (EnvironmentNode.TYPE_SESSION.equals(name)) : name;
                            NbPlaces.getDefault();
                            folder = NbPlaces.findSessionFolder("UI/Services");
                        }
                        n = new PersistentLookupNode(name, folder);
                        types.put(name, n);
                    }
                    return n;
                }
            }
        });
        if (retValue != null) {
            return retValue;
        }
        throw new IllegalStateException();
    }

    private static void decorateNode(String name, AbstractNode node) {
        String resourceName = "CTL_" + name + "_name";
        String iconBase = EN_ICON_BASE + name.toLowerCase() + ".gif";
        node.setDisplayName(NbBundle.getMessage(EnvironmentNode.class, (String)resourceName));
        node.setIconBaseWithExtension(iconBase);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EnvironmentNode.class);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public Node.Handle getHandle() {
        return new EnvironmentHandle(this.filter);
    }

    static final class EnvironmentHandle
    implements Node.Handle {
        static final long serialVersionUID = -850350968366553370L;
        private String filter;

        public EnvironmentHandle(String filter) {
            this.filter = filter;
        }

        public Node getNode() {
            String f = this.filter;
            if (f == null) {
                f = EnvironmentNode.TYPE_ENVIRONMENT;
            }
            return EnvironmentNode.find(f);
        }
    }

    private static final class PersistentLookupNode
    extends LookupNode
    implements PropertyChangeListener {
        private String filter;

        public PersistentLookupNode(String filter, DataFolder folder) {
            super(folder);
            this.filter = filter;
            if (EnvironmentNode.TYPE_ROOTS.equals(filter)) {
                folder.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)folder));
            }
        }

        public Node.Handle getHandle() {
            return new EnvironmentHandle(this.filter);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("children".equals(evt.getPropertyName())) {
                NbPlaces.getDefault().fireChange();
            }
        }
    }
}

