/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;

class HtmlBrowserComponent
extends CloneableTopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 2912844785502987960L;
    private HtmlBrowser browserComponent;

    public HtmlBrowserComponent() {
        this(true, true);
    }

    public HtmlBrowserComponent(boolean toolbar, boolean statusLine) {
        this(null, toolbar, statusLine);
    }

    public HtmlBrowserComponent(HtmlBrowser.Factory fact, boolean toolbar, boolean statusLine) {
        this.setName("");
        this.setLayout(new BorderLayout());
        this.browserComponent = new HtmlBrowser(fact, toolbar, statusLine);
        this.add((Component)this.browserComponent, "Center");
        this.browserComponent.getBrowserImpl().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.browserComponent.getBrowserComponent() != null) {
            this.putClientProperty("InternalBrowser", Boolean.TRUE);
        }
        this.setToolTipText(NbBundle.getBundle(HtmlBrowser.class).getString("HINT_WebBrowser"));
    }

    public int getPersistenceType() {
        return 1;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (!"title".equals(e.getPropertyName())) {
            return;
        }
        String title = this.browserComponent.getBrowserImpl().getTitle();
        if (title == null || title.length() < 1) {
            return;
        }
        this.setName(title);
        this.setDisplayName(title);
    }

    public void open() {
        if (this.browserComponent.getBrowserComponent() == null) {
            return;
        }
        super.open();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new BrowserReplacer(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setStatusLineVisible(in.readBoolean());
        this.setToolbarVisible(in.readBoolean());
        this.browserComponent.setURL((URL)in.readObject());
    }

    protected CloneableTopComponent createClonedObject() {
        HtmlBrowserComponent bc = new HtmlBrowserComponent();
        bc.setURL(this.getDocumentURL());
        return bc;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HtmlBrowserComponent.class);
    }

    protected void componentActivated() {
        this.browserComponent.getBrowserImpl().getComponent().requestFocusInWindow();
        super.componentActivated();
    }

    public Image getIcon() {
        return new ImageIcon(HtmlBrowser.class.getResource("/org/openide/resources/html/htmlView.gif")).getImage();
    }

    public void setURL(String str) {
        this.browserComponent.setURL(str);
    }

    public void setURL(URL url) {
        this.browserComponent.setURL(url);
    }

    public final URL getDocumentURL() {
        return this.browserComponent.getDocumentURL();
    }

    public final void setEnableHome(boolean b) {
        this.browserComponent.setEnableHome(b);
    }

    public final void setEnableLocation(boolean b) {
        this.browserComponent.setEnableLocation(b);
    }

    public boolean isStatusLineVisible() {
        return this.browserComponent.isStatusLineVisible();
    }

    public void setStatusLineVisible(boolean v) {
        this.browserComponent.setStatusLineVisible(v);
    }

    public boolean isToolbarVisible() {
        return this.browserComponent.isToolbarVisible();
    }

    public void setToolbarVisible(boolean v) {
        this.browserComponent.setToolbarVisible(v);
    }

    protected String preferredID() {
        return "HtmlBrowserComponent";
    }

    public static final class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient HtmlBrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(HtmlBrowserComponent comp) {
            this.bComp = comp;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.bComp.isStatusLineVisible());
            out.writeBoolean(this.bComp.isToolbarVisible());
            out.writeObject(this.bComp.getDocumentURL());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.statLine = in.readBoolean();
            this.toolbar = in.readBoolean();
            this.url = (URL)in.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if ("http".equals(this.url.getProtocol()) && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException exc) {
            }
            catch (SecurityException exc) {
            }
            catch (NullPointerException exc) {
            }
            catch (IOException exc) {
                return null;
            }
            catch (Exception exc) {
                Logger.getLogger(HtmlBrowserComponent.class.getName()).log(Level.WARNING, null, exc);
            }
            this.bComp = new HtmlBrowserComponent(this.statLine, this.toolbar);
            this.bComp.setURL(this.url);
            return this.bComp;
        }
    }
}

