/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ManifestSection;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.InstanceSupport;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoaderPoolNode
extends AbstractNode {
    private static LoaderPoolNode loaderPoolNode;
    private static final Logger err;
    private static LoaderChildren myChildren;
    private static List<DataLoader> loaders;
    private static Set<DataLoader> modifiedLoaders;
    private static Map<String, DataLoader> names2Loaders;
    private static Map<String, DataLoader> repNames2Loaders;
    private static Map<String, String[]> installBefores;
    private static Map<String, String[]> installAfters;
    private static DataLoader[] loadersArray;
    private static boolean installationFinished;
    private static boolean updatingBatch;
    private static boolean updatingBatchUsed;
    private static final String LOADER_POOL_NAME = "loaders.ser";
    private static NbLoaderPool nbLoaderPool;

    private LoaderPoolNode() {
        super((Children)new LoaderChildren());
        myChildren = (LoaderChildren)this.getChildren();
        this.setName("LoaderPoolNode");
        this.setDisplayName(NbBundle.getMessage(LoaderPoolNode.class, (String)"CTL_LoaderPool"));
        this.getCookieSet().add((Node.Cookie)new Index());
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)LoaderPoolNode.getNbLoaderPool()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LoaderPoolNode.class);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(ReorderAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public static synchronized void beginUpdates() {
        updatingBatch = true;
        updatingBatchUsed = false;
    }

    public static synchronized void endUpdates() {
        if (!updatingBatch) {
            throw new IllegalStateException();
        }
        updatingBatch = false;
        if (updatingBatchUsed) {
            updatingBatchUsed = false;
            LoaderPoolNode.resort();
        }
    }

    public static void waitFinished() {
        LoaderPoolNode.getNbLoaderPool().fireTask.waitFinished();
    }

    public static void add(ManifestSection.LoaderSection s) throws Exception {
        DataLoader l = (DataLoader)s.getInstance();
        LoaderPoolNode.doAdd(l, s);
    }

    static synchronized void doAdd(DataLoader l, ManifestSection.LoaderSection s) throws Exception {
        if (err.isLoggable(Level.FINE) && s != null) {
            List<String> before = s.getInstallBefore() == null ? null : Arrays.asList(s.getInstallBefore());
            List<String> after = s.getInstallAfter() == null ? null : Arrays.asList(s.getInstallAfter());
            err.fine("add: " + l + " repclass: " + l.getRepresentationClass().getName() + " before: " + before + " after: " + after);
        }
        Iterator<DataLoader> it = loaders.iterator();
        Class<?> c = l.getClass();
        while (it.hasNext()) {
            if (it.next().getClass() != c) continue;
            it.remove();
            break;
        }
        loaders.add(l);
        l.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        l.addPropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        String cname = c.getName();
        names2Loaders.put(cname, l);
        repNames2Loaders.put(l.getRepresentationClassName(), l);
        if (s != null) {
            String[] ia;
            String[] ib = s.getInstallBefore();
            if (ib != null) {
                installBefores.put(cname, ib);
            }
            if ((ia = s.getInstallAfter()) != null) {
                installAfters.put(cname, ia);
            }
        }
        if (updatingBatch) {
            updatingBatchUsed = true;
        } else {
            LoaderPoolNode.resort();
        }
    }

    private static synchronized void resort() {
        HashMap<DataLoader, List<DataLoader>> deps = new HashMap<DataLoader, List<DataLoader>>();
        LoaderPoolNode.add2Deps(deps, installBefores, true);
        LoaderPoolNode.add2Deps(deps, installAfters, false);
        if (err.isLoggable(Level.FINE)) {
            err.fine("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.topologicalSort(loaders, deps);
            if (err.isLoggable(Level.FINE)) {
                err.fine("After sort: " + loaders);
            }
        }
        catch (TopologicalSortException ex) {
            err.log(Level.WARNING, null, ex);
            err.warning("Contradictory loader ordering: " + deps);
        }
        LoaderPoolNode.update();
    }

    private static void add2Deps(Map<DataLoader, List<DataLoader>> deps, Map orderings, boolean before) {
        for (Map.Entry e : orderings.entrySet()) {
            String loaderClassName = (String)e.getKey();
            DataLoader l = names2Loaders.get(loaderClassName);
            if (l == null) {
                throw new IllegalStateException("No such loader: " + loaderClassName);
            }
            String[] repClassNames = (String[])e.getValue();
            if (repClassNames == null) {
                throw new IllegalStateException("Null Install-" + (before ? "Before" : "After") + " for " + loaderClassName);
            }
            for (int i = 0; i < repClassNames.length; ++i) {
                String repClassName = repClassNames[i];
                DataLoader l2 = repNames2Loaders.get(repClassName);
                if (l2 != null) {
                    if (before) {
                        LoaderPoolNode.addDep(deps, l, l2);
                        continue;
                    }
                    LoaderPoolNode.addDep(deps, l2, l);
                    continue;
                }
                l2 = names2Loaders.get(repClassName);
                if (l2 == null) continue;
                LoaderPoolNode.warn(loaderClassName, repClassName, l2.getRepresentationClassName());
            }
        }
    }

    private static void addDep(Map<DataLoader, List<DataLoader>> deps, DataLoader a, DataLoader b) {
        List<DataLoader> l = deps.get(a);
        if (l == null) {
            l = new LinkedList<DataLoader>();
            deps.put(a, l);
        }
        if (!l.contains(b)) {
            l.add(b);
        }
    }

    private static void warn(String yourLoader, String otherLoader, String otherRepn) {
        err.warning("Warning: a possible error in the manifest containing " + yourLoader + " was found.");
        err.warning("The loader specified an Install-{After,Before} on " + otherLoader + ", but this is a DataLoader class.");
        err.warning("Probably you wanted " + otherRepn + " which is the loader's representation class.");
    }

    static void installationFinished() {
        installationFinished = true;
        if (myChildren != null) {
            myChildren.update();
        }
    }

    static synchronized boolean isModified(DataLoader l) {
        return modifiedLoaders.contains(l);
    }

    private static synchronized void writePool(ObjectOutputStream oos) throws IOException {
        Object c;
        if (err.isLoggable(Level.FINE)) {
            err.fine("writePool");
        }
        oos.writeObject(new HashMap());
        oos.writeObject(new HashMap());
        Collection modules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (DataLoader l : loaders) {
            NbMarshalledObject obj;
            if (!LoaderPoolNode.isModified(l)) {
                String c2 = l.getClass().getName();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("writing unmodified " + c2);
                }
                oos.writeObject("=" + c2);
                continue;
            }
            try {
                obj = new NbMarshalledObject((Object)l);
            }
            catch (IOException ex) {
                err.log(Level.WARNING, null, ex);
                obj = null;
            }
            if (obj == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing modified " + l.getClass().getName());
            }
            c = l.getClass();
            Iterator mit = modules.iterator();
            boolean found = false;
            while (mit.hasNext()) {
                ModuleInfo m = (ModuleInfo)mit.next();
                if (!m.isEnabled() || !m.owns((Class)c)) continue;
                if (err.isLoggable(Level.FINE)) {
                    err.fine("belongs to module: " + m.getCodeNameBase());
                }
                oos.writeObject(m.getCodeNameBase());
                int r = m.getCodeNameRelease();
                oos.writeInt(r);
                SpecificationVersion v = m.getSpecificationVersion();
                if (v != null) {
                    oos.writeObject(v.toString());
                } else {
                    oos.writeObject(null);
                }
                found = true;
                break;
            }
            if (!found && err.isLoggable(Level.FINE)) {
                err.fine("does not belong to any module");
            }
            oos.writeObject(obj);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        oos.writeObject(null);
        Enumeration e = LoaderPoolNode.getNbLoaderPool().allLoaders();
        while (e.hasMoreElements()) {
            NbMarshalledObject obj;
            DataLoader l = (DataLoader)e.nextElement();
            if (loaders.contains(l)) continue;
            if (!LoaderPoolNode.isModified(l)) {
                c = l.getClass().getName();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("skipping unmodified " + (String)c);
                continue;
            }
            try {
                obj = new NbMarshalledObject((Object)l);
            }
            catch (IOException ex) {
                err.log(Level.WARNING, null, ex);
                obj = null;
            }
            if (obj == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing " + l.getClass().getName());
            }
            oos.writeObject(obj);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        oos.writeObject(null);
        if (err.isLoggable(Level.FINE)) {
            err.fine("done writing");
        }
    }

    private static synchronized void readPool(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readObject();
        ois.readObject();
        HashSet classes = new HashSet();
        LinkedList<DataLoader> l = new LinkedList<DataLoader>();
        Iterator mit = Lookup.getDefault().lookupAll(ModuleInfo.class).iterator();
        HashMap<String, ModuleInfo> modules = new HashMap<String, ModuleInfo>();
        while (mit.hasNext()) {
            ModuleInfo m = (ModuleInfo)mit.next();
            modules.put(m.getCodeNameBase(), m);
        }
        while (true) {
            NbMarshalledObject obj;
            Object o1;
            if ((o1 = ois.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            if (o1 instanceof String) {
                SpecificationVersion v;
                String name = (String)o1;
                if (name.length() > 0 && name.charAt(0) == '=') {
                    String cname = name.substring(1);
                    DataLoader dl = names2Loaders.get(cname);
                    if (dl != null) {
                        if (err.isLoggable(Level.FINE)) {
                            err.fine("reading unmodified " + cname);
                        }
                        l.add(dl);
                        classes.add(dl.getClass());
                        continue;
                    }
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("skipping unmodified nonexistent " + cname);
                    continue;
                }
                int rel = ois.readInt();
                String spec = (String)ois.readObject();
                obj = (NbMarshalledObject)ois.readObject();
                ModuleInfo m = (ModuleInfo)modules.get(name);
                if (m == null) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("No known module " + name + ", skipping loader");
                    continue;
                }
                if (!m.isEnabled()) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + name + " is disabled, skipping loader");
                    continue;
                }
                if (m.getCodeNameRelease() < rel) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + name + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (spec != null && ((v = m.getSpecificationVersion()) == null || v.compareTo((Object)new SpecificationVersion(spec)) < 0)) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + name + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                if (err.isLoggable(Level.FINE)) {
                    err.fine("Module " + name + " is OK, will try to restore loader");
                }
            } else {
                obj = (NbMarshalledObject)o1;
            }
            Exception t = null;
            try {
                DataLoader loader = (DataLoader)obj.get();
                if (loader == null) continue;
                Class<?> clazz = loader.getClass();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("reading modified " + clazz.getName());
                }
                l.add(loader);
                classes.add(clazz);
            }
            catch (IOException ex) {
                t = ex;
            }
            catch (ClassNotFoundException ex) {
                t = ex;
            }
        }
        while (true) {
            NbMarshalledObject obj;
            if ((obj = (NbMarshalledObject)ois.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            Exception t = null;
            try {
                DataLoader loader = (DataLoader)obj.get();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("reading " + loader.getClass().getName());
            }
            catch (IOException ex) {
                t = ex;
            }
            catch (ClassNotFoundException ex) {
                t = ex;
            }
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("done reading");
        }
        for (DataLoader loader : loaders) {
            if (classes.contains(loader.getClass())) continue;
            l.add(loader);
        }
        if (l.size() > new HashSet(l).size()) {
            throw new IllegalStateException("Duplicates in " + l);
        }
        loaders = l;
        LoaderPoolNode.resort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() throws IOException {
        FileObject ser = LoaderPoolNode.getLoaderPoolStorage(true);
        FileLock lock = ser.lock();
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream(ser.getOutputStream(lock));
            try {
                NbObjectOutputStream.writeSafely((ObjectOutput)oos, (Object)LoaderPoolNode.getNbLoaderPool());
            }
            finally {
                oos.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws IOException {
        FileObject ser = LoaderPoolNode.getLoaderPoolStorage(false);
        if (ser != null) {
            NbObjectInputStream ois = new NbObjectInputStream(ser.getInputStream());
            try {
                NbObjectInputStream.readSafely((ObjectInput)ois);
            }
            finally {
                ois.close();
            }
        }
    }

    public static FileObject getLoaderPoolStorage(boolean create) throws IOException {
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = sfs.findResource(LOADER_POOL_NAME);
        if (fo == null && create) {
            fo = sfs.getRoot().createData(LOADER_POOL_NAME);
        }
        return fo;
    }

    private static synchronized void update() {
        if (err.isLoggable(Level.FINE)) {
            err.fine("update");
        }
        loadersArray = null;
        NbLoaderPool lp = LoaderPoolNode.getNbLoaderPool();
        if (lp != null && installationFinished) {
            lp.superFireChangeEvent();
        }
        if (lp != null) {
            Enumeration e = lp.allLoaders();
            while (e.hasMoreElements()) {
                DataLoader l = (DataLoader)e.nextElement();
                l.removePropertyChangeListener((PropertyChangeListener)lp);
                l.addPropertyChangeListener((PropertyChangeListener)lp);
            }
        }
    }

    public static synchronized boolean remove(DataLoader dl) {
        if (loaders.remove(dl)) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("remove: " + dl);
            }
            String cname = dl.getClass().getName();
            names2Loaders.remove(cname);
            repNames2Loaders.remove(dl.getRepresentationClassName());
            installBefores.remove(cname);
            installAfters.remove(cname);
            dl.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
            if (updatingBatch) {
                updatingBatchUsed = true;
            } else {
                LoaderPoolNode.resort();
            }
            modifiedLoaders.remove(dl);
            return true;
        }
        return false;
    }

    public static synchronized LoaderPoolNode getLoaderPoolNode() {
        if (loaderPoolNode == null) {
            loaderPoolNode = new LoaderPoolNode();
        }
        return loaderPoolNode;
    }

    public static synchronized NbLoaderPool getNbLoaderPool() {
        if (nbLoaderPool == null) {
            nbLoaderPool = (NbLoaderPool)DataLoaderPool.getDefault();
        }
        return nbLoaderPool;
    }

    static /* synthetic */ DataLoader[] access$302(DataLoader[] x0) {
        loadersArray = x0;
        return x0;
    }

    static {
        err = Logger.getLogger("org.netbeans.core.LoaderPoolNode");
        loaders = new ArrayList<DataLoader>();
        modifiedLoaders = new HashSet<DataLoader>();
        names2Loaders = new HashMap<String, DataLoader>(200);
        repNames2Loaders = new HashMap<String, DataLoader>(200);
        installBefores = new HashMap<String, String[]>();
        installAfters = new HashMap<String, String[]>();
        installationFinished = false;
        updatingBatch = false;
        updatingBatchUsed = false;
        nbLoaderPool = null;
    }

    private final class Index
    extends Index.Support {
        Index() {
        }

        public Node[] getNodes() {
            Enumeration e = LoaderPoolNode.this.getChildren().nodes();
            ArrayList<LoaderPoolItemNode> l = new ArrayList<LoaderPoolItemNode>();
            while (e.hasMoreElements()) {
                LoaderPoolItemNode node = (LoaderPoolItemNode)((Object)e.nextElement());
                if (node.isSystem) continue;
                l.add(node);
            }
            return l.toArray(new Node[l.size()]);
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] perm) {
            Class<LoaderPoolNode> clazz = LoaderPoolNode.class;
            synchronized (LoaderPoolNode.class) {
                DataLoader[] target;
                DataLoader[] arr = loaders.toArray(new DataLoader[loaders.size()]);
                if (arr.length == perm.length) {
                    target = new DataLoader[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        if (target[perm[i]] != null) {
                            throw new IllegalArgumentException();
                        }
                        target[perm[i]] = arr[i];
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                loaders = new ArrayList<DataLoader>(Arrays.asList(target));
                LoaderPoolNode.update();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LoaderChildren
    extends Children.Keys<DataLoader>
    implements ChangeListener {
        public LoaderChildren() {
            this.update();
            LoaderPoolNode.getNbLoaderPool().addChangeListener(this);
        }

        public void update() {
            this.setKeys(Collections.list(LoaderPoolNode.getNbLoaderPool().allLoaders()));
        }

        protected Node[] createNodes(DataLoader loader) {
            try {
                return new Node[]{new LoaderPoolItemNode(loader)};
            }
            catch (IntrospectionException e) {
                err.log(Level.WARNING, null, e);
                return new Node[0];
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderPoolItemNode
    extends BeanNode<DataLoader> {
        boolean isSystem;

        public LoaderPoolItemNode(DataLoader loader) throws IntrospectionException {
            super((Object)loader);
            this.setSynchronizeName(false);
            String displayName = this.getDisplayName();
            this.setName(loader.getClass().getName());
            boolean bl = this.isSystem = !loaders.contains(loader);
            if (this.isSystem) {
                this.setDisplayName(NbBundle.getMessage(LoaderPoolNode.class, (String)"LBL_system_data_loader", (Object)displayName));
            } else {
                this.setDisplayName(displayName);
            }
        }

        public Action[] getActions(boolean context) {
            if (this.isSystem) {
                return new Action[]{SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return new Action[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }

        public Action getPreferredAction() {
            return SystemAction.get(PropertiesAction.class);
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            HelpCtx help = super.getHelpCtx();
            if (help == null || help.getHelpID() == null || help.getHelpID().equals(BeanNode.class.getName())) {
                help = new HelpCtx(LoaderPoolItemNode.class);
            }
            return help;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NbLoaderPool
    extends DataLoaderPool
    implements PropertyChangeListener,
    Runnable,
    LookupListener {
        private static final long serialVersionUID = -8488524097175567566L;
        private transient RequestProcessor.Task fireTask = rp.create((Runnable)this, true);
        private transient Lookup.Result mimeResolvers = Lookup.getDefault().lookupResult(MIMEResolver.class);
        private static RequestProcessor rp = new RequestProcessor("Refresh Loader Pool");

        public NbLoaderPool() {
            this.mimeResolvers.addLookupListener((LookupListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Enumeration<DataLoader> loaders() {
            Object[] arr = loadersArray;
            if (arr != null) return Enumerations.array((Object[])arr);
            Class<LoaderPoolNode> clazz = LoaderPoolNode.class;
            synchronized (LoaderPoolNode.class) {
                arr = LoaderPoolNode.access$302(loaders.toArray(new DataLoader[loaders.size()]));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Enumerations.array((Object[])arr);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            DataLoader l = (DataLoader)ev.getSource();
            String prop = ev.getPropertyName();
            if ("actions".equals(prop) && ev.getNewValue() == null) {
                return;
            }
            modifiedLoaders.add(l);
            if (err.isLoggable(Level.FINE)) {
                err.fine("Got change in " + l.getClass().getName() + "." + prop);
            }
            if ("actions".equals(prop) || "displayName".equals(prop)) {
                return;
            }
            if (installationFinished) {
                this.superFireChangeEvent();
            }
        }

        void superFireChangeEvent() {
            err.fine("Change in loader pool scheduled");
            this.fireTask.schedule(1000);
        }

        @Override
        public void run() {
            err.fine("going to fire change in loaders");
            super.fireChangeEvent(new ChangeEvent(this));
            err.fine("change event fired");
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            LoaderPoolNode.writePool(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            LoaderPoolNode.readPool(ois);
        }

        private Object readResolve() {
            return LoaderPoolNode.getNbLoaderPool();
        }

        public void resultChanged(LookupEvent ev) {
            if (Main.isInitialized()) {
                this.superFireChangeEvent();
            }
        }
    }
}

