/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.core.ProxySettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbProxySelector
extends ProxySelector {
    private ProxySelector original = null;
    private Logger log = Logger.getLogger(NbProxySelector.class.getName());
    private Object useSystemProxies;

    public NbProxySelector() {
        this.original = ProxySelector.getDefault();
        this.log.fine("Override the original ProxySelector: " + this.original);
        this.log.fine("java.net.useSystemProxies has been set to " + this.useSystemProxies());
        ProxySettings.addPreferenceChangeListener(new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Object> res = new ArrayList();
        int proxyType = ProxySettings.getProxyType();
        if (0 == proxyType) {
            res = Collections.singletonList(Proxy.NO_PROXY);
        } else if (1 == proxyType) {
            if (this.useSystemProxies()) {
                res = this.original.select(uri);
            } else {
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (this.dontUseProxy(ProxySettings.SystemProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String ports = ProxySettings.SystemProxySettings.getHttpPort();
                    if (ports != null && ports.length() > 0 && ProxySettings.SystemProxySettings.getHttpHost().length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.SystemProxySettings.getHttpHost(), porti));
                        res.add(p);
                    }
                } else {
                    String ports = ProxySettings.SystemProxySettings.getSocksPort();
                    String hosts = ProxySettings.SystemProxySettings.getSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    }
                }
                res.addAll(this.original.select(uri));
            }
        } else if (2 == proxyType) {
            String protocol = uri.getScheme();
            assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
            if (this.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                res.add(Proxy.NO_PROXY);
            }
            if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                String hosts = ProxySettings.getHttpHost();
                String ports = ProxySettings.getHttpPort();
                if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                    int porti = Integer.parseInt(ports);
                    Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hosts, porti));
                    res.add(p);
                } else {
                    this.log.info("Incomplete HTTP Proxy [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                    this.log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                    res.addAll(this.original.select(uri));
                }
            } else {
                String ports = ProxySettings.getSocksPort();
                String hosts = ProxySettings.getSocksHost();
                if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                    int porti = Integer.parseInt(ports);
                    Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                    res.add(p);
                } else {
                    this.log.info("Incomplete SOCKS Server [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                    this.log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                    res.addAll(this.original.select(uri));
                }
            }
            res.add(Proxy.NO_PROXY);
        } else assert (false) : "Invalid proxy type: " + ProxySettings.getProxyType();
        this.log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "] returns " + res + " for URI " + uri);
        return res;
    }

    @Override
    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
        this.log.log(Level.INFO, "connectionFailed(" + arg0 + ", " + arg1 + ")", arg2);
    }

    private void copySettingsToSystem() {
        String host = null;
        String port = null;
        String nonProxyHosts = null;
        String sHost = null;
        String sPort = null;
        int proxyType = ProxySettings.getProxyType();
        if (0 == proxyType) {
            host = null;
            port = null;
            nonProxyHosts = null;
            sHost = null;
            sPort = null;
        } else if (1 == proxyType) {
            host = ProxySettings.SystemProxySettings.getHttpHost();
            port = ProxySettings.SystemProxySettings.getHttpPort();
            nonProxyHosts = ProxySettings.SystemProxySettings.getNonProxyHosts();
            sHost = ProxySettings.SystemProxySettings.getSocksHost();
            sPort = ProxySettings.SystemProxySettings.getSocksPort();
        } else if (2 == proxyType) {
            host = ProxySettings.getHttpHost();
            port = ProxySettings.getHttpPort();
            nonProxyHosts = ProxySettings.getNonProxyHosts();
            sHost = ProxySettings.getSocksHost();
            sPort = ProxySettings.getSocksPort();
        } else assert (false) : "Invalid proxy type: " + proxyType;
        this.setOrClearProperty("http.proxyHost", host, false);
        this.setOrClearProperty("http.proxyPort", port, true);
        this.setOrClearProperty("http.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("https.proxyHost", host, false);
        this.setOrClearProperty("https.proxyPort", port, true);
        this.setOrClearProperty("https.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("socksProxyHost", sHost, false);
        this.setOrClearProperty("socksProxyPort", sPort, true);
        this.log.finest("Set System's http.proxyHost/Port/NonProxyHost to " + host + "/" + port + "/" + nonProxyHosts);
        this.log.finest("Set System's socksProxyHost/Port to " + sHost + "/" + sPort);
    }

    private void setOrClearProperty(String key, String value, boolean isInteger) {
        assert (key != null);
        if (value == null || value.length() == 0) {
            System.clearProperty(key);
        } else {
            if (isInteger) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    this.log.log(Level.INFO, nfe.getMessage(), nfe);
                }
            }
            System.setProperty(key, value);
        }
    }

    private boolean dontUseProxy(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                this.log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            dontUseProxy = host.startsWith(start) && host.endsWith(end);
            if (!dontUseProxy) continue;
            this.log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
        }
        return dontUseProxy;
    }

    private boolean useSystemProxies() {
        if (this.useSystemProxies == null) {
            try {
                Class<?> clazz = Class.forName("sun.net.NetProperties");
                Method getBoolean = clazz.getMethod("getBoolean", String.class);
                this.useSystemProxies = getBoolean.invoke(null, "java.net.useSystemProxies");
            }
            catch (Exception x) {
                this.log.log(Level.FINEST, "Cannot get value of java.net.useSystemProxies bacause " + x.getMessage(), x);
            }
        }
        return this.useSystemProxies != null && "true".equalsIgnoreCase(this.useSystemProxies.toString());
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey().startsWith("proxy") || evt.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

